<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Clean up seed data from projects
        DB::table('projects')->whereIn('project_number', [
            'PRJ-2024-001',
            'PRJ-2024-002',
            'PRJ-2024-003',
            'PRJ-2024-004',
            'PRJ-2024-005',
            'PRJ-2024-006',
            'PRJ-2024-007',
            'PRJ-2024-008',
        ])->delete();

        // Clean up seed data from project_divisions
        DB::table('project_divisions')->whereIn('division_code', [
            'RC',
            'CC',
            'INF',
            'IND',
            'HC',
            'EDU',
            'RR',
            'CE',
        ])->delete();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Re-seed the data if needed (rollback)
        // You can call the seeders here if you want to restore the data
        // $this->call(ProjectDivisionSeeder::class);
        // $this->call(ProjectSeeder::class);
    }
};