<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            $table->bigInteger('outgoing_item_id')->unsigned()->nullable()->after('item_id');
            $table->foreign('outgoing_item_id')->references('id')->on('outgoing_items')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incoming_operation_items', function (Blueprint $table) {
            $table->dropForeign(['outgoing_item_id']);
            $table->dropColumn('outgoing_item_id');
        });
    }
};
