<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_delivery_items', function (Blueprint $table) {
            // Add return tracking fields
            $table->decimal('returned_quantity', 10, 2)->default(0)->after('rejected_quantity');
            $table->boolean('can_be_returned')->default(true)->after('rejection_reason');

            // Add indexes for return queries
            $table->index(['returned_quantity']);
            $table->index(['can_be_returned']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_delivery_items', function (Blueprint $table) {
            $table->dropIndex(['returned_quantity']);
            $table->dropIndex(['can_be_returned']);
            $table->dropColumn(['returned_quantity', 'can_be_returned']);
        });
    }
};
