<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            $table->string('material_request_number')->nullable()->after('material_request_id');
            $table->foreignId('outgoing_transaction_id')->nullable()->constrained('outgoing_transactions')->onDelete('set null')->after('material_request_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_deliveries', function (Blueprint $table) {
            $table->dropForeign(['outgoing_transaction_id']);
            $table->dropColumn(['material_request_number', 'outgoing_transaction_id']);
        });
    }
};
