<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('direct_delivery_items', function (Blueprint $table) {
            // Add supplier batch tracking
            $table->string('supplier_batch_number', 100)->nullable()->after('batch_number');

            // Add VAT tracking
            $table->decimal('vat_amount', 10, 2)->nullable()->after('tax_amount');
            $table->decimal('vat_rate', 5, 2)->nullable()->after('vat_amount');

            // Add production date if not exists
            if (!Schema::hasColumn('direct_delivery_items', 'production_date')) {
                $table->date('production_date')->nullable()->after('manufacturing_date');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('direct_delivery_items', function (Blueprint $table) {
            $table->dropColumn(['supplier_batch_number', 'vat_amount', 'vat_rate']);

            if (Schema::hasColumn('direct_delivery_items', 'production_date')) {
                $table->dropColumn('production_date');
            }
        });
    }
};