<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('items', function (Blueprint $table) {
            // Add unit_id foreign key
            $table->foreignId('unit_id')->nullable()->after('item_type_id')->constrained('units');

            // Keep the old unit_of_measure field for backward compatibility during migration
            // We can remove this later after data migration
            $table->string('unit_of_measure_old')->nullable()->after('unit_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('items', function (Blueprint $table) {
            $table->dropForeign(['unit_id']);
            $table->dropColumn(['unit_id', 'unit_of_measure_old']);
        });
    }
};