<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('material_issue_files', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('outgoing_transaction_id');
            $table->enum('issue_type', ['inventory', 'delivery', 'transfer']);
            $table->string('file_path');
            $table->string('original_filename');
            $table->unsignedBigInteger('uploaded_by');
            $table->timestamps();

            $table->foreign('outgoing_transaction_id')->references('id')->on('outgoing_transactions')->onDelete('cascade');
            $table->foreign('uploaded_by')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('material_issue_files');
    }
};
