<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('foc_inventory', function (Blueprint $table) {
            $table->enum('cost_responsibility', ['project', 'company', 'supplier', 'insurance', 'FOC Return', 'pending'])->default('pending')->after('quality_notes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('foc_inventory', function (Blueprint $table) {
            $table->dropColumn('cost_responsibility');
        });
    }
};
