<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Product;

class ProductsSeeder extends Seeder
{
    public function run(): void
    {
        $products = [
            // Float Glass Products
            [
                'name' => 'Premium Clear Float Glass',
                'slug' => 'premium-clear-float-glass',
                'description' => 'High-quality clear float glass with exceptional optical clarity and minimal distortion. Perfect for architectural glazing, furniture, and automotive applications.',
                'features' => 'Crystal clear transparency, High strength, UV resistant, Smooth surface finish, Available in various thicknesses',
                'category' => 'float-glass',
                'image' => 'images/products/clear-float-glass.jpg',
                'gallery' => json_encode([
                    'images/products/clear-float-glass.jpg',
                    'images/products/clear-float-glass-2.jpg',
                    'images/products/clear-float-glass-3.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 1,
            ],
            [
                'name' => 'Tinted Float Glass',
                'slug' => 'tinted-float-glass',
                'description' => 'High-performance tinted float glass offering solar control and enhanced privacy while maintaining excellent visibility.',
                'features' => 'Solar heat reduction, Glare control, Enhanced privacy, Available in multiple tints (bronze, grey, blue, green)',
                'category' => 'float-glass',
                'image' => 'images/products/tinted-float-glass.jpg',
                'gallery' => json_encode([
                    'images/products/tinted-float-glass.jpg',
                    'images/products/tinted-float-glass-2.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 2,
            ],
            [
                'name' => 'Low-E Float Glass',
                'slug' => 'low-e-float-glass',
                'description' => 'Energy-efficient low-emissivity float glass designed to improve thermal insulation and reduce energy costs.',
                'features' => 'Energy efficient, Thermal insulation, UV protection, Reduced heat transfer, Cost-effective',
                'category' => 'float-glass',
                'image' => 'images/products/low-e-float-glass.jpg',
                'gallery' => json_encode([
                    'images/products/low-e-float-glass.jpg',
                    'images/products/low-e-float-glass-2.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 3,
            ],

            // Mirror Glass Products
            [
                'name' => 'Silver Mirror Glass',
                'slug' => 'silver-mirror-glass',
                'description' => 'Premium quality silver mirror glass with excellent reflection properties and durability for residential and commercial use.',
                'features' => 'High reflectivity, Corrosion resistant, Moisture protection, Long-lasting silver coating, Multiple thickness options',
                'category' => 'mirror-glass',
                'image' => 'images/products/silver-mirror-glass.jpg',
                'gallery' => json_encode([
                    'images/products/silver-mirror-glass.jpg',
                    'images/products/silver-mirror-glass-2.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 4,
            ],
            [
                'name' => 'Antique Mirror Glass',
                'slug' => 'antique-mirror-glass',
                'description' => 'Decorative antique mirror glass with vintage appeal, perfect for interior design and artistic applications.',
                'features' => 'Vintage appearance, Unique patterns, Artistic finish, Decorative applications, Custom designs available',
                'category' => 'mirror-glass',
                'image' => 'images/products/antique-mirror-glass.jpg',
                'gallery' => json_encode([
                    'images/products/antique-mirror-glass.jpg',
                    'images/products/antique-mirror-glass-2.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 5,
            ],
            [
                'name' => 'Colored Mirror Glass',
                'slug' => 'colored-mirror-glass',
                'description' => 'Vibrant colored mirror glass available in various colors for creative architectural and decorative projects.',
                'features' => 'Multiple color options, Vibrant reflections, Decorative applications, Custom tinting, High-quality finish',
                'category' => 'mirror-glass',
                'image' => 'images/products/colored-mirror-glass.jpg',
                'gallery' => json_encode([
                    'images/products/colored-mirror-glass.jpg',
                    'images/products/colored-mirror-glass-2.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 6,
            ],

            // Pattern Glass Products
            [
                'name' => 'Bamboo Pattern Glass',
                'slug' => 'bamboo-pattern-glass',
                'description' => 'Elegant bamboo pattern glass providing privacy while allowing natural light transmission with beautiful texture.',
                'features' => 'Privacy protection, Natural light transmission, Elegant bamboo texture, Decorative appeal, Easy maintenance',
                'category' => 'pattern-glass',
                'image' => 'images/products/bamboo-pattern-glass.jpg',
                'gallery' => json_encode([
                    'images/products/bamboo-pattern-glass.jpg',
                    'images/products/bamboo-pattern-glass-2.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 7,
            ],
            [
                'name' => 'Fluted Pattern Glass',
                'slug' => 'fluted-pattern-glass',
                'description' => 'Modern fluted pattern glass with vertical ridges creating elegant light diffusion and contemporary aesthetic.',
                'features' => 'Vertical ridge pattern, Light diffusion, Modern aesthetic, Privacy screening, Architectural appeal',
                'category' => 'pattern-glass',
                'image' => 'images/products/fluted-pattern-glass.jpg',
                'gallery' => json_encode([
                    'images/products/fluted-pattern-glass.jpg',
                    'images/products/fluted-pattern-glass-2.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 8,
            ],
            [
                'name' => 'Diamond Pattern Glass',
                'slug' => 'diamond-pattern-glass',
                'description' => 'Sophisticated diamond pattern glass offering unique geometric design with excellent privacy and light control.',
                'features' => 'Diamond geometric pattern, Privacy control, Unique texture, Light scattering, Decorative functionality',
                'category' => 'pattern-glass',
                'image' => 'images/products/diamond-pattern-glass.jpg',
                'gallery' => json_encode([
                    'images/products/diamond-pattern-glass.jpg',
                    'images/products/diamond-pattern-glass-2.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 9,
            ],
            [
                'name' => 'Rain Pattern Glass',
                'slug' => 'rain-pattern-glass',
                'description' => 'Beautiful rain pattern glass mimicking natural raindrops for bathroom and partition applications.',
                'features' => 'Rain drop texture, Water-like appearance, Privacy enhancement, Natural aesthetics, Suitable for wet areas',
                'category' => 'pattern-glass',
                'image' => 'images/products/rain-pattern-glass.jpg',
                'gallery' => json_encode([
                    'images/products/rain-pattern-glass.jpg',
                    'images/products/rain-pattern-glass-2.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 10,
            ],

            // Specialty Glass Products
            [
                'name' => 'Tempered Safety Glass',
                'slug' => 'tempered-safety-glass',
                'description' => 'High-strength tempered safety glass providing enhanced security and safety for commercial and residential applications.',
                'features' => 'Impact resistant, Safety compliance, Heat treated, Thermal stress resistant, Breakage safety',
                'category' => 'safety-glass',
                'image' => 'images/products/tempered-safety-glass.jpg',
                'gallery' => json_encode([
                    'images/products/tempered-safety-glass.jpg',
                    'images/products/tempered-safety-glass-2.jpg'
                ]),
                'is_featured' => true,
                'is_active' => true,
                'order' => 11,
            ],
            [
                'name' => 'Laminated Glass',
                'slug' => 'laminated-glass',
                'description' => 'Multi-layer laminated glass offering superior security, sound insulation, and UV protection for demanding applications.',
                'features' => 'Security enhancement, Sound insulation, UV protection, Impact resistance, Interlayer technology',
                'category' => 'safety-glass',
                'image' => 'images/products/laminated-glass.jpg',
                'gallery' => json_encode([
                    'images/products/laminated-glass.jpg',
                    'images/products/laminated-glass-2.jpg'
                ]),
                'is_featured' => false,
                'is_active' => true,
                'order' => 12,
            ],
        ];

        foreach ($products as $productData) {
            Product::create($productData);
        }
    }
}