<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Permissions
        $permissions = [
            // User Management
            ['name' => 'manage_users', 'display_name' => 'Manage Users', 'description' => 'Create, update, delete users', 'group' => 'users'],
            ['name' => 'view_users', 'display_name' => 'View Users', 'description' => 'View user list and details', 'group' => 'users'],
            ['name' => 'create_users', 'display_name' => 'Create Users', 'description' => 'Create new users', 'group' => 'users'],
            ['name' => 'edit_users', 'display_name' => 'Edit Users', 'description' => 'Edit user information', 'group' => 'users'],
            ['name' => 'delete_users', 'display_name' => 'Delete Users', 'description' => 'Delete users', 'group' => 'users'],
            
            // Role Management
            ['name' => 'manage_roles', 'display_name' => 'Manage Roles', 'description' => 'Manage user roles and permissions', 'group' => 'roles'],
            ['name' => 'assign_roles', 'display_name' => 'Assign Roles', 'description' => 'Assign roles to users', 'group' => 'roles'],
            
            // Job Management
            ['name' => 'manage_jobs', 'display_name' => 'Manage Jobs', 'description' => 'Create, update, delete job positions', 'group' => 'jobs'],
            ['name' => 'view_jobs', 'display_name' => 'View Jobs', 'description' => 'View job positions', 'group' => 'jobs'],
            
            // Application Management
            ['name' => 'manage_applications', 'display_name' => 'Manage Applications', 'description' => 'Manage job applications', 'group' => 'applications'],
            ['name' => 'view_applications', 'display_name' => 'View Applications', 'description' => 'View job applications', 'group' => 'applications'],
            
            // Career Enquiries
            ['name' => 'manage_enquiries', 'display_name' => 'Manage Enquiries', 'description' => 'Manage career enquiries', 'group' => 'enquiries'],
            ['name' => 'view_enquiries', 'display_name' => 'View Enquiries', 'description' => 'View career enquiries', 'group' => 'enquiries'],
            
            // News Management
            ['name' => 'manage_news', 'display_name' => 'Manage News', 'description' => 'Create, update, delete news articles', 'group' => 'news'],
            ['name' => 'view_news', 'display_name' => 'View News', 'description' => 'View news articles in admin', 'group' => 'news'],
            
            // Video Management
            ['name' => 'manage_videos', 'display_name' => 'Manage Videos', 'description' => 'Create, update, delete videos', 'group' => 'videos'],
            ['name' => 'view_videos', 'display_name' => 'View Videos', 'description' => 'View videos in admin', 'group' => 'videos'],
            
            // Department Management
            ['name' => 'manage_departments', 'display_name' => 'Manage Departments', 'description' => 'Create, update, delete departments', 'group' => 'departments'],
            ['name' => 'view_departments', 'display_name' => 'View Departments', 'description' => 'View department list', 'group' => 'departments'],
            
            // Activity Logs
            ['name' => 'view_activity_logs', 'display_name' => 'View Activity Logs', 'description' => 'View user activity logs', 'group' => 'logs'],
            ['name' => 'manage_activity_logs', 'display_name' => 'Manage Activity Logs', 'description' => 'Manage and clear activity logs', 'group' => 'logs'],
            
            // Dashboard Access
            ['name' => 'access_admin_dashboard', 'display_name' => 'Access Admin Dashboard', 'description' => 'Access admin dashboard', 'group' => 'dashboard'],
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission['name']], $permission);
        }

        // Create Roles
        $roles = [
            [
                'name' => 'super_admin',
                'display_name' => 'Super Administrator',
                'description' => 'Full access to all system features',
                'permissions' => [
                    'manage_users', 'view_users', 'create_users', 'edit_users', 'delete_users',
                    'manage_roles', 'assign_roles',
                    'manage_jobs', 'view_jobs',
                    'manage_applications', 'view_applications',
                    'manage_enquiries', 'view_enquiries',
                    'manage_news', 'view_news',
                    'manage_videos', 'view_videos',
                    'manage_departments', 'view_departments',
                    'view_activity_logs', 'manage_activity_logs',
                    'access_admin_dashboard'
                ]
            ],
            [
                'name' => 'admin',
                'display_name' => 'Administrator',
                'description' => 'Admin access with limited user management',
                'permissions' => [
                    'view_users', 'create_users', 'edit_users',
                    'manage_jobs', 'view_jobs',
                    'manage_applications', 'view_applications',
                    'manage_enquiries', 'view_enquiries',
                    'manage_news', 'view_news',
                    'manage_videos', 'view_videos',
                    'access_admin_dashboard'
                ]
            ],
            [
                'name' => 'hr_manager',
                'display_name' => 'HR Manager',
                'description' => 'Manages applications and enquiries',
                'permissions' => [
                    'view_users',
                    'view_jobs',
                    'manage_applications', 'view_applications',
                    'manage_enquiries', 'view_enquiries',
                    'access_admin_dashboard'
                ]
            ],
            [
                'name' => 'viewer',
                'display_name' => 'Viewer',
                'description' => 'Read-only access to system',
                'permissions' => [
                    'view_users',
                    'view_jobs',
                    'view_applications',
                    'view_enquiries',
                    'view_videos',
                    'access_admin_dashboard'
                ]
            ]
        ];

        foreach ($roles as $roleData) {
            $permissions = $roleData['permissions'];
            unset($roleData['permissions']);
            
            $role = Role::firstOrCreate(['name' => $roleData['name']], $roleData);
            
            // Attach permissions to role
            $permissionIds = Permission::whereIn('name', $permissions)->pluck('id');
            $role->permissions()->sync($permissionIds);
        }

        $this->command->info('Roles and permissions seeded successfully!');
    }
}
