/* Mobile Products Filtering - Direct Implementation */
document.addEventListener('DOMContentLoaded', function() {
    if (window.innerWidth <= 768) {
        const tabs = document.querySelectorAll('.mobile-filter-tab');
        const productCards = document.querySelectorAll('.mobile-product-card');
        
        tabs.forEach(tab => {
            tab.addEventListener('click', function() {
                const category = this.dataset.category;
                
                // Update active tab
                tabs.forEach(t => t.classList.remove('active'));
                this.classList.add('active');
                
                // Filter products
                productCards.forEach(card => {
                    const productCategory = card.dataset.category;
                    const shouldShow = category === 'all' || productCategory === category;
                    
                    if (shouldShow) {
                        card.classList.remove('hidden');
                        card.style.display = 'flex';
                    } else {
                        card.classList.add('hidden');
                    }
                });
            });
        });
    }
});