@extends('layouts.admin-simple')

@section('title', 'Activity Logs')
@section('page-title', 'Activity Logs')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active" aria-current="page">Activity Logs</li>
@endsection

@section('content')
    <!-- Filters -->
    <div class="card mb-3">
        <div class="card-body">
            <form method="GET" class="row align-items-end">
                <div class="col-md-2">
                    <label for="user_id" class="form-label">User</label>
                    <select class="form-control" id="user_id" name="user_id">
                        <option value="">All Users</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                {{ $user->full_name ?? $user->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="action" class="form-label">Action</label>
                    <select class="form-control" id="action" name="action">
                        <option value="">All Actions</option>
                        @foreach($actions as $action)
                            <option value="{{ $action }}" {{ request('action') == $action ? 'selected' : '' }}>
                                {{ ucwords(str_replace('_', ' ', $action)) }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="from_date" class="form-label">From Date</label>
                    <input type="date" class="form-control" id="from_date" name="from_date" value="{{ request('from_date') }}">
                </div>
                <div class="col-md-2">
                    <label for="to_date" class="form-label">To Date</label>
                    <input type="date" class="form-control" id="to_date" name="to_date" value="{{ request('to_date') }}">
                </div>
                <div class="col-md-2">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Search description...">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-outline-primary">
                        <i class="material-icons">search</i> Filter
                    </button>
                    <a href="{{ route('admin.activity-logs') }}" class="btn btn-outline-secondary">
                        <i class="material-icons">clear</i> Clear
                    </a>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Activity Logs Table -->
    <div class="card">
        <div class="card-header card-header-large bg-white d-flex align-items-center">
            <div class="flex">
                <h4 class="card-header__title">Activity Logs</h4>
                <div class="card-subtitle text-muted">System activity and audit trail</div>
            </div>
            @if(auth()->user()->hasPermission('manage_activity_logs'))
            <div class="ml-auto">
                <button class="btn btn-sm btn-outline-danger" data-toggle="modal" data-target="#clearLogsModal">
                    <i class="material-icons">delete_sweep</i> Clear Old Logs
                </button>
            </div>
            @endif
        </div>
        
        <div class="table-responsive">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th>Date & Time</th>
                        <th>User</th>
                        <th>Action</th>
                        <th>Description</th>
                        <th>IP Address</th>
                        <th>Details</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($activities as $activity)
                    <tr>
                        <td>
                            <div>{{ $activity->created_at->format('M d, Y') }}</div>
                            <div class="text-muted small">{{ $activity->created_at->format('H:i:s') }}</div>
                        </td>
                        <td>
                            @if($activity->user)
                                <div>{{ $activity->user->full_name ?? $activity->user->name }}</div>
                                <div class="text-muted small">{{ $activity->user->email }}</div>
                            @else
                                <span class="text-muted">System</span>
                            @endif
                        </td>
                        <td>
                            @php
                                $actionClass = match(true) {
                                    str_contains($activity->action, 'created') => 'badge-soft-success',
                                    str_contains($activity->action, 'updated') => 'badge-soft-info',
                                    str_contains($activity->action, 'deleted') => 'badge-soft-danger',
                                    str_contains($activity->action, 'login') => 'badge-soft-primary',
                                    str_contains($activity->action, 'logout') => 'badge-soft-warning',
                                    default => 'badge-soft-secondary'
                                };
                            @endphp
                            <span class="badge {{ $actionClass }}">
                                {{ ucwords(str_replace('_', ' ', $activity->action)) }}
                            </span>
                        </td>
                        <td>{{ $activity->description }}</td>
                        <td>{{ $activity->ip_address ?? '-' }}</td>
                        <td>
                            @if($activity->properties && count($activity->properties) > 0)
                                <button type="button" class="btn btn-sm btn-outline-info" 
                                        onclick="showDetails({{ json_encode($activity->properties) }})">
                                    <i class="material-icons">info</i> View
                                </button>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <div class="empty-state">
                                <i class="material-icons mb-3" style="font-size: 48px; color: #ddd;">history</i>
                                <h5 class="text-muted">No activity logs found</h5>
                                <p class="text-muted">
                                    @if(request()->hasAny(['user_id', 'action', 'from_date', 'to_date', 'search']))
                                        Try adjusting your filter criteria.
                                    @else
                                        Activity logs will appear here as users interact with the system.
                                    @endif
                                </p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($activities->hasPages())
            <div class="card-footer">
                {{ $activities->appends(request()->query())->links('pagination::flowdash') }}
            </div>
        @endif
    </div>
@endsection

@section('modals')
<!-- Details Modal -->
<div class="modal fade" id="detailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Activity Details</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <pre id="detailsContent" class="bg-light p-3"></pre>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

@if(auth()->user()->hasPermission('manage_activity_logs'))
<!-- Clear Logs Modal -->
<div class="modal fade" id="clearLogsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Clear Old Activity Logs</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" action="{{ route('admin.activity-logs.clear') }}">
                @csrf
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="material-icons">warning</i>
                        This action will permanently delete old activity logs and cannot be undone.
                    </div>
                    
                    <div class="form-group">
                        <label for="days">Delete logs older than (days):</label>
                        <input type="number" class="form-control" id="days" name="days" 
                               min="30" value="90" required>
                        <small class="form-text text-muted">Minimum: 30 days</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">
                        <i class="material-icons mr-2">delete_forever</i> Clear Logs
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
@endsection

@push('scripts')
<script>
function showDetails(properties) {
    document.getElementById('detailsContent').textContent = JSON.stringify(properties, null, 2);
    $('#detailsModal').modal('show');
}
</script>
@endpush