@extends('layouts.admin-simple')

@section('title', 'Create Role')
@section('page-title', 'Create Role')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.roles') }}">Roles</a></li>
    <li class="breadcrumb-item active" aria-current="page">Create Role</li>
@endsection

@section('content')
    <form method="POST" action="{{ route('admin.roles.store') }}" id="createRoleForm">
        @csrf
        
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-white">
                        <h4 class="card-header__title">Role Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="name">Role Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                   id="name" name="name" value="{{ old('name') }}" required
                                   pattern="[a-z_]+" placeholder="e.g., content_editor">
                            <small class="form-text text-muted">Use lowercase letters and underscores only</small>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="display_name">Display Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('display_name') is-invalid @enderror" 
                                   id="display_name" name="display_name" value="{{ old('display_name') }}" required
                                   placeholder="e.g., Content Editor">
                            @error('display_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" name="description" rows="3"
                                      placeholder="Describe what this role can do...">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
                
                <div class="card mt-3">
                    <div class="card-header bg-white">
                        <h4 class="card-header__title">Permissions</h4>
                        <div class="card-subtitle text-muted">Select permissions for this role</div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="selectAll()">Select All</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="deselectAll()">Deselect All</button>
                        </div>
                        
                        @foreach($permissions as $group => $groupPermissions)
                        <div class="permission-group mb-4">
                            <h6 class="text-uppercase text-muted mb-3">
                                <i class="material-icons mr-1" style="font-size: 18px;">folder</i>
                                {{ ucfirst(str_replace('_', ' ', $group)) }}
                            </h6>
                            <div class="row">
                                @foreach($groupPermissions as $permission)
                                <div class="col-md-6 col-lg-4">
                                    <div class="custom-control custom-checkbox mb-2">
                                        <input type="checkbox" class="custom-control-input permission-checkbox" 
                                               id="permission_{{ $permission->id }}" 
                                               name="permissions[]" 
                                               value="{{ $permission->id }}"
                                               data-group="{{ $group }}"
                                               {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="permission_{{ $permission->id }}">
                                            {{ $permission->display_name }}
                                            @if($permission->description)
                                                <i class="material-icons text-muted" style="font-size: 14px;" 
                                                   data-toggle="tooltip" title="{{ $permission->description }}">info</i>
                                            @endif
                                        </label>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                
                <div class="card-footer bg-white">
                    <a href="{{ route('admin.roles') }}" class="btn btn-secondary">
                        <i class="material-icons mr-2">arrow_back</i> Cancel
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="material-icons mr-2">save</i> Create Role
                    </button>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header bg-white">
                        <h5 class="card-header__title">Quick Tips</h5>
                    </div>
                    <div class="card-body">
                        <h6>Role Naming Convention:</h6>
                        <ul class="small">
                            <li>Use lowercase letters only</li>
                            <li>Use underscores for spaces</li>
                            <li>Be descriptive but concise</li>
                            <li>Examples: content_editor, report_viewer, data_analyst</li>
                        </ul>
                        
                        <hr>
                        
                        <h6>Permission Groups:</h6>
                        <p class="small text-muted">Permissions are organized by functional areas. Select all relevant permissions for the role you're creating.</p>
                        
                        <hr>
                        
                        <h6>Security Note:</h6>
                        <p class="small text-muted">Follow the principle of least privilege - only grant permissions that are absolutely necessary for the role.</p>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection

@push('scripts')
<script>
function selectAll() {
    document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
        checkbox.checked = true;
    });
}

function deselectAll() {
    document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
        checkbox.checked = false;
    });
}

// Initialize tooltips
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
});

// Form validation
document.getElementById('name').addEventListener('input', function() {
    this.value = this.value.toLowerCase().replace(/[^a-z_]/g, '');
});
</script>
@endpush