<!-- Global Footer Component -->
<footer class="aufg-global-footer" id="aufgGlobalFooter">
    <!-- Newsletter Section -->
    <div class="aufg-footer-newsletter">
        <div class="aufg-footer-container">
            <div class="aufg-newsletter-content">
                <div class="aufg-newsletter-text">
                    <h3 class="aufg-newsletter-title">Join our newsletter</h3>
                    <p class="aufg-newsletter-subtitle">Subscribe to Join Arabian United Glass Company (UFG) Newsletter</p>
                </div>
                
                <div class="aufg-newsletter-form">
                    <form action="{{ route('newsletter.subscribe') }}" method="POST" id="newsletterForm">
                        @csrf
                        <div class="aufg-newsletter-input-wrapper">
                            <input type="email" 
                                   class="aufg-newsletter-input" 
                                   placeholder="Enter your email" 
                                   id="aufgNewsletterEmail"
                                   name="email"
                                   required>
                            <button type="submit" class="aufg-newsletter-btn" id="aufgNewsletterSubmit">Subscribe</button>
                        </div>
                    </form>
                    <p class="aufg-newsletter-privacy">
                        By subscribing you agree to with our <a href="{{ route('privacy') }}" class="aufg-privacy-link">Privacy Policy</a>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Footer Content -->
    <div class="aufg-footer-main">
        <div class="aufg-footer-container">
            <div class="aufg-footer-grid">
                <!-- Logo Section -->
                <div class="aufg-footer-column aufg-footer-brand">
                    <div class="aufg-footer-logos">
                        <a href="{{ route('home') }}" class="aufg-footer-logo-link" title="Go to Home Page">
                            <img src="{{ asset($siteSettings['site_logo'] ?? 'assets/images/aufg-logo.png') }}" class="aufg-footer-logo" alt="{{ $siteSettings['site_name'] ?? 'UFG' }} Logo" loading="lazy">
                        </a>
                        <img src="{{ asset('assets/images/vision-2030-logo.png') }}" class="aufg-footer-vision-logo" alt="Saudi Vision 2030 Logo" loading="lazy">
                    </div>
                </div>

                <!-- Company Links -->
                <div class="aufg-footer-column">
                    <h4 class="aufg-footer-heading">Company</h4>
                    <ul class="aufg-footer-links">
                        <li><a href="{{ route('about') }}" class="aufg-footer-link">About Us</a></li>
                        <li><a href="{{ route('quality') }}" class="aufg-footer-link">Awards & Certifications</a></li>
                        <li><a href="{{ route('investors') }}" class="aufg-footer-link">Tadawol</a></li>
                        <li><a href="{{ route('investors') }}" class="aufg-footer-link">Shareholder</a></li>
                    </ul>
                </div>

                <!-- Products Links -->
                <div class="aufg-footer-column">
                    <h4 class="aufg-footer-heading">Our Products</h4>
                    <ul class="aufg-footer-links">
                        <li><a href="{{ route('products.mirror-glass') }}" class="aufg-footer-link">Decorative Mirror</a></li>
                        <li><a href="{{ route('products.float-glass') }}" class="aufg-footer-link">Clear Float</a></li>
                        <li><a href="{{ route('products.pattern-glass') }}" class="aufg-footer-link">Pattern Glass</a></li>
                        <li><a href="{{ route('products.mirror-glass') }}" class="aufg-footer-link">Silver Mirror</a></li>
                    </ul>
                </div>

                <!-- More Links -->
                <div class="aufg-footer-column">
                    <h4 class="aufg-footer-heading">More</h4>
                    <ul class="aufg-footer-links">
                        <li><a href="{{ route('investors') }}" class="aufg-footer-link">Investors</a></li>
                        <li><a href="{{ route('videos') }}" class="aufg-footer-link">Gallery</a></li>
                        <li><a href="{{ route('careers') }}" class="aufg-footer-link">Services</a></li>
                        <li><a href="{{ route('news') }}" class="aufg-footer-link">News</a></li>
                    </ul>
                </div>

                <!-- Contact Info -->
                <div class="aufg-footer-column">
                    <h4 class="aufg-footer-heading">Contact</h4>
                    <div class="aufg-footer-contact">
                        <div class="aufg-contact-item">
                            <div class="aufg-contact-icon">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
                                </svg>
                            </div>
                            <a href="tel:{{ site_setting('contact_phone_raw', '966556003206') }}" class="aufg-contact-text">{{ site_setting('contact_phone', '+966 556 003 206') }}</a>
                        </div>
                        
                        <div class="aufg-contact-item">
                            <div class="aufg-contact-icon">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                    <polyline points="22,6 12,13 2,6"/>
                                </svg>
                            </div>
                            <a href="mailto:{{ site_setting('contact_email', 'info@aufgc.com') }}" class="aufg-contact-text">{{ site_setting('contact_email', 'info@aufgc.com') }}</a>
                        </div>
                    </div>
                    
                    <!-- Social Media -->
                    <div class="aufg-footer-social">
                        @if(site_setting('social_linkedin_url'))
                        <a href="{{ site_setting('social_linkedin_url') }}" target="_blank" rel="noopener" class="aufg-social-link linkedin" title="Follow us on LinkedIn">
                            <svg viewBox="0 0 24 24" fill="currentColor" width="20" height="20">
                                <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                            </svg>
                        </a>
                        @endif
                        @if(site_setting('social_twitter_url'))
                        <a href="{{ site_setting('social_twitter_url') }}" target="_blank" rel="noopener" class="aufg-social-link x-twitter" title="Follow us on X (Twitter)">
                            <svg viewBox="0 0 24 24" fill="currentColor" width="20" height="20">
                                <path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/>
                            </svg>
                        </a>
                        @endif
                        @if(site_setting('social_instagram_url'))
                        <a href="{{ site_setting('social_instagram_url') }}" target="_blank" rel="noopener" class="aufg-social-link instagram" title="Follow us on Instagram">
                            <svg viewBox="0 0 24 24" fill="currentColor" width="20" height="20">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                        </a>
                        @endif
                        @if(site_setting('social_facebook_url'))
                        <a href="{{ site_setting('social_facebook_url') }}" target="_blank" rel="noopener" class="aufg-social-link facebook" title="Follow us on Facebook">
                            <svg viewBox="0 0 24 24" fill="currentColor" width="20" height="20">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer Bottom -->
    <div class="aufg-footer-bottom">
        <div class="aufg-footer-container">
            <div class="aufg-footer-bottom-content">
                <div class="aufg-footer-left">
                    <p class="aufg-footer-copyright">
                        © <span id="aufgCurrentYear">{{ date('Y') }}</span> {{ site_setting('copyright_text', 'Arabian United Float Glass Company (UFG) All rights reserved') }}
                    </p>
                </div>
                <div class="aufg-footer-center">
                    <div class="aufg-footer-legal">
                        <a href="{{ route('terms') }}" class="aufg-legal-link">Terms & conditions</a>
                        <a href="{{ route('privacy') }}" class="aufg-legal-link">Privacy policy</a>
                    </div>
                </div>
                <div class="aufg-footer-right">
                    <p class="aufg-footer-credits">Designed & Developed by Artisans</p>
                </div>
            </div>
        </div>
    </div>
</footer>