<!-- Warehouse Form Card Component -->
@props([
    'title' => '',
    'subtitle' => '',
    'submitText' => 'Save',
    'cancelUrl' => null,
    'method' => 'POST',
    'action' => '',
    'enctype' => null
])

<div class="warehouse-form-card card">
    <!-- Form Header -->
    @if($title || $subtitle)
        <div class="card-header bg-white border-bottom">
            @if($title)
                <h5 class="card-title mb-0">{{ $title }}</h5>
            @endif
            @if($subtitle)
                <p class="text-muted mb-0 mt-1">{{ $subtitle }}</p>
            @endif
        </div>
    @endif

    <!-- Form Content -->
    <form method="{{ $method === 'GET' ? 'GET' : 'POST' }}"
          action="{{ $action }}"
          @if($enctype) enctype="{{ $enctype }}" @endif
          class="warehouse-form">

        @if($method !== 'GET' && $method !== 'POST')
            @method($method)
        @endif

        @if($method !== 'GET')
            @csrf
        @endif

        <div class="card-body">
            <!-- Form Fields -->
            {{ $slot }}
        </div>

        <!-- Form Footer -->
        <div class="card-footer bg-light border-top">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    @if($cancelUrl)
                        <a href="{{ $cancelUrl }}" class="btn btn-outline-secondary">
                            <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                            Cancel
                        </a>
                    @endif
                </div>
                <div>
                    <button type="submit" class="btn btn-primary">
                        <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                        {{ $submitText }}
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

<style>
.warehouse-form-card {
    border: none;
    box-shadow: 0 2px 4px rgba(0,0,0,0.08);
    border-radius: 8px;
    overflow: hidden;
}

.warehouse-form .form-group {
    margin-bottom: 1.5rem;
}

.warehouse-form .form-label {
    font-weight: 600;
    color: #495057;
    margin-bottom: 0.5rem;
}

.warehouse-form .form-control {
    border-radius: 4px;
    border: 1px solid #ced4da;
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}

.warehouse-form .form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25);
}

.warehouse-form .form-text {
    font-size: 0.8rem;
    color: #6c757d;
    margin-top: 0.25rem;
}

.warehouse-form .required {
    color: #dc3545;
}

.warehouse-form .is-invalid {
    border-color: #dc3545;
}

.warehouse-form .invalid-feedback {
    color: #dc3545;
    font-size: 0.8rem;
    margin-top: 0.25rem;
}

.warehouse-form .custom-file-label {
    border-radius: 4px;
}

.warehouse-form .input-group-text {
    background-color: #f8f9fa;
    border-color: #ced4da;
}

@media (max-width: 768px) {
    .warehouse-form-card .card-footer .d-flex {
        flex-direction: column;
    }

    .warehouse-form-card .card-footer .btn {
        width: 100%;
        margin-bottom: 0.5rem;
    }

    .warehouse-form-card .card-footer .btn:last-child {
        margin-bottom: 0;
    }
}
</style>