<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Warehouse Management') - {{ $siteSettings['site_name'] ?? 'KCG Inventory' }}</title>

    <!-- Warehouse Favicon -->
    <link rel="icon" type="image/png" href="{{ asset($siteSettings['admin_favicon'] ?? $siteSettings['site_favicon'] ?? 'images/favicon.ico') }}">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap4.min.css" onerror="console.error('❌ DataTables CSS failed to load');" onload="console.log('✅ DataTables CSS loaded');">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.4.1/css/responsive.bootstrap4.min.css" onerror="console.error('❌ DataTables Responsive CSS failed to load');" onload="console.log('✅ DataTables Responsive CSS loaded');">

    <!-- Admin Assets -->
    <link type="text/css" href="{{ asset('admin-assets/css/app.css') }}" rel="stylesheet">
    <link type="text/css" href="{{ asset('admin-assets/css/admin-custom.css') }}" rel="stylesheet">

    <!-- Warehouse Components CSS -->
    <link type="text/css" href="{{ asset('admin-assets/css/warehouse-components.css') }}" rel="stylesheet">

    <!-- Warehouse Custom Styles -->
    <style>
        :root {
            --warehouse-primary: #2196F3;
            --warehouse-secondary: #607D8B;
            --warehouse-success: #4CAF50;
            --warehouse-warning: #FF9800;
            --warehouse-danger: #F44336;
            --warehouse-info: #00BCD4;
            --warehouse-light: #F5F5F5;
            --warehouse-dark: #263238;
        }

        .warehouse-header {
            background: linear-gradient(135deg, var(--warehouse-primary), var(--warehouse-secondary));
            color: white;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        .warehouse-sidebar {
            background: #263238;
            min-height: 100vh;
        }

        .warehouse-content {
            background: #f8f9fa;
            min-height: calc(100vh - 70px);
        }

        .warehouse-card {
            border: none;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.08);
            transition: all 0.3s ease;
        }

        .warehouse-card:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }

        .warehouse-stat-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            border-left: 4px solid var(--warehouse-primary);
            transition: all 0.3s ease;
        }

        .warehouse-stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .warehouse-nav-link {
            color: rgba(255,255,255,0.8);
            padding: 12px 20px;
            display: flex;
            align-items: center;
            text-decoration: none;
            transition: all 0.3s ease;
            border-radius: 4px;
            margin: 2px 10px;
        }

        .warehouse-nav-link:hover,
        .warehouse-nav-link.active {
            background: rgba(255,255,255,0.1);
            color: white;
            text-decoration: none;
        }

        .warehouse-nav-icon {
            margin-right: 12px;
            width: 20px;
            text-align: center;
        }

        .warehouse-breadcrumb {
            background: transparent;
            padding: 0;
            margin: 0;
        }

        .warehouse-breadcrumb .breadcrumb-item + .breadcrumb-item::before {
            content: ">";
            color: #6c757d;
        }

        @media (max-width: 768px) {
            .warehouse-sidebar {
                position: fixed;
                left: -250px;
                top: 0;
                width: 250px;
                z-index: 1000;
                transition: left 0.3s ease;
            }

            .warehouse-sidebar.show {
                left: 0;
            }

            .warehouse-content {
                margin-left: 0;
            }
        }
    </style>

    @stack('styles')
</head>

<body class="warehouse-layout">
    <!-- Warehouse Header -->
    @include('components.warehouse.header')

    <div class="d-flex">
        <!-- Warehouse Sidebar -->
        @include('components.warehouse.sidebar')

        <!-- Main Content -->
        <div class="flex-fill warehouse-content">
            <!-- Page Header -->
            <div class="container-fluid py-3">
                <!-- Breadcrumb -->
                @if(View::hasSection('breadcrumb'))
                    <nav aria-label="breadcrumb">
                        <ol class="warehouse-breadcrumb breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('warehouse.dashboard') }}">
                                    <i class="material-icons" style="font-size: 16px; vertical-align: middle;">home</i>
                                    Warehouse
                                </a>
                            </li>
                            @yield('breadcrumb')
                        </ol>
                    </nav>
                @endif

                <!-- Page Title & Actions -->
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <h1 class="h3 mb-0 text-dark">@yield('page-title', 'Dashboard')</h1>
                        @if(View::hasSection('page-subtitle'))
                            <p class="text-muted mb-0">@yield('page-subtitle')</p>
                        @endif
                    </div>
                    <div>
                        @yield('page-actions')
                    </div>
                </div>
            </div>

            <!-- Page Content -->
            <div class="container-fluid pb-4">
                <!-- Flash Messages -->
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="material-icons mr-2" style="vertical-align: middle;">check_circle</i>
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="material-icons mr-2" style="vertical-align: middle;">error</i>
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if(session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <i class="material-icons mr-2" style="vertical-align: middle;">warning</i>
                        {{ session('warning') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if(session('info'))
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <i class="material-icons mr-2" style="vertical-align: middle;">info</i>
                        {{ session('info') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @yield('content')
            </div>
        </div>
    </div>

    @yield('modals')

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>

    <!-- DataTables JavaScript -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js" onerror="console.error('❌ DataTables JS failed to load');" onload="console.log('✅ DataTables JS loaded');"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap4.min.js" onerror="console.error('❌ DataTables Bootstrap JS failed to load');" onload="console.log('✅ DataTables Bootstrap JS loaded');"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/responsive/2.4.1/js/dataTables.responsive.min.js" onerror="console.error('❌ DataTables Responsive JS failed to load');" onload="console.log('✅ DataTables Responsive JS loaded');"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/responsive/2.4.1/js/responsive.bootstrap4.min.js" onerror="console.error('❌ DataTables Responsive Bootstrap JS failed to load');" onload="console.log('✅ DataTables Responsive Bootstrap JS loaded');"></script>

    <!-- Admin Assets -->
    <script src="{{ asset('admin-assets/vendor/dom-factory.js') }}"></script>
    <script src="{{ asset('admin-assets/vendor/material-design-kit.js') }}"></script>
    <script src="{{ asset('admin-assets/js/app.js') }}"></script>

    <!-- Warehouse Custom JavaScript -->
    <script>
        $(document).ready(function() {
            // Mobile sidebar toggle
            $('#sidebarToggle').on('click', function() {
                $('.warehouse-sidebar').toggleClass('show');
            });

            // Close sidebar when clicking outside on mobile
            $(document).on('click', function(e) {
                if ($(window).width() <= 768) {
                    if (!$(e.target).closest('.warehouse-sidebar, #sidebarToggle').length) {
                        $('.warehouse-sidebar').removeClass('show');
                    }
                }
            });

            // Auto-hide alerts after 5 seconds
            setTimeout(function() {
                $('.alert').fadeOut();
            }, 5000);
        });
    </script>

    <!-- DataTables Fallback & Configuration -->
    <script>
        $(document).ready(function() {
            console.log('🔍 DataTables Debug Info:', {
                jQuery: typeof $,
                jQueryVersion: $.fn ? $.fn.jquery : 'Not available',
                DataTable: typeof $.fn.DataTable,
                dataTableVersion: $.fn.DataTable ? $.fn.DataTable.version : 'Not available'
            });

            function initializeDataTables() {
                if (typeof $.fn.DataTable !== 'undefined') {
                    // Set DataTables default configuration
                    $.extend(true, $.fn.dataTable.defaults, {
                        responsive: true,
                        pageLength: 25,
                        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                        language: {
                            search: "Search:",
                            lengthMenu: "Show _MENU_ entries",
                            info: "Showing _START_ to _END_ of _TOTAL_ entries",
                            infoEmpty: "Showing 0 to 0 of 0 entries",
                            infoFiltered: "(filtered from _MAX_ total entries)",
                            paginate: {
                                first: "First",
                                last: "Last",
                                next: "Next",
                                previous: "Previous"
                            }
                        },
                        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" +
                             "<'row'<'col-sm-12'tr>>" +
                             "<'row'<'col-sm-5'i><'col-sm-7'p>>",
                        order: []
                    });

                    // Auto-initialize DataTables on tables with 'dataTable' class
                    if ($('.dataTable').length > 0) {
                        console.log('🔍 Found', $('.dataTable').length, 'tables to initialize');
                        $('.dataTable').DataTable();
                        console.log('✅ DataTables initialized successfully');
                    }
                    return true;
                }
                return false;
            }

            // Try immediate initialization
            if (!initializeDataTables()) {
                console.log('🔄 DataTables not ready, waiting...');

                // Try after timeout
                setTimeout(function() {
                    console.log('🔍 DataTables Debug (after timeout):', {
                        jQuery: typeof $,
                        DataTable: typeof $.fn.DataTable
                    });

                    if (!initializeDataTables()) {
                        console.error('❌ DataTables library not loaded after timeout');
                        console.log('🔍 Available jQuery plugins:', Object.keys($.fn));

                        // Try loading fallback from different CDN
                        const fallbackScript = document.createElement('script');
                        fallbackScript.src = 'https://cdn.jsdelivr.net/npm/datatables.net@1.13.4/js/jquery.dataTables.min.js';
                        fallbackScript.onload = function() {
                            console.log('📦 Fallback DataTables loaded from jsdelivr');

                            const fallbackBootstrapScript = document.createElement('script');
                            fallbackBootstrapScript.src = 'https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/js/dataTables.bootstrap4.min.js';
                            fallbackBootstrapScript.onload = function() {
                                console.log('📦 Fallback DataTables Bootstrap loaded');
                                setTimeout(initializeDataTables, 100);
                            };
                            document.head.appendChild(fallbackBootstrapScript);
                        };
                        fallbackScript.onerror = function() {
                            console.error('❌ Fallback DataTables also failed to load');
                            // Remove dataTable class to prevent further errors
                            $('.dataTable').removeClass('dataTable').addClass('table-simple');
                            console.log('🔧 Tables converted to simple tables');
                        };
                        document.head.appendChild(fallbackScript);
                    }
                }, 1000);
            }
        });
    </script>

    @stack('scripts')
</body>
</html>