@extends('layouts.admin-simple')

@section('title', 'Process Direct Delivery Receipt')

@push('styles')
<style>
.select2-container {
    width: 100% !important;
}

.select2-dropdown {
    min-width: 200px;
    max-width: 400px;
    width: auto !important;
}

.select2-container .select2-selection--single {
    min-width: 200px;
    max-width: 100%;
}

.select2-container--open .select2-dropdown--below {
    width: auto !important;
    min-width: 200px;
}

.info-section {
    background-color: #f8f9fa;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 20px;
}

.delivery-summary {
    border-left: 4px solid #007bff;
    padding-left: 15px;
}

.quality-status-pending { background-color: #ffc107; }
.quality-status-passed { background-color: #28a745; }
.quality-status-failed { background-color: #dc3545; }
.quality-status-partial { background-color: #17a2b8; }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">
                        <i class="material-icons mr-2">receipt</i>
                        Process Direct Delivery Receipt
                    </h4>
                </div>

                <!-- Delivery Summary -->
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-section delivery-summary">
                                <h6 class="font-weight-bold mb-3">Delivery Information</h6>
                                <p class="mb-1"><strong>Delivery #:</strong> {{ $directDelivery->delivery_number }}</p>
                                <p class="mb-1"><strong>Supplier:</strong>
                                    @if($directDelivery->supplier)
                                        {{ $directDelivery->supplier->name }}
                                    @else
                                        <span class="text-muted">Pending Supplier Selection</span>
                                    @endif
                                </p>
                                <p class="mb-1"><strong>Project:</strong> {{ $directDelivery->project->project_name }}</p>
                                <p class="mb-1"><strong>Delivery Date:</strong> {{ $directDelivery->delivery_date->format('M d, Y') }}</p>
                                @if($directDelivery->purchase_order_number)
                                <p class="mb-1"><strong>PO Number:</strong> {{ $directDelivery->purchase_order_number }}</p>
                                @endif
                                <p class="mb-0"><strong>Status:</strong>
                                    <span class="badge badge-{{ $directDelivery->status_color }}">
                                        {{ ucfirst(str_replace('_', ' ', $directDelivery->status)) }}
                                    </span>
                                </p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="info-section">
                                <h6 class="font-weight-bold mb-3">Receipt Instructions</h6>
                                <ul class="mb-0">
                                    <li>Verify quantities received against delivery note</li>
                                    <li>Inspect quality of each item</li>
                                    <li>Record any damaged or rejected items</li>
                                    <li>Specify storage location for accepted items</li>
                                    <li>Add notes for any discrepancies</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Receipt Form -->
                <form action="{{ route('warehouse.direct-deliveries.process-receipt', $directDelivery) }}" method="POST">
                    @csrf
                    <div class="card-body border-top">
                        <div class="row">
                            <div class="col-12">
                                <h5 class="border-bottom pb-2 mb-3">
                                    <i class="material-icons mr-2">inventory</i>
                                    Items to Receive ({{ $directDelivery->items->count() }})
                                </h5>

                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead class="thead-light">
                                            <tr>
                                                <th width="20%">Item</th>
                                                <th width="8%">Delivered</th>
                                                <th width="8%">Received</th>
                                                <th width="8%">Rejected</th>
                                                <th width="8%">Unit</th>
                                                <th width="12%">Quality Status</th>
                                                <th width="12%">Storage Location</th>
                                                <th width="24%">Notes</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($directDelivery->items as $index => $item)
                                            <tr>
                                                <td>
                                                    <strong>{{ $item->item->item_description }}</strong>
                                                    @if($item->item->item_code)
                                                    <br><small class="text-muted">{{ $item->item->item_code }}</small>
                                                    @endif
                                                    @if($item->batch_number)
                                                    <br><small class="text-info">Batch: {{ $item->batch_number }}</small>
                                                    @endif
                                                    @if($item->expiry_date)
                                                    <br><small class="text-warning">Exp: {{ $item->expiry_date->format('M d, Y') }}</small>
                                                    @endif
                                                    <input type="hidden" name="items[{{ $index }}][item_id]" value="{{ $item->id }}">
                                                </td>
                                                <td class="text-center">
                                                    <strong class="text-primary">{{ number_format($item->delivered_quantity, 2) }}</strong>
                                                    @if($item->unit_of_measure)
                                                    <br><small class="text-muted">{{ $item->unit_of_measure }}</small>
                                                    @endif
                                                </td>
                                                <td>
                                                    <input type="number" name="items[{{ $index }}][received_quantity]"
                                                           class="form-control @error("items.{$index}.received_quantity") is-invalid @enderror"
                                                           value="{{ old("items.{$index}.received_quantity", $item->delivered_quantity) }}"
                                                           step="0.01" min="0" max="{{ $item->delivered_quantity }}"
                                                           onchange="calculateRejected({{ $index }})" required>
                                                    @error("items.{$index}.received_quantity")
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </td>
                                                <td>
                                                    <input type="number" name="items[{{ $index }}][rejected_quantity]"
                                                           class="form-control @error("items.{$index}.rejected_quantity") is-invalid @enderror"
                                                           value="{{ old("items.{$index}.rejected_quantity", 0) }}"
                                                           step="0.01" min="0" readonly>
                                                    @error("items.{$index}.rejected_quantity")
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </td>
                                                <td class="text-center">
                                                    <small class="text-muted">{{ $item->unit_of_measure ?: '-' }}</small>
                                                    <br><small class="text-success">{{ config('app.currency', 'AED') }} {{ number_format($item->unit_price, 2) }}</small>
                                                </td>
                                                <td>
                                                    <select name="items[{{ $index }}][quality_status]"
                                                            class="form-control @error("items.{$index}.quality_status") is-invalid @enderror" required>
                                                        <option value="">Select Status</option>
                                                        <option value="pending" {{ old("items.{$index}.quality_status") == 'pending' ? 'selected' : '' }}>Pending Inspection</option>
                                                        <option value="passed" {{ old("items.{$index}.quality_status") == 'passed' ? 'selected' : '' }}>Passed</option>
                                                        <option value="partial" {{ old("items.{$index}.quality_status") == 'partial' ? 'selected' : '' }}>Partial Pass</option>
                                                        <option value="failed" {{ old("items.{$index}.quality_status") == 'failed' ? 'selected' : '' }}>Failed</option>
                                                    </select>
                                                    @error("items.{$index}.quality_status")
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </td>
                                                <td>
                                                    <input type="text" name="items[{{ $index }}][storage_location]"
                                                           class="form-control @error("items.{$index}.storage_location") is-invalid @enderror"
                                                           value="{{ old("items.{$index}.storage_location") }}"
                                                           placeholder="e.g., Shelf A-1">
                                                    @error("items.{$index}.storage_location")
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </td>
                                                <td>
                                                    <textarea name="items[{{ $index }}][receipt_notes]"
                                                              class="form-control @error("items.{$index}.receipt_notes") is-invalid @enderror"
                                                              rows="2" placeholder="Quality notes, damage details, etc.">{{ old("items.{$index}.receipt_notes") }}</textarea>
                                                    @error("items.{$index}.receipt_notes")
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Receipt Summary -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="receipt_notes">Overall Receipt Notes</label>
                                    <textarea name="receipt_notes" id="receipt_notes"
                                              class="form-control @error('receipt_notes') is-invalid @enderror"
                                              rows="3" placeholder="General notes about this delivery receipt...">{{ old('receipt_notes') }}</textarea>
                                    @error('receipt_notes')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="row">
                            <div class="col-md-6">
                                <a href="{{ route('warehouse.direct-deliveries.show', $directDelivery) }}" class="btn btn-secondary">
                                    <i class="material-icons mr-1">arrow_back</i>
                                    Back to Details
                                </a>
                            </div>
                            <div class="col-md-6 text-right">
                                <button type="button" class="btn btn-outline-warning mr-2" onclick="setAllQualityStatus('pending')">
                                    <i class="material-icons mr-1">schedule</i>
                                    Mark All Pending
                                </button>
                                <button type="button" class="btn btn-outline-success mr-2" onclick="setAllQualityStatus('passed')">
                                    <i class="material-icons mr-1">check_circle</i>
                                    Mark All Passed
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="material-icons mr-1">receipt</i>
                                    Process Receipt
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function calculateRejected(index) {
    const deliveredQty = parseFloat(document.querySelector(`input[name="items[${index}][delivered_quantity]"]`)?.value) || 0;
    const receivedQty = parseFloat(document.querySelector(`input[name="items[${index}][received_quantity]"]`).value) || 0;
    const rejectedQty = Math.max(0, deliveredQty - receivedQty);

    document.querySelector(`input[name="items[${index}][rejected_quantity]"]`).value = rejectedQty.toFixed(2);
}

function setAllQualityStatus(status) {
    const selects = document.querySelectorAll('select[name*="[quality_status]"]');
    selects.forEach(select => {
        select.value = status;
    });
}

// Get delivered quantities and set up calculation
document.addEventListener('DOMContentLoaded', function() {
    @foreach($directDelivery->items as $index => $item)
    // Store delivered quantity for calculation
    const deliveredInput{{ $index }} = document.createElement('input');
    deliveredInput{{ $index }}.type = 'hidden';
    deliveredInput{{ $index }}.name = 'items[{{ $index }}][delivered_quantity]';
    deliveredInput{{ $index }}.value = {{ $item->delivered_quantity }};
    document.querySelector('form').appendChild(deliveredInput{{ $index }});
    @endforeach
});
</script>
@endpush