<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Supplier Delivery - {{ $operation->operation_number }}</title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            margin: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
        }

        .logo-container {
            flex-shrink: 0;
        }

        .logo-container img {
            height: 80px;
            width: auto;
        }

        .company-info {
            flex: 1;
            text-align: center;
        }

        .company-name {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 2px;
            text-transform: uppercase;
        }

        .company-address {
            font-size: 10px;
            margin-bottom: 1px;
        }

        .document-title {
            font-size: 14px;
            font-weight: bold;
            margin: 20px 0;
            text-transform: uppercase;
            text-align: center;
            background-color: #000;
            color: #fff;
            padding: 10px;
        }

        .info-section {
            margin-bottom: 20px;
        }

        .info-row {
            margin-bottom: 8px;
            font-size: 12px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }

        .items-table th,
        .items-table td {
            border: 1px solid #000;
            padding: 5px 8px;
            text-align: left;
        }

        .items-table th {
            font-weight: bold;
            background-color: #f0f0f0;
        }

        .items-table td.text-center {
            text-align: center;
        }

        .items-table td.text-right {
            text-align: right;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }

        .print-btn {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 4px;
            margin-bottom: 20px;
        }

        .print-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()" class="print-btn">🖨️ Print</button>
        <button onclick="window.close()" class="print-btn" style="background-color: #6c757d;">✕ Close</button>
    </div>

    <!-- Header -->
    <div class="header">
        <div class="logo-container">
            <img src="{{ asset('images/site_logo.png') }}" alt="Company Logo">
        </div>
        <div class="company-info">
            <div class="company-name">ISAM KABBANI & PARTNERS FOR CONSTRUCTION & MAINT. CO. ( L.L.C )</div>
            <div class="company-address">Dubai: Dubai Industrial City, Jebel Ali Tel# 04 818 1900; Fax# 04 429 7031</div>
            <div class="company-address">E-mail : dubai@kcgemirates.ae; abudhabi@kcgemirates.ae   Website : www.ikkgroup.com</div>
        </div>
    </div>

    <!-- Document Title -->
    <div class="document-title">SUPPLIER DELIVERY REPORT</div>

    <!-- Basic Information -->
    <div class="info-section">
        <div class="info-row">
            <strong>GRN Number:</strong> {{ $operation->operation_number }}
        </div>
        <div class="info-row">
            <strong>Date:</strong> {{ $operation->operation_date->format('d/m/Y') }}
        </div>
        @if($operation->supplier)
        <div class="info-row">
            <strong>Supplier:</strong> {{ $operation->supplier->name }}
        </div>
        @endif
        @if($operation->lpo_number)
        <div class="info-row">
            <strong>LPO Number:</strong> {{ $operation->lpo_number }}
        </div>
        @endif
        @if($operation->delivery_note_number)
        <div class="info-row">
            <strong>Delivery Note:</strong> {{ $operation->delivery_note_number }}
        </div>
        @endif
    </div>

    <!-- Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">Sr.</th>
                <th style="width: 12%;">Item Code</th>
                <th style="width: 35%;">Description</th>
                <th style="width: 10%;">Quantity</th>
                <th style="width: 8%;">Unit</th>
                <th style="width: 15%;">Unit Price</th>
                <th style="width: 15%;">Total Price</th>
            </tr>
        </thead>
        <tbody>
            @forelse($operation->items as $index => $item)
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td class="text-center">{{ $item->item->item_code ?? 'NO-CODE' }}</td>
                <td>{{ $item->item->item_description ?? 'Unknown Item' }}</td>
                <td class="text-center">{{ number_format($item->quantity_delivered, 0) }}</td>
                <td class="text-center">{{ strtoupper($item->item->unit_of_measure ?? 'PCS') }}</td>
                <td class="text-right">{{ number_format($item->unit_price, 2) }}</td>
                <td class="text-right">{{ number_format($item->total_price, 2) }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="7" class="text-center">No items found</td>
            </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr style="font-weight: bold;">
                <td colspan="3" class="text-right">TOTAL:</td>
                <td class="text-center">{{ number_format($operation->items->sum('quantity_delivered'), 0) }}</td>
                <td></td>
                <td class="text-right">{{ $operation->currency }} {{ number_format($operation->total_amount, 2) }}</td>
            </tr>
        </tfoot>
    </table>

    <!-- Footer -->
    <div class="footer">
        <p>Generated on {{ now()->format('d/m/Y H:i') }}</p>
    </div>

    <script>
        // Auto-print when page loads
        window.addEventListener('load', function() {
            setTimeout(() => {
                if (window.opener) {
                    window.print();
                }
            }, 500);
        });

        // Close window after printing
        window.addEventListener('afterprint', function() {
            if (window.opener) {
                setTimeout(() => {
                    window.close();
                }, 500);
            }
        });
    </script>
</body>
</html>