<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Condition Conversion Report - {{ $conversion->id }}</title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            margin: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
        }

        .logo-container {
            flex-shrink: 0;
        }

        .logo-container img {
            height: 80px;
            width: auto;
        }

        .company-info {
            flex: 1;
            text-align: center;
        }

        .company-name {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 2px;
            text-transform: uppercase;
        }

        .company-address {
            font-size: 10px;
            margin-bottom: 1px;
        }

        .document-title {
            font-size: 14px;
            font-weight: bold;
            margin: 20px 0;
            text-transform: uppercase;
            text-align: center;
            background-color: #000;
            color: #fff;
            padding: 10px;
        }

        .info-section {
            margin-bottom: 20px;
        }

        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 20px;
        }

        .info-row {
            margin-bottom: 8px;
            font-size: 12px;
        }

        .status-badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }

        .status-reported {
            background-color: #fff3cd;
            color: #856404;
        }

        .status-investigating {
            background-color: #d1ecf1;
            color: #0c5460;
        }

        .status-approved {
            background-color: #cce5ff;
            color: #004085;
        }

        .status-settled {
            background-color: #d4edda;
            color: #155724;
        }

        .status-written_off {
            background-color: #f8d7da;
            color: #721c24;
        }

        .severity-badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }

        .severity-minor {
            background-color: #fff3cd;
            color: #856404;
        }

        .severity-moderate {
            background-color: #ffeaa7;
            color: #6c5600;
        }

        .severity-severe {
            background-color: #f8d7da;
            color: #721c24;
        }

        .severity-total_loss {
            background-color: #d6d8d9;
            color: #1b1e21;
        }

        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }

        .details-table th,
        .details-table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }

        .details-table th {
            font-weight: bold;
            background-color: #f0f0f0;
            width: 25%;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }

        .print-btn {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 4px;
            margin-bottom: 20px;
        }

        .print-btn:hover {
            background-color: #0056b3;
        }

        .signatures-section {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            font-weight: bold;
        }

        .signature-box {
            text-align: center;
            width: 30%;
        }

        .cost-impact-box {
            background-color: #f8f9fa;
            border: 2px solid #dee2e6;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }

        .cost-impact-title {
            font-weight: bold;
            color: #495057;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()" class="print-btn">🖨️ Print</button>
        <button onclick="window.close()" class="print-btn" style="background-color: #6c757d;">✕ Close</button>
    </div>

    <!-- Header -->
    <div class="header">
        <div class="logo-container">
            <img src="{{ asset('images/site_logo.png') }}" alt="Company Logo">
        </div>
        <div class="company-info">
            <div class="company-name">ISAM MOHAMMED KHAIRI KABBANI & PARTNERS FOR CONSTRUCTION & MAINT. CO. ( L.L.C )</div>
            <div class="company-address">Dubai: Dubai Industrial City, Jebel Ali Tel# 04 818 1900; Fax# 04 429 7031</div>
            <div class="company-address">E-mail : dubai@kcgemirates.ae; abudhabi@kcgemirates.ae   Website : www.ikkgroup.com</div>
        </div>
    </div>

    <!-- Document Title -->
    <div class="document-title">FOC CONVERSION REPORT</div>

    <!-- Basic Information -->
    <div class="info-grid">
        <div>
            <div class="info-row">
                <strong>Conversion ID:</strong> CON-{{ str_pad($conversion->id, 5, '0', STR_PAD_LEFT) }}
            </div>
            <div class="info-row">
                <strong>Date:</strong> {{ $conversion->created_at->format('d/m/Y H:i') }}
            </div>
            <div class="info-row">
                <strong>Reported By:</strong> {{ $conversion->reportedBy->name ?? 'System' }}
            </div>
        </div>
        <div>
            <div class="info-row">
                <strong>Source:</strong>
                @switch($conversion->source_type)
                    @case('inventory_conversion')
                        <span class="status-badge status-investigating">Inventory Conversion</span>
                        @break
                    @case('site_return')
                        <span class="status-badge status-reported">Site Return</span>
                        @break
                    @default
                        <span class="status-badge status-approved">{{ ucfirst($conversion->source_type) }}</span>
                @endswitch
            </div>
            <div class="info-row">
                <strong>Status:</strong>
                <span class="status-badge status-{{ $conversion->status }}">
                    {{ ucfirst(str_replace('_', ' ', $conversion->status)) }}
                </span>
            </div>
            <div class="info-row">
                <strong>Cost Responsibility:</strong> {{ ucfirst(str_replace('_', ' ', $conversion->cost_responsibility ?? 'Unknown')) }}
            </div>
        </div>
    </div>

    <!-- Item Details -->
    <table class="details-table">
        <tr>
            <th>Item Description</th>
            <td>{{ $conversion->inventory->item->item_description ?? 'N/A' }}</td>
        </tr>
        <tr>
            <th>Item Code</th>
            <td>{{ $conversion->inventory->item->item_code ?? 'NO-CODE' }}</td>
        </tr>
        <tr>
            <th>Category</th>
            <td>{{ $conversion->inventory->item->category->category_name ?? 'N/A' }}</td>
        </tr>
        <tr>
            <th>Unit of Measure</th>
            <td>{{ $conversion->inventory->item->unit_of_measure ?? 'PCS' }}</td>
        </tr>
        <tr>
            <th>Location</th>
            <td>{{ $conversion->inventory->location ?? 'Main Warehouse' }}</td>
        </tr>
        <tr>
            <th>Converted Quantity</th>
            <td><strong>{{ number_format($conversion->quantity, 2) }} {{ $conversion->inventory->item->unit_of_measure ?? 'PCS' }}</strong></td>
        </tr>
    </table>

    <!-- Damage Information -->
    <div class="info-section">
        <h4 style="margin-bottom: 15px; border-bottom: 2px solid #dee2e6; padding-bottom: 5px;">Damage Information</h4>

        <div class="info-row">
            <strong>Damage Severity:</strong>
            <span class="severity-badge severity-{{ $conversion->damage_severity }}">
                {{ ucfirst(str_replace('_', ' ', $conversion->damage_severity ?? 'Moderate')) }}
            </span>
        </div>

        <div class="info-row">
            <strong>Description:</strong>
        </div>
        <div style="padding: 10px; background-color: #f8f9fa; border-left: 4px solid #007bff; margin-bottom: 15px;">
            {{ $conversion->damage_description ?? 'No description provided' }}
        </div>

        @if($conversion->damage_notes)
        <div class="info-row">
            <strong>Additional Notes:</strong>
        </div>
        <div style="padding: 10px; background-color: #f8f9fa; border-left: 4px solid #28a745; margin-bottom: 15px;">
            {{ $conversion->damage_notes }}
        </div>
        @endif
    </div>

    <!-- Cost Impact -->
    <div class="cost-impact-box">
        <div class="cost-impact-title">Cost Impact Analysis</div>
        <div class="info-row">
            <strong>Unit Cost:</strong> AED {{ number_format($conversion->unit_cost ?? 0, 2) }}
        </div>
        <div class="info-row">
            <strong>Total Cost:</strong> AED {{ number_format($conversion->total_cost ?? 0, 2) }}
        </div>
        <div class="info-row">
            <strong>Recoverable Amount:</strong> AED {{ number_format($conversion->recoverable_amount ?? 0, 2) }}
        </div>
        <div class="info-row" style="border-top: 2px solid #dc3545; padding-top: 10px; margin-top: 10px;">
            <strong style="color: #dc3545;">Total Loss:</strong>
            <strong style="color: #dc3545;">AED {{ number_format($conversion->total_loss ?? 0, 2) }}</strong>
        </div>
    </div>

    @if($conversion->approvedBy)
    <!-- Approval Information -->
    <div class="info-section">
        <h4 style="margin-bottom: 15px; border-bottom: 2px solid #dee2e6; padding-bottom: 5px;">Approval Information</h4>
        <div class="info-row">
            <strong>Approved By:</strong> {{ $conversion->approvedBy->name }}
        </div>
        <div class="info-row">
            <strong>Approval Date:</strong> {{ $conversion->approved_at ? $conversion->approved_at->format('d/m/Y H:i') : 'N/A' }}
        </div>
        @if($conversion->resolution_notes)
        <div class="info-row">
            <strong>Resolution Notes:</strong>
        </div>
        <div style="padding: 10px; background-color: #f8f9fa; border-left: 4px solid #28a745;">
            {{ $conversion->resolution_notes }}
        </div>
        @endif
    </div>
    @endif

    <!-- Signatures Section -->
    <div class="signatures-section">
        <div class="signature-box">Reported By (Sign & Date)</div>
        <div class="signature-box">Warehouse Manager</div>
        <div class="signature-box">Approved By (Sign & Date)</div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>Generated on {{ now()->format('d/m/Y H:i') }}</p>
        <p>This is a system-generated report for condition conversion tracking</p>
    </div>

    <script>
        // Auto-print when page loads
        window.addEventListener('load', function() {
            setTimeout(() => {
                if (window.opener) {
                    window.print();
                }
            }, 500);
        });

        // Close window after printing
        window.addEventListener('afterprint', function() {
            if (window.opener) {
                setTimeout(() => {
                    window.close();
                }, 500);
            }
        });
    </script>
</body>
</html>