@extends('layouts.admin-simple')

@section('title', $category->category_name)
@section('page-title', $category->category_name)
@section('page-subtitle', 'Item Category Details')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('warehouse.item-categories.index') }}">Item Categories</a></li>
    <li class="breadcrumb-item active">{{ $category->category_name }}</li>
@endsection

@section('page-actions')
    <div class="d-flex">
        @can('warehouse.item-categories.edit')
        <a href="{{ route('warehouse.item-categories.edit', $category) }}" class="btn btn-primary btn-sm">
            <i class="material-icons mr-1" style="font-size: 16px;">edit</i>
            Edit Category
        </a>
        @endcan
    </div>
@endsection

@section('content')
    <!-- Category Information -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Category Information</h6>
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Basic Information</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Category Name</dt>
                        <dd class="col-sm-8">{{ $category->category_name }}</dd>

                        <dt class="col-sm-4 text-muted">Category Code</dt>
                        <dd class="col-sm-8">
                            @if($category->category_code)
                                <code class="category-code-display">{{ $category->category_code }}</code>
                            @else
                                <span class="text-muted font-italic">Not assigned</span>
                            @endif
                        </dd>

                        <dt class="col-sm-4 text-muted">Type of Goods</dt>
                        <dd class="col-sm-8">{{ $category->type_of_goods ?: 'Not specified' }}</dd>

                        <dt class="col-sm-4 text-muted">Status</dt>
                        <dd class="col-sm-8">
                            @if($category->status === 'active')
                                <span class="badge badge-success">Active</span>
                            @else
                                <span class="badge badge-secondary">Inactive</span>
                            @endif
                        </dd>

                        <dt class="col-sm-4 text-muted">Created Date</dt>
                        <dd class="col-sm-8">{{ $category->created_at->format('M d, Y H:i') }}</dd>

                        <dt class="col-sm-4 text-muted">Last Updated</dt>
                        <dd class="col-sm-8">{{ $category->updated_at->format('M d, Y H:i') }}</dd>
                    </dl>
                </div>

                <div class="col-md-6">
                    <h6 class="text-primary font-weight-bold mb-3">Statistics</h6>
                    <dl class="row">
                        <dt class="col-sm-4 text-muted">Total Items</dt>
                        <dd class="col-sm-8">
                            @php
                                $itemCount = $category->items()->count();
                            @endphp
                            <span class="badge badge-info">{{ $itemCount }}</span>
                        </dd>

                        <dt class="col-sm-4 text-muted">Active Items</dt>
                        <dd class="col-sm-8">
                            @php
                                $activeItemCount = $category->items()->where('status', 'active')->count();
                            @endphp
                            <span class="badge badge-success">{{ $activeItemCount }}</span>
                        </dd>

                    </dl>

                    @if($category->description)
                        <h6 class="text-primary font-weight-bold mb-3 mt-4">Description</h6>
                        <p class="text-muted">{{ $category->description }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if($category->items()->count() > 0)
    <!-- Items in this Category -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">Items in this Category</h6>
            <a href="{{ route('warehouse.items.index', ['category_id' => $category->id]) }}" class="btn btn-sm btn-outline-primary">
                View All Items
            </a>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Item Code</th>
                            <th>Item Name</th>
                            <th>Unit</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($category->items()->limit(10)->get() as $item)
                        <tr>
                            <td>{{ $item->item_code }}</td>
                            <td>{{ $item->item_description }}</td>
                            <td>{{ $item->unit_of_measure }}</td>
                            <td>
                                @if($item->status === 'active')
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-secondary">{{ ucfirst($item->status) }}</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('warehouse.items.show', $item->id) }}" class="btn btn-sm btn-info">
                                    <i class="material-icons" style="font-size: 14px;">visibility</i>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @if($category->items()->count() > 10)
                <div class="text-center mt-3">
                    <p class="text-muted">Showing first 10 items. <a href="{{ route('warehouse.items.index', ['category_id' => $category->id]) }}">View all {{ $category->items()->count() }} items</a></p>
                </div>
                @endif
            </div>
        </div>
    </div>
    @endif

@endsection

@push('styles')
    <style>
        .category-code-display {
            font-size: 12px;
            font-weight: bold;
            color: #007bff;
            background-color: #e3f2fd;
            padding: 4px 8px;
            border-radius: 4px;
            text-transform: uppercase;
            font-family: 'Courier New', monospace;
        }
    </style>
@endpush