@extends('layouts.admin-simple')

@section('title', 'Item Type Details')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Items</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.item-types.index') }}">Item Types</a></li>
    <li class="breadcrumb-item active">{{ $itemType->type_name }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $itemType->type_name }}</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Item type details and associated items</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            @can('warehouse.items.edit')
                <a href="{{ route('warehouse.item-types.edit', $itemType->id) }}" class="btn btn-sm btn-primary mr-2" title="Edit item type">
                    <i class="material-icons mr-1" style="font-size: 16px;">edit</i>
                    Edit
                </a>
            @endcan
            <a href="{{ route('warehouse.item-types.index') }}" class="btn btn-sm btn-secondary" title="Back to list">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back
            </a>
        </div>
    </div>
@endsection

@section('content')
    <!-- Item Type Details -->
    <div class="row">
        <div class="col-md-8">
            <!-- Basic Information -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 d-flex align-items-center">
                        <i class="material-icons mr-2">info</i>
                        Basic Information
                    </h5>
                    <span class="badge {{ $itemType->status === 'active' ? 'badge-success' : 'badge-danger' }}">
                        {{ ucfirst($itemType->status) }}
                    </span>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label text-muted">Type Name</label>
                                <p class="font-weight-medium">{{ $itemType->type_name }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label text-muted">Type Code</label>
                                <p class="font-weight-medium">{{ $itemType->type_code }}</p>
                            </div>
                        </div>
                    </div>
                    @if($itemType->description)
                    <div class="form-group">
                        <label class="form-label text-muted">Description</label>
                        <p>{{ $itemType->description }}</p>
                    </div>
                    @endif
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label text-muted">Created Date</label>
                                <p>{{ $itemType->created_at->format('M d, Y \a\t H:i') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label text-muted">Last Updated</label>
                                <p>{{ $itemType->updated_at->format('M d, Y \a\t H:i') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Associated Items -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 d-flex align-items-center">
                        <i class="material-icons mr-2">inventory</i>
                        Associated Items
                        <span class="badge badge-info ml-2">{{ $itemType->items->count() }}</span>
                    </h5>
                </div>
                <div class="card-body">
                    @if($itemType->items->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Item Code</th>
                                        <th>Item Name</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th class="text-right">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($itemType->items as $item)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="mr-3">
                                                    <div class="bg-info text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 32px; height: 32px;">
                                                        <i class="material-icons" style="font-size: 16px;">inventory_2</i>
                                                    </div>
                                                </div>
                                                <span class="font-weight-medium">{{ $item->item_code }}</span>
                                            </div>
                                        </td>
                                        <td>{{ $item->item_name }}</td>
                                        <td>
                                            <span class="badge {{ $item->status === 'active' ? 'badge-success' : 'badge-danger' }}">
                                                {{ ucfirst($item->status) }}
                                            </span>
                                        </td>
                                        <td>{{ $item->created_at->format('M d, Y') }}</td>
                                        <td class="text-right">
                                            @can('warehouse.items.view')
                                                <a href="{{ route('warehouse.items.show', $item->id) }}" class="btn btn-sm btn-outline-primary" title="View Item">
                                                    <i class="material-icons" style="font-size: 16px;">visibility</i>
                                                </a>
                                            @endcan
                                            @can('warehouse.items.edit')
                                                <a href="{{ route('warehouse.items.edit', $item->id) }}" class="btn btn-sm btn-outline-success" title="Edit Item">
                                                    <i class="material-icons" style="font-size: 16px;">edit</i>
                                                </a>
                                            @endcan
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="material-icons text-muted" style="font-size: 64px;">inventory_2</i>
                            <h6 class="text-muted mt-3">No Items Found</h6>
                            <p class="text-muted">This item type doesn't have any associated items yet.</p>
                            @can('warehouse.items.create')
                                <a href="{{ route('warehouse.items.create') }}" class="btn btn-primary btn-sm mt-2">
                                    <i class="material-icons mr-1" style="font-size: 16px;">add</i>
                                    Add New Item
                                </a>
                            @endcan
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Statistics Sidebar -->
        <div class="col-md-4">
            <!-- Quick Stats -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0 d-flex align-items-center">
                        <i class="material-icons mr-2">analytics</i>
                        Quick Statistics
                    </h6>
                </div>
                <div class="card-body">
                    <div class="text-center mb-3">
                        <div class="bg-primary text-white d-flex align-items-center justify-content-center rounded-circle mx-auto mb-3" style="width: 60px; height: 60px;">
                            <i class="material-icons" style="font-size: 30px;">category</i>
                        </div>
                        <h4 class="text-primary mb-1">{{ $itemType->items->count() }}</h4>
                        <p class="text-muted mb-0">Total Items</p>
                    </div>

                    <hr>

                    <div class="row text-center">
                        <div class="col-6">
                            <h6 class="text-success mb-1">{{ $itemType->items->where('status', 'active')->count() }}</h6>
                            <small class="text-muted">Active</small>
                        </div>
                        <div class="col-6">
                            <h6 class="text-danger mb-1">{{ $itemType->items->where('status', 'inactive')->count() }}</h6>
                            <small class="text-muted">Inactive</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            @if($itemType->items->count() > 0)
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0 d-flex align-items-center">
                        <i class="material-icons mr-2">schedule</i>
                        Recent Items
                    </h6>
                </div>
                <div class="card-body">
                    @foreach($itemType->items->sortByDesc('created_at')->take(5) as $item)
                        <div class="d-flex align-items-center {{ !$loop->last ? 'mb-3' : '' }}">
                            <div class="mr-3">
                                <div class="bg-secondary text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 32px; height: 32px;">
                                    <i class="material-icons" style="font-size: 16px;">inventory_2</i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <div class="font-weight-medium" style="font-size: 14px;">{{ $item->item_name }}</div>
                                <small class="text-muted">{{ $item->created_at->diffForHumans() }}</small>
                            </div>
                        </div>
                    @endforeach

                    @if($itemType->items->count() > 5)
                        <div class="text-center mt-3">
                            <small class="text-muted">... and {{ $itemType->items->count() - 5 }} more items</small>
                        </div>
                    @endif
                </div>
            </div>
            @endif
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
            border-radius: 4px;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
        }

        .table-responsive {
            border-radius: 0.375rem;
        }

        .form-label {
            font-weight: 600;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .font-weight-medium {
            font-weight: 500;
        }

        .card-header h5, .card-header h6 {
            color: #495057;
        }
    </style>
@endpush