@extends('layouts.admin-simple')

@section('title', 'Material Request Details')

@section('content')
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">assignment</i>
                        Material Request Details
                    </h1>
                    <p class="text-muted mb-0">Request #{{ $transaction->reference_number }}</p>
                </div>
                <div>
                    @if($transaction->status === 'pending')
                        <form method="POST" action="{{ route('warehouse.outgoing.approve', $transaction) }}" style="display: inline;" onsubmit="return confirm('Are you sure you want to approve this request?')">
                            @csrf
                            <button type="submit" class="btn btn-success">
                                <i class="material-icons mr-1">check</i>
                                Approve Request
                            </button>
                        </form>
                    @endif
                    @if($transaction->status === 'approved')
                        <form method="POST" action="{{ route('warehouse.outgoing.dispatch', $transaction) }}" style="display: inline;" onsubmit="return confirm('Are you sure you want to dispatch this request? This will update inventory.')">
                            @csrf
                            <button type="submit" class="btn btn-info">
                                <i class="material-icons mr-1">local_shipping</i>
                                Dispatch Items
                            </button>
                        </form>
                    @endif
                    <a href="{{ route('warehouse.outgoing.index') }}" class="btn btn-secondary">
                        <i class="material-icons mr-1">arrow_back</i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Alert -->
    @if($transaction->status === 'pending')
        <div class="alert alert-warning">
            <i class="material-icons align-middle mr-2">pending</i>
            <strong>Pending Approval:</strong> This material request is waiting for manager approval.
        </div>
    @elseif($transaction->status === 'approved')
        <div class="alert alert-success">
            <i class="material-icons align-middle mr-2">check_circle</i>
            <strong>Approved:</strong> This material request has been approved and is ready for dispatch.
        </div>
    @elseif($transaction->status === 'completed')
        <div class="alert alert-info">
            <i class="material-icons align-middle mr-2">local_shipping</i>
            <strong>Completed:</strong> Materials have been dispatched and inventory has been updated.
        </div>
    @endif

    <div class="row">
        <!-- Transaction Details -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">info</i>
                        Request Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Request Number:</strong><br>{{ $transaction->reference_number }}</p>
                            @if($transaction->material_request_number)
                                <p><strong>Material Request Number:</strong><br>{{ $transaction->material_request_number }}</p>
                            @endif
                            <p><strong>Request Date:</strong><br>{{ $transaction->transaction_date->format('M d, Y') }}</p>
                            <p><strong>Status:</strong><br>
                                @switch($transaction->status)
                                    @case('pending')
                                        <span class="badge badge-warning">
                                            <i class="material-icons" style="font-size: 12px;">pending</i>
                                            Pending Approval
                                        </span>
                                        @break
                                    @case('approved')
                                        <span class="badge badge-success">
                                            <i class="material-icons" style="font-size: 12px;">check_circle</i>
                                            Approved
                                        </span>
                                        @break
                                    @case('completed')
                                        <span class="badge badge-info">
                                            <i class="material-icons" style="font-size: 12px;">local_shipping</i>
                                            Completed
                                        </span>
                                        @break
                                @endswitch
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Requested By:</strong><br>
                                @if($transaction->requester)
                                    {{ $transaction->requester->name }}
                                @else
                                    <span class="text-muted">N/A</span>
                                @endif
                            </p>
                            @if($transaction->approver)
                                <p><strong>Approved By:</strong><br>{{ $transaction->approver->name }}</p>
                            @endif
                            <p><strong>Project:</strong><br>
                                @if($transaction->project)
                                    {{ $transaction->project->project_name }}
                                    @if($transaction->project->project_number)
                                        <br><small class="text-muted">{{ $transaction->project->project_number }}</small>
                                    @endif
                                @else
                                    <span class="text-muted">N/A</span>
                                @endif
                            </p>
                            <p><strong>Division:</strong><br>
                                @if($transaction->division)
                                    {{ $transaction->division->division_name }}
                                @else
                                    <span class="text-muted">N/A</span>
                                @endif
                            </p>
                        </div>
                    </div>
                    @if($transaction->notes)
                        <hr>
                        <p><strong>Notes:</strong><br>{{ $transaction->notes }}</p>
                    @endif

                    @if($transaction->request_file)
                        <hr>
                        <p><strong>Request File:</strong><br>
                            <a href="{{ asset($transaction->request_file) }}"
                               target="_blank"
                               class="btn btn-sm btn-outline-primary">
                                <i class="material-icons mr-1" style="font-size: 16px;">attachment</i>
                                View Uploaded File
                            </a>
                        </p>
                    @endif
                </div>
            </div>

            <!-- Items -->
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">shopping_cart</i>
                        Requested Items ({{ $transaction->items->count() }})
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>Item Code</th>
                                    <th>Description</th>
                                    <th>Unit</th>
                                    <th>Qty Requested</th>
                                    <th>Qty Released</th>
                                    <th>Balance</th>
                                    <th>Unit Price</th>
                                    <th>Total Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transaction->items as $item)
                                    <tr>
                                        <td>
                                            <strong class="text-primary">{{ $item->item->item_code }}</strong>
                                        </td>
                                        <td>{{ $item->item->item_description }}</td>
                                        <td class="text-center">
                                            <span class="badge badge-secondary">{{ $item->item->unit_of_measure }}</span>
                                        </td>
                                        <td class="text-right">{{ number_format($item->quantity_requested, 2) }}</td>
                                        <td class="text-right">
                                            @if($item->quantity_released > 0)
                                                <span class="text-success">{{ number_format($item->quantity_released, 2) }}</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td class="text-right">
                                            @if($item->quantity_balance > 0)
                                                <span class="text-warning">{{ number_format($item->quantity_balance, 2) }}</span>
                                            @else
                                                <span class="text-success">0.00</span>
                                            @endif
                                        </td>
                                        <td class="text-right">AED {{ number_format($item->unit_price, 2) }}</td>
                                        <td class="text-right">
                                            <strong>AED {{ number_format($item->total_price, 2) }}</strong>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center text-muted py-4">
                                            <i class="material-icons mb-2" style="font-size: 48px; opacity: 0.3;">shopping_cart</i>
                                            <div>No items found in this request</div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                            @if($transaction->items->count() > 0)
                                <tfoot>
                                    <tr class="table-active">
                                        <th colspan="7" class="text-right">Total Amount:</th>
                                        <th class="text-right">
                                            AED {{ number_format($transaction->items->sum('total_price'), 2) }}
                                        </th>
                                    </tr>
                                </tfoot>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Quick Actions -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">settings</i>
                        Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    @if($transaction->status !== 'completed')
                        <a href="{{ route('warehouse.outgoing.edit', $transaction) }}" class="btn btn-outline-secondary btn-block mb-2">
                            <i class="material-icons mr-1">edit</i>
                            Edit Request
                        </a>
                    @endif

                    @if($transaction->status === 'pending')
                        <form method="POST" action="{{ route('warehouse.outgoing.approve', $transaction) }}" onsubmit="return confirm('Are you sure you want to approve this request?')">
                            @csrf
                            <button type="submit" class="btn btn-success btn-block mb-2">
                                <i class="material-icons mr-1">check</i>
                                Approve Request
                            </button>
                        </form>
                    @endif

                    @if($transaction->status === 'approved')
                        <form method="POST" action="{{ route('warehouse.outgoing.dispatch', $transaction) }}" onsubmit="return confirm('Are you sure you want to dispatch this request? This will update inventory.')">
                            @csrf
                            <button type="submit" class="btn btn-info btn-block mb-2">
                                <i class="material-icons mr-1">local_shipping</i>
                                Dispatch Items
                            </button>
                        </form>
                    @endif

                    <a href="{{ route('warehouse.outgoing.index') }}" class="btn btn-outline-primary btn-block">
                        <i class="material-icons mr-1">list</i>
                        All Requests
                    </a>
                </div>
            </div>

            <!-- Activity Timeline -->
            <div class="card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="material-icons align-middle mr-1">timeline</i>
                        Request Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <!-- Created -->
                        <div class="timeline-item">
                            <div class="timeline-marker bg-primary"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Request Created</h6>
                                <p class="timeline-text">
                                    {{ $transaction->created_at->format('M d, Y \a\t h:i A') }}
                                    @if($transaction->requester)
                                        <br><small class="text-muted">by {{ $transaction->requester->name }}</small>
                                    @endif
                                </p>
                            </div>
                        </div>

                        <!-- Approved -->
                        @if($transaction->approver)
                        <div class="timeline-item">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Request Approved</h6>
                                <p class="timeline-text">
                                    {{ $transaction->updated_at->format('M d, Y \a\t h:i A') }}
                                    <br><small class="text-muted">by {{ $transaction->approver->name }}</small>
                                </p>
                            </div>
                        </div>
                        @endif

                        <!-- Completed -->
                        @if($transaction->status === 'completed')
                        <div class="timeline-item">
                            <div class="timeline-marker bg-info"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Items Dispatched</h6>
                                <p class="timeline-text">
                                    {{ $transaction->updated_at->format('M d, Y \a\t h:i A') }}
                                    <br><small class="text-muted">Inventory updated</small>
                                </p>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .timeline {
        position: relative;
        padding-left: 30px;
    }
    .timeline:before {
        content: '';
        position: absolute;
        left: 8px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: #e3e6f0;
    }
    .timeline-item {
        position: relative;
        margin-bottom: 20px;
    }
    .timeline-marker {
        position: absolute;
        left: -22px;
        top: 5px;
        width: 16px;
        height: 16px;
        border-radius: 50%;
        border: 2px solid #fff;
    }
    .timeline-title {
        font-size: 14px;
        font-weight: 600;
        color: #5a5c69;
        margin-bottom: 5px;
    }
    .timeline-text {
        font-size: 13px;
        color: #858796;
        margin-bottom: 0;
    }
</style>
@endpush