@extends('layouts.admin-simple')

@section('title', 'Outgoing Request Details - ' . $requestSummary->material_request_number)

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.outgoing') }}">Outgoing Materials</a></li>
    <li class="breadcrumb-item active">Request Details</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $requestSummary->material_request_number }}</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Material request details and dispatch methods</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.reports.outgoing') }}" class="btn btn-sm btn-outline-secondary">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
        </div>
    </div>
@endsection

@section('content')
    <!-- Request Summary Card -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment</i>
                Request Summary
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-borderless table-sm mb-0">
                        <tr>
                            <td class="font-weight-medium">Request Number:</td>
                            <td class="text-primary font-weight-bold">{{ $requestSummary->material_request_number }}</td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Request Date:</td>
                            <td>{{ $requestSummary->transaction_date->format('d-M-Y') }}</td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Project:</td>
                            <td>{{ $requestSummary->project_name }}</td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Division:</td>
                            <td>{{ $requestSummary->division_name }}</td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Requested By:</td>
                            <td>{{ $requestSummary->requester_name }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-borderless table-sm mb-0">
                        <tr>
                            <td class="font-weight-medium">Receiver:</td>
                            <td>{{ $requestSummary->receiver_name ?: 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Delivery Location:</td>
                            <td>{{ $requestSummary->delivery_location ?: 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Purpose:</td>
                            <td>{{ $requestSummary->purpose ?: 'N/A' }}</td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Overall Status:</td>
                            <td>
                                @if($requestSummary->overall_status == 'Fully Dispatched')
                                    <span class="badge badge-success">{{ $requestSummary->overall_status }}</span>
                                @elseif($requestSummary->overall_status == 'Pending')
                                    <span class="badge badge-warning">{{ $requestSummary->overall_status }}</span>
                                @else
                                    <span class="badge badge-info">{{ $requestSummary->overall_status }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td class="font-weight-medium">Items Count:</td>
                            <td><span class="badge badge-light">{{ $requestSummary->total_items }} items</span></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Statistics -->
    <div class="row mb-4">
        <div class="col-md-4">
            <x-warehouse.stats-card
                title="Total Requested"
                :value="number_format($requestSummary->total_requested, 2)"
                icon="inventory_2"
                color="info"
                subtitle="Total quantity requested"
            />
        </div>
        <div class="col-md-4">
            <x-warehouse.stats-card
                title="Total Released"
                :value="number_format($requestSummary->total_released, 2)"
                icon="outbound"
                color="success"
                subtitle="Total quantity released"
            />
        </div>
        <div class="col-md-4">
            <x-warehouse.stats-card
                title="Pending Balance"
                :value="number_format($requestSummary->total_balance, 2)"
                icon="pending_actions"
                color="warning"
                subtitle="Total quantity pending"
            />
        </div>
    </div>

    <!-- Items Details -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">list_alt</i>
                Materials and Dispatch Methods
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-sm table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 15%;">Item Code</th>
                            <th style="width: 25%;">Description</th>
                            <th style="width: 10%;">Category</th>
                            <th style="width: 8%;">Unit</th>
                            <th style="width: 8%;">Requested</th>
                            <th style="width: 8%;">Released</th>
                            <th style="width: 8%;">Balance</th>
                            <th style="width: 10%;">Status</th>
                            <th style="width: 8%;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($request->items as $item)
                            <tr>
                                <td>
                                    <code>{{ $item->item->item_code }}</code>
                                </td>
                                <td>
                                    <div>{{ $item->item->item_description }}</div>
                                </td>
                                <td>
                                    <span class="badge badge-outline-secondary small">{{ $item->item->category->category_name ?? 'N/A' }}</span>
                                </td>
                                <td class="text-center">{{ $item->item->unit_of_measure }}</td>
                                <td class="text-right">
                                    <strong>{{ number_format($item->quantity_requested, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong class="text-success">{{ number_format($item->quantity_fulfilled ?? 0, 2) }}</strong>
                                </td>
                                <td class="text-right">
                                    <strong class="{{ ($item->quantity_remaining ?? 0) > 0 ? 'text-warning' : 'text-success' }}">
                                        {{ number_format($item->quantity_remaining ?? 0, 2) }}
                                    </strong>
                                </td>
                                <td>
                                    @if($item->fulfillment_status == 'Fully Dispatched')
                                        <span class="badge badge-success">{{ $item->fulfillment_status }}</span>
                                    @elseif($item->fulfillment_status == 'Pending')
                                        <span class="badge badge-warning">{{ $item->fulfillment_status }}</span>
                                    @else
                                        <span class="badge badge-info">{{ $item->fulfillment_status }}</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if(count($item->dispatch_methods ?? []) > 0)
                                        <button type="button"
                                                class="btn btn-sm btn-outline-primary"
                                                onclick="showDispatchMethods('{{ $item->item->item_code }}', {{ json_encode($item->dispatch_methods) }})"
                                                title="View dispatch methods">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </button>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

<!-- Dispatch Methods Modal -->
<div class="modal fade" id="dispatchMethodsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="material-icons align-middle mr-1">local_shipping</i>
                    Dispatch Methods - <span id="modalItemCode"></span>
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body" id="dispatchMethodsContent">
                <!-- Content will be loaded dynamically -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

@push('styles')
    <style>
        .badge-outline-secondary {
            color: #6c757d;
            border: 1px solid #6c757d;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
            white-space: nowrap;
        }

        .table td {
            vertical-align: middle;
            font-size: 13px;
        }

        .badge {
            font-size: 10px;
            padding: 3px 6px;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        .dispatch-method-item {
            border-left: 3px solid #dee2e6;
            padding: 12px;
            margin-bottom: 12px;
            background-color: #f8f9fa;
            border-radius: 0 4px 4px 0;
        }

        .dispatch-method-item.success { border-left-color: #28a745; }
        .dispatch-method-item.info { border-left-color: #17a2b8; }
        .dispatch-method-item.primary { border-left-color: #007bff; }
    </style>
@endpush

@push('scripts')
    <script>
        function showDispatchMethods(itemCode, methods) {
            $('#modalItemCode').text(itemCode);

            let content = '';
            if (methods.length === 0) {
                content = '<div class="text-center py-4"><i class="material-icons text-muted mb-3" style="font-size: 48px;">local_shipping_off</i><h5 class="text-muted">No Dispatch Methods</h5><p class="text-muted mb-0">This item has not been dispatched yet.</p></div>';
            } else {
                methods.forEach(function(method) {
                    content += `
                        <div class="dispatch-method-item ${method.color}">
                            <div class="d-flex align-items-center mb-2">
                                <i class="material-icons mr-2" style="color: var(--${method.color});">${method.icon}</i>
                                <h6 class="mb-0 font-weight-bold">${method.type}</h6>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <strong>Quantity:</strong> ${parseFloat(method.quantity).toFixed(2)}
                                </div>
                                <div class="col-md-6">
                                    <strong>Date:</strong> ${method.date}
                                </div>
                            </div>
                            ${method.supplier ? `<div class="mt-2"><strong>Supplier:</strong> ${method.supplier}</div>` : ''}
                            ${method.source_project ? `<div class="mt-2"><strong>Source Project:</strong> ${method.source_project}</div>` : ''}
                        </div>
                    `;
                });
            }

            $('#dispatchMethodsContent').html(content);
            $('#dispatchMethodsModal').modal('show');
        }
    </script>
@endpush