<div class="container-fluid px-0">
    <!-- Basic Information -->
    <div class="row mb-3">
        <div class="col-12">
            <div class="card border-left-warning">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-warning mb-2">
                                <i class="material-icons align-middle mr-1" style="font-size: 18px;">inventory_2</i>
                                Item Information
                            </h6>
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td class="text-muted" style="width: 40%;">Item Code:</td>
                                    <td><strong>{{ $damagedItem->item->item_code ?? 'No Code' }}</strong></td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Description:</td>
                                    <td>{{ $damagedItem->item->item_description ?? 'No Description' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Category:</td>
                                    <td>
                                        <span class="badge badge-secondary">
                                            {{ $damagedItem->item->category->category_name ?? 'No Category' }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-warning mb-2">
                                <i class="material-icons align-middle mr-1" style="font-size: 18px;">warning</i>
                                Damage Details
                            </h6>
                            <table class="table table-sm table-borderless">
                                <tr>
                                    <td class="text-muted" style="width: 40%;">Quantity:</td>
                                    <td><strong>{{ number_format($damagedItem->quantity, 2) }}</strong> {{ $damagedItem->item->unit->unit_symbol ?? 'units' }}</td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Condition:</td>
                                    <td>
                                        <span class="badge badge-{{ $damagedItem->condition === 'damaged' ? 'danger' : ($damagedItem->condition === 'excess' ? 'warning' : 'info') }}">
                                            {{ ucfirst($damagedItem->condition) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-muted">Severity:</td>
                                    <td>
                                        <span class="badge badge-{{ in_array($damagedItem->damage_severity, ['severe', 'major']) ? 'danger' : ($damagedItem->damage_severity === 'moderate' ? 'warning' : 'secondary') }}">
                                            {{ ucfirst($damagedItem->damage_severity) }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Source Information -->
    <div class="row mb-3">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">
                        <i class="material-icons align-middle mr-1" style="font-size: 18px;">source</i>
                        Source Information
                    </h6>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td class="text-muted" style="width: 40%;">Source Type:</td>
                            <td>
                                <span class="badge badge-{{ $damagedItem->source_type === 'site_return' ? 'info' : 'warning' }}">
                                    {{ $damagedItem->source_type === 'site_return' ? 'Site Return' : 'Inventory Conversion' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Reference:</td>
                            <td><strong>{{ $damagedItem->source_reference ?? 'No Reference' }}</strong></td>
                        </tr>
                        <tr>
                            <td class="text-muted">Project:</td>
                            <td>
                                @if($damagedItem->project)
                                    <span class="badge badge-primary">{{ $damagedItem->project->project_name }}</span>
                                @else
                                    <span class="text-muted">No Project</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Date:</td>
                            <td>{{ $damagedItem->created_at->format('d M Y, H:i') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">
                        <i class="material-icons align-middle mr-1" style="font-size: 18px;">attach_money</i>
                        Financial Information
                    </h6>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td class="text-muted" style="width: 40%;">Total Cost:</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span class="dirham-symbol text-danger mr-1" style="width: 16px; height: 16px; display: inline-flex; align-items: center;">
                                        <svg viewBox="0 0 1000 870" width="16" height="16" style="fill: currentColor;">
                                            <path d="m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.3 0.7 19.2 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z"></path>
                                        </svg>
                                    </span>
                                    <strong class="text-danger">{{ number_format($damagedItem->total_cost, 2) }}</strong>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Recoverable:</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span class="dirham-symbol text-success mr-1" style="width: 16px; height: 16px; display: inline-flex; align-items: center;">
                                        <svg viewBox="0 0 1000 870" width="16" height="16" style="fill: currentColor;">
                                            <path d="m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.3 0.7 19.2 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z"></path>
                                        </svg>
                                    </span>
                                    <strong class="text-success">{{ number_format($damagedItem->recoverable_amount, 2) }}</strong>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Net Loss:</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span class="dirham-symbol text-danger mr-1" style="width: 16px; height: 16px; display: inline-flex; align-items: center;">
                                        <svg viewBox="0 0 1000 870" width="16" height="16" style="fill: currentColor;">
                                            <path d="m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.3 0.7 19.2 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z"></path>
                                        </svg>
                                    </span>
                                    <strong class="text-danger">{{ number_format($damagedItem->total_cost - $damagedItem->recoverable_amount, 2) }}</strong>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Recovery %:</td>
                            <td>
                                @php
                                    $recoveryPercent = $damagedItem->total_cost > 0 ? ($damagedItem->recoverable_amount / $damagedItem->total_cost) * 100 : 0;
                                @endphp
                                <span class="badge badge-{{ $recoveryPercent >= 70 ? 'success' : ($recoveryPercent >= 40 ? 'warning' : 'danger') }}">
                                    {{ number_format($recoveryPercent, 1) }}%
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Status and Responsibility -->
    <div class="row mb-3">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">
                        <i class="material-icons align-middle mr-1" style="font-size: 18px;">assignment</i>
                        Status & Responsibility
                    </h6>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td class="text-muted" style="width: 40%;">Status:</td>
                            <td>
                                <span class="badge badge-{{ $damagedItem->status === 'reported' ? 'warning' : ($damagedItem->status === 'investigating' ? 'info' : ($damagedItem->status === 'approved' ? 'primary' : ($damagedItem->status === 'settled' ? 'success' : 'danger'))) }}">
                                    {{ ucfirst($damagedItem->status) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Responsibility:</td>
                            <td>
                                <span class="badge badge-{{ $damagedItem->cost_responsibility === 'company' ? 'danger' : ($damagedItem->cost_responsibility === 'supplier' ? 'warning' : 'secondary') }}">
                                    {{ ucfirst($damagedItem->cost_responsibility) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Reported By:</td>
                            <td>{{ $damagedItem->user->name ?? 'Unknown' }}</td>
                        </tr>
                        @if($damagedItem->updated_at != $damagedItem->created_at)
                        <tr>
                            <td class="text-muted">Last Updated:</td>
                            <td>{{ $damagedItem->updated_at->format('d M Y, H:i') }}</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">
                        <i class="material-icons align-middle mr-1" style="font-size: 18px;">description</i>
                        Description
                    </h6>
                </div>
                <div class="card-body">
                    <div class="bg-light p-3 rounded">
                        {{ $damagedItem->damage_description ?? 'No description provided' }}
                    </div>
                    @if($damagedItem->remarks)
                        <h6 class="mt-3 mb-2">Remarks:</h6>
                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                            {{ $damagedItem->remarks }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- FOC Inventory Information -->
    @if($focInventory->count() > 0)
    <div class="row mb-3">
        <div class="col-12">
            <div class="card border-left-success">
                <div class="card-header bg-light">
                    <h6 class="mb-0">
                        <i class="material-icons align-middle mr-1" style="font-size: 18px;">recycling</i>
                        FOC Inventory Created from this Damage
                    </h6>
                </div>
                <div class="card-body">
                    @foreach($focInventory as $foc)
                    <div class="row mb-2">
                        <div class="col-md-3">
                            <strong>Condition:</strong> {{ ucfirst($foc->condition) }}
                        </div>
                        <div class="col-md-3">
                            <strong>Available:</strong> <span class="text-success">{{ number_format($foc->quantity_available, 2) }}</span>
                        </div>
                        <div class="col-md-3">
                            <strong>Location:</strong> {{ $foc->storage_location ?? 'Not specified' }}
                        </div>
                        <div class="col-md-3">
                            <strong>Status:</strong>
                            <span class="badge badge-{{ $foc->status === 'available' ? 'success' : 'secondary' }}">
                                {{ ucfirst($foc->status) }}
                            </span>
                        </div>
                    </div>
                    @if($foc->adjustments->count() > 0)
                    <div class="mt-2">
                        <small class="text-muted">Recent Adjustments:</small>
                        @foreach($foc->adjustments->take(3) as $adjustment)
                        <div class="small text-muted">
                            • {{ ucfirst($adjustment->adjustment_type) }}: {{ $adjustment->quantity_change > 0 ? '+' : '' }}{{ $adjustment->quantity_change }}
                            ({{ $adjustment->created_at->format('d M Y') }})
                        </div>
                        @endforeach
                    </div>
                    @endif
                    @if(!$loop->last)
                    <hr>
                    @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Timeline/History if needed -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">
                        <i class="material-icons align-middle mr-1" style="font-size: 18px;">schedule</i>
                        Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker bg-danger"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Damage Reported</h6>
                                <p class="text-muted mb-1">{{ $damagedItem->created_at->format('d M Y, H:i') }}</p>
                                <small class="text-muted">Reported by {{ $damagedItem->user->name ?? 'Unknown' }}</small>
                            </div>
                        </div>
                        @if($damagedItem->status === 'approved' && $focInventory->count() > 0)
                        <div class="timeline-item">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <h6 class="mb-1">FOC Inventory Created</h6>
                                <p class="text-muted mb-1">{{ $focInventory->first()->created_at->format('d M Y, H:i') }}</p>
                                <small class="text-muted">{{ number_format($focInventory->sum('quantity_available'), 2) }} units added to FOC inventory</small>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding-left: 20px;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -25px;
    top: 0;
    width: 10px;
    height: 10px;
    border-radius: 50%;
}

.timeline-content {
    margin-left: 20px;
}

.border-left-warning {
    border-left: 4px solid #ffc107 !important;
}

.border-left-success {
    border-left: 4px solid #28a745 !important;
}
</style>