@extends('layouts.admin-simple')

@section('title', 'Return Item Details - ' . $itemDetails->item_code)

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.returns') }}">Return Goods</a></li>
    <li class="breadcrumb-item active">{{ $itemDetails->item_code }}</li>
@endsection

@section('page-title')
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">{{ $itemDetails->item_code }} - Return Details</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">{{ $itemDetails->item_description }}</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <a href="{{ route('warehouse.reports.returns') }}" class="btn btn-sm btn-outline-secondary mr-2">
                <i class="material-icons mr-1" style="font-size: 16px;">arrow_back</i>
                Back to Report
            </a>
            <button type="button" onclick="printItemDetails()" class="btn btn-sm btn-info">
                <i class="material-icons mr-1" style="font-size: 16px;">print</i>
                Print Details
            </button>
        </div>
    </div>
@endsection

@section('content')
    <!-- Return Operation Summary -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">assignment_return</i>
                Return Operation Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Operation Number:</strong></td>
                            <td><span class="badge badge-primary">{{ $operationDetails->operation_number }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>Operation Date:</strong></td>
                            <td>{{ $operationDetails->operation_date ? $operationDetails->operation_date->format('d M, Y') : '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Status:</strong></td>
                            <td>
                                <span class="badge badge-{{
                                    $operationDetails->status === 'completed' ? 'success' :
                                    ($operationDetails->status === 'pending' ? 'warning' : 'secondary')
                                }}">
                                    {{ ucfirst(str_replace('_', ' ', $operationDetails->status)) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Project:</strong></td>
                            <td>
                                <div>{{ $operationDetails->project_name }}</div>
                                <small class="text-muted">Code: {{ $operationDetails->project_code }}</small>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Division:</strong></td>
                            <td><span class="badge badge-light">{{ $operationDetails->division_name }}</span></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Received By:</strong></td>
                            <td>{{ $operationDetails->received_by }}</td>
                        </tr>
                        <tr>
                            <td><strong>Inspector:</strong></td>
                            <td>{{ $operationDetails->inspector }}</td>
                        </tr>
                        <tr>
                            <td><strong>Return Reason:</strong></td>
                            <td>
                                @if($operationDetails->return_reason)
                                    <span class="badge badge-outline-warning">{{ $operationDetails->return_reason }}</span>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Created:</strong></td>
                            <td>{{ $operationDetails->created_at ? $operationDetails->created_at->format('d M, Y H:i') : '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Last Updated:</strong></td>
                            <td>{{ $operationDetails->updated_at ? $operationDetails->updated_at->format('d M, Y H:i') : '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
            @if($operationDetails->notes)
                <div class="row mt-3">
                    <div class="col-12">
                        <strong>Operation Notes:</strong>
                        <div class="mt-1 p-2 bg-light rounded">
                            {{ $operationDetails->notes }}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Item Details & Return Information -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">inventory_2</i>
                Item Details & Return Information
            </h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Item Code:</strong></td>
                            <td><code>{{ $itemDetails->item_code }}</code></td>
                        </tr>
                        <tr>
                            <td><strong>Description:</strong></td>
                            <td>{{ $itemDetails->item_description }}</td>
                        </tr>
                        <tr>
                            <td><strong>Category:</strong></td>
                            <td><span class="badge badge-outline-primary">{{ $itemDetails->category_name }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>Unit of Measure:</strong></td>
                            <td>{{ $itemDetails->unit_of_measure }}</td>
                        </tr>
                        <tr>
                            <td><strong>Production Date:</strong></td>
                            <td>{{ $itemDetails->production_date ? $itemDetails->production_date->format('d M, Y') : '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Expiry Date:</strong></td>
                            <td>
                                @if($itemDetails->expiry_date)
                                    <span class="{{ $itemDetails->expiry_date < now() ? 'text-danger' : ($itemDetails->expiry_date < now()->addDays(30) ? 'text-warning' : 'text-success') }}">
                                        {{ $itemDetails->expiry_date->format('d M, Y') }}
                                    </span>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Quantity Returned:</strong></td>
                            <td><strong class="text-warning">{{ number_format($itemDetails->quantity_returned, 2) }} {{ $itemDetails->unit_of_measure }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Unit Price:</strong></td>
                            <td><strong>AED {{ number_format($itemDetails->unit_price, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Total Value:</strong></td>
                            <td><strong class="text-danger">AED {{ number_format($itemDetails->total_value, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Quality Status:</strong></td>
                            <td>
                                <span class="badge badge-{{
                                    $itemDetails->quality_status === 'passed' ? 'success' :
                                    ($itemDetails->quality_status === 'failed' ? 'danger' :
                                    ($itemDetails->quality_status === 'pending' ? 'warning' : 'info'))
                                }}">
                                    {{ ucfirst($itemDetails->quality_status ?: 'Not inspected') }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Batch Number:</strong></td>
                            <td><code>{{ $itemDetails->batch_number ?: 'N/A' }}</code></td>
                        </tr>
                        <tr>
                            <td><strong>Storage Location:</strong></td>
                            <td>{{ $itemDetails->storage_location ?: '-' }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Return Processing & Analysis -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">assessment</i>
                        Return Processing Analysis
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div>
                                <div class="font-weight-medium">Quality Status</div>
                                <small class="text-muted">Quality inspection result</small>
                            </div>
                            <span class="badge badge-{{
                                $itemDetails->quality_status === 'passed' ? 'success' :
                                ($itemDetails->quality_status === 'failed' ? 'danger' :
                                ($itemDetails->quality_status === 'pending' ? 'warning' : 'info'))
                            }} badge-lg">
                                {{ ucfirst($itemDetails->quality_status ?: 'Not inspected') }}
                            </span>
                        </div>

                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div>
                                <div class="font-weight-medium">Acceptance Rate</div>
                                <small class="text-muted">Percentage of accepted items</small>
                            </div>
                            <div class="text-right">
                                <div class="progress" style="width: 100px; height: 20px;">
                                    <div class="progress-bar bg-success" style="width: {{ $itemDetails->acceptance_rate }}%">
                                        {{ round($itemDetails->acceptance_rate, 1) }}%
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div>
                                <div class="font-weight-medium">Batch Information</div>
                                <small class="text-muted">Item batch and serial tracking</small>
                            </div>
                            <div class="text-right">
                                <div>{{ $itemDetails->batch_number ?: 'No batch' }}</div>
                                @if($itemDetails->serial_number)
                                    <small class="text-muted">S/N: {{ $itemDetails->serial_number }}</small>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="mt-3">
                        <div class="text-center p-3 bg-light rounded">
                            <h5 class="mb-1 text-danger">AED {{ number_format($itemDetails->total_value, 2) }}</h5>
                            <small class="text-muted">Total Return Value</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">timeline</i>
                        Record Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker bg-primary"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Return Created</h6>
                                <p class="timeline-text">{{ $itemDetails->created_at ? $itemDetails->created_at->format('d M, Y H:i') : 'Unknown' }}</p>
                                <small class="text-muted">Initial return record created</small>
                            </div>
                        </div>

                        <div class="timeline-item">
                            <div class="timeline-marker bg-warning"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Operation Date</h6>
                                <p class="timeline-text">{{ $operationDetails->operation_date ? $operationDetails->operation_date->format('d M, Y') : 'Unknown' }}</p>
                                <small class="text-muted">When the return operation occurred</small>
                            </div>
                        </div>

                        <div class="timeline-item">
                            <div class="timeline-marker bg-{{
                                $itemDetails->quality_status === 'passed' ? 'success' :
                                ($itemDetails->quality_status === 'failed' ? 'danger' : 'warning')
                            }}"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Quality Inspection</h6>
                                <p class="timeline-text">{{ ucfirst($itemDetails->quality_status ?: 'Pending') }}</p>
                                <small class="text-muted">Quality inspection result</small>
                            </div>
                        </div>

                        <div class="timeline-item">
                            <div class="timeline-marker bg-info"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Last Updated</h6>
                                <p class="timeline-text">{{ $itemDetails->updated_at ? $itemDetails->updated_at->format('d M, Y H:i') : 'Unknown' }}</p>
                                <small class="text-muted">Most recent record modification</small>
                            </div>
                        </div>
                    </div>

                    <div class="mt-3">
                        <small class="text-muted">
                            <strong>Return Item ID:</strong> {{ $itemDetails->id }}<br>
                            <strong>Operation ID:</strong> {{ $operationDetails->id }}
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .table-borderless td {
            border: none;
            padding: 0.25rem 0.5rem;
        }

        .badge-outline-primary {
            color: #007bff;
            border: 1px solid #007bff;
            background-color: transparent;
        }

        .badge-outline-warning {
            color: #ffc107;
            border: 1px solid #ffc107;
            background-color: transparent;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            font-size: 12px;
        }

        .table td {
            font-size: 13px;
            vertical-align: middle;
        }

        .list-group-item {
            border-left: none;
            border-right: none;
        }

        code {
            font-size: 12px;
            color: #6c757d;
            background-color: #f8f9fa;
            padding: 2px 6px;
            border-radius: 3px;
        }

        .badge-lg {
            padding: 0.5rem 0.75rem;
            font-size: 12px;
        }

        .timeline {
            position: relative;
            padding-left: 30px;
        }

        .timeline::before {
            content: '';
            position: absolute;
            left: 15px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: #e9ecef;
        }

        .timeline-item {
            position: relative;
            margin-bottom: 20px;
        }

        .timeline-marker {
            position: absolute;
            left: -23px;
            top: 0;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            border: 2px solid #fff;
            z-index: 1;
        }

        .timeline-content {
            padding-left: 10px;
        }

        .timeline-title {
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .timeline-text {
            font-size: 13px;
            margin-bottom: 5px;
        }
    </style>
@endpush

@push('scripts')
    <script>
        function printItemDetails() {
            window.print();
        }
    </script>
@endpush