@extends('layouts.admin-simple')

@section('title', 'Material Issue Report')

@section('breadcrumb')
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="{{ route('warehouse.reports.index') }}">Reports</a></li>
    <li class="breadcrumb-item active">Material Issue</li>
@endsection

@section('page-title')
    <div class="page-title-left">
        <h3 class="mb-1">Material Issue Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">All material issue and dispatch history</p>
    </div>
@endsection

@section('content')
    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Total Transactions"
                :value="$stats['total']"
                icon="receipt_long"
                color="primary"
                subtitle="All material transactions"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Incoming Operations"
                :value="$stats['incoming']"
                icon="download"
                color="success"
                subtitle="Supply deliveries & returns"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Outgoing/Direct"
                :value="$stats['outgoing'] + $stats['direct_deliveries']"
                icon="upload"
                color="info"
                subtitle="Outgoing & Direct Deliveries"
            />
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <x-warehouse.stats-card
                title="Material Transfers"
                :value="$stats['transfers']"
                icon="swap_horiz"
                color="warning"
                subtitle="Inter-project transfers"
            />
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4 warehouse-filters-panel">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form id="filterForm" class="warehouse-filter-form" method="GET" action="{{ route('warehouse.reports.transactions') }}">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="{{ request('search') }}" class="form-control" 
                               placeholder="Transaction ID, reference">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Transaction Type</label>
                        <select name="type" class="form-control warehouse-select2" data-placeholder="All Types">
                            <option value="">All Types</option>
                            <option value="supplier_delivery" {{ request('type') == 'supplier_delivery' ? 'selected' : '' }}>Supplier Delivery</option>
                            <option value="outgoing" {{ request('type') == 'outgoing' ? 'selected' : '' }}>Material Request</option>
                            <option value="direct_delivery" {{ request('type') == 'direct_delivery' ? 'selected' : '' }}>Direct Delivery</option>
                            <option value="transfer" {{ request('type') == 'transfer' ? 'selected' : '' }}>Material Transfer</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control warehouse-select2" data-placeholder="All Statuses">
                            <option value="">All Statuses</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                            <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Division</label>
                        <select name="division_id" class="form-control warehouse-select2" data-placeholder="All Divisions">
                            <option value="">All Divisions</option>
                            @foreach($divisions as $division)
                                <option value="{{ $division->id }}" {{ request('division_id') == $division->id ? 'selected' : '' }}>
                                    {{ $division->division_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control warehouse-datepicker">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control warehouse-datepicker">
                    </div>

                    <div class="col-md-1 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="material-icons" style="font-size: 18px; vertical-align: middle;">search</i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Export Buttons -->
    <div class="row warehouse-export-buttons">
        <div class="col-12 text-right">
            <button class="btn btn-success warehouse-export-btn" data-export="excel">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">download</i>
                Export Excel
            </button>
            <button class="btn btn-info warehouse-export-btn" data-export="pdf">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">picture_as_pdf</i>
                Export PDF
            </button>
            <button class="btn btn-secondary warehouse-export-btn" data-action="print">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">print</i>
                Print
            </button>
        </div>
    </div>

    <!-- Material Issue Report Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">receipt_long</i>
                Material Issue History ({{ $transactions->total() }} total transactions)
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay">
                    <div class="warehouse-loading-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading transaction data...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 150px;">Transaction ID</th>
                                <th style="min-width: 100px;">Date</th>
                                <th style="min-width: 120px;">Type</th>
                                <th style="min-width: 150px;">Reference</th>
                                <th style="min-width: 180px;">Entity/Supplier</th>
                                <th style="min-width: 180px;">Project</th>
                                <th style="min-width: 100px;" class="text-center">Status</th>
                                <th style="min-width: 150px;">Created By</th>
                                <th style="min-width: 80px;" class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactions as $transaction)
                                <tr>
                                    <td class="warehouse-cell-nowrap">{{ $transaction['id'] }}</td>
                                    <td class="warehouse-cell-date">
                                        {{ \Carbon\Carbon::parse($transaction['date'])->format('d M Y') }}
                                    </td>
                                    <td>
                                        <span class="badge warehouse-badge warehouse-status-{{ $transaction['type_badge'] }}">
                                            {{ $transaction['type'] }}
                                        </span>
                                    </td>
                                    <td class="warehouse-cell-nowrap">{{ $transaction['reference'] ?: '-' }}</td>
                                    <td>{{ Str::limit($transaction['entity'], 25) }}</td>
                                    <td>{{ Str::limit($transaction['project'], 25) }}</td>
                                    <td class="warehouse-cell-status">
                                        <span class="badge warehouse-badge warehouse-status-{{ $transaction['status_badge'] }}">
                                            {{ $transaction['status'] }}
                                        </span>
                                    </td>
                                    <td>{{ $transaction['created_by'] }}</td>
                                    <td class="text-center">
                                        @if($transaction['model'] == 'incoming')
                                            <a href="{{ route('warehouse.incoming-operations.show', $transaction['model_id']) }}" 
                                               class="btn btn-sm btn-outline-primary warehouse-action-btn">
                                                <i class="material-icons">visibility</i>
                                            </a>
                                        @elseif($transaction['model'] == 'outgoing')
                                            <a href="{{ route('warehouse.outgoing.show', $transaction['model_id']) }}" 
                                               class="btn btn-sm btn-outline-primary warehouse-action-btn">
                                                <i class="material-icons">visibility</i>
                                            </a>
                                        @elseif($transaction['model'] == 'direct_delivery')
                                            <a href="{{ route('warehouse.direct-deliveries.show', $transaction['model_id']) }}" 
                                               class="btn btn-sm btn-outline-primary warehouse-action-btn">
                                                <i class="material-icons">visibility</i>
                                            </a>
                                        @elseif($transaction['model'] == 'transfer')
                                            <a href="{{ route('warehouse.transfer-requests.show', $transaction['model_id']) }}" 
                                               class="btn btn-sm btn-outline-primary warehouse-action-btn">
                                                <i class="material-icons">visibility</i>
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="warehouse-empty-state">
                                        <i class="material-icons">receipt_long</i>
                                        <h5>No Material Transactions Found</h5>
                                        <p class="text-muted">No transactions match your current filters.</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        @if($transactions->hasPages())
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        Showing {{ $transactions->firstItem() }} to {{ $transactions->lastItem() }} 
                        of {{ $transactions->total() }} transactions
                    </div>
                    <div>
                        <nav class="warehouse-pagination">
                            {{ $transactions->links('pagination::bootstrap-4') }}
                        </nav>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection

@push('styles')
    <link href="{{ asset('admin-assets/css/warehouse-reports.css') }}" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
    <style>
        .select2-container--bootstrap-5 .select2-selection {
            min-height: 38px;
            border: 1px solid #ced4da;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__arrow {
            height: 36px;
        }
        .select2-container {
            width: 100% !important;
        }
    </style>
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('admin-assets/js/warehouse-reports.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for filter dropdowns
            $('.warehouse-select2').select2({
                theme: 'bootstrap-5',
                allowClear: true,
                placeholder: function() {
                    return $(this).data('placeholder') || 'Select...';
                }
            });
        });
    </script>
@endpush