<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Transfers Report</title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
            @page { size: landscape; }
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            margin: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
        }

        .logo-container {
            flex-shrink: 0;
        }

        .logo-container img {
            height: 80px;
            width: auto;
        }

        .company-info {
            flex: 1;
            text-align: center;
        }

        .company-name {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 2px;
            text-transform: uppercase;
        }

        .company-address {
            font-size: 10px;
            margin-bottom: 1px;
        }

        .document-title {
            font-size: 14px;
            font-weight: bold;
            margin: 20px 0;
            text-transform: uppercase;
            text-align: center;
            background-color: #000;
            color: #fff;
            padding: 10px;
        }

        .info-section {
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .info-row {
            font-size: 12px;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }

        .items-table th,
        .items-table td {
            border: 1px solid #000;
            padding: 5px 8px;
            text-align: left;
        }

        .items-table th {
            font-weight: bold;
            background-color: #f0f0f0;
        }

        .items-table td.text-center {
            text-align: center;
        }

        .items-table td.text-right {
            text-align: right;
        }

        .status-badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }

        .status-pending {
            background-color: #fff3cd;
            color: #856404;
        }

        .status-completed {
            background-color: #d4edda;
            color: #155724;
        }

        .status-cancelled {
            background-color: #f8d7da;
            color: #721c24;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }

        .print-btn {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 4px;
            margin-bottom: 20px;
        }

        .print-btn:hover {
            background-color: #0056b3;
        }

        .summary-section {
            margin-top: 20px;
            padding-top: 20px;
            border-top: 2px solid #000;
        }

        .summary-item {
            display: inline-block;
            margin-right: 30px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()" class="print-btn">🖨️ Print</button>
        <button onclick="window.close()" class="print-btn" style="background-color: #6c757d;">✕ Close</button>
    </div>

    <!-- Header -->
    <div class="header">
        <div class="logo-container">
            <img src="{{ asset('images/site_logo.png') }}" alt="Company Logo">
        </div>
        <div class="company-info">
            <div class="company-name">ISAM KABBANI & PARTNERS FOR CONSTRUCTION & MAINT. CO. ( L.L.C )</div>
            <div class="company-address">Dubai: Dubai Industrial City, Jebel Ali Tel# 04 818 1900; Fax# 04 429 7031</div>
            <div class="company-address">E-mail : dubai@kcgemirates.ae; abudhabi@kcgemirates.ae   Website : www.ikkgroup.com</div>
        </div>
    </div>

    <!-- Document Title -->
    <div class="document-title">SITE TRANSFERS REPORT</div>

    <!-- Report Info -->
    <div class="info-section">
        <div class="info-row">
            <strong>Report Date:</strong> {{ now()->format('d/m/Y') }}
        </div>
        <div class="info-row">
            <strong>Report Time:</strong> {{ now()->format('H:i:s') }}
        </div>
        @if(request('date_from') || request('date_to'))
        <div class="info-row">
            <strong>Period:</strong>
            {{ request('date_from') ? \Carbon\Carbon::parse(request('date_from'))->format('d/m/Y') : 'All' }} -
            {{ request('date_to') ? \Carbon\Carbon::parse(request('date_to'))->format('d/m/Y') : 'All' }}
        </div>
        @endif
        @if(request('status'))
        <div class="info-row">
            <strong>Status Filter:</strong> {{ ucfirst(request('status')) }}
        </div>
        @endif
    </div>

    <!-- Transfers Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th style="width: 5%;">Sr.</th>
                <th style="width: 10%;">Transfer #</th>
                <th style="width: 10%;">Date</th>
                <th style="width: 18%;">From Project</th>
                <th style="width: 18%;">To Project</th>
                <th style="width: 8%;">Items</th>
                <th style="width: 10%;">Total Value</th>
                <th style="width: 13%;">Transferred By</th>
                <th style="width: 8%;">Status</th>
            </tr>
        </thead>
        <tbody>
            @forelse($transfers as $index => $transfer)
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td class="text-center">{{ $transfer->transfer_number }}</td>
                <td class="text-center">{{ $transfer->transfer_date->format('d/m/Y') }}</td>
                <td>{{ $transfer->fromProject ? ($transfer->fromProject->project_number . ' - ' . $transfer->fromProject->project_name) : 'N/A' }}</td>
                <td>{{ $transfer->toProject ? ($transfer->toProject->project_number . ' - ' . $transfer->toProject->project_name) : 'N/A' }}</td>
                <td class="text-center">{{ $transfer->items->count() }}</td>
                <td class="text-right">AED {{ number_format($transfer->total_value, 2) }}</td>
                <td>{{ $transfer->transferredBy->name ?? 'N/A' }}</td>
                <td class="text-center">
                    <span class="status-badge status-{{ strtolower($transfer->status) }}">
                        {{ ucfirst($transfer->status) }}
                    </span>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="9" class="text-center">No site transfers found</td>
            </tr>
            @endforelse
        </tbody>
        @if($transfers->count() > 0)
        <tfoot>
            <tr style="font-weight: bold;">
                <td colspan="5" class="text-right">TOTAL:</td>
                <td class="text-center">{{ $transfers->sum(function($t) { return $t->items->count(); }) }}</td>
                <td class="text-right">AED {{ number_format($transfers->sum('total_value'), 2) }}</td>
                <td colspan="2"></td>
            </tr>
        </tfoot>
        @endif
    </table>

    <!-- Summary Section -->
    @if($transfers->count() > 0)
    <div class="summary-section">
        <div class="summary-item">
            Total Transfers: {{ $transfers->count() }}
        </div>
        <div class="summary-item">
            Completed: {{ $transfers->where('status', 'completed')->count() }}
        </div>
        <div class="summary-item">
            Pending: {{ $transfers->where('status', 'pending')->count() }}
        </div>
        <div class="summary-item">
            Cancelled: {{ $transfers->where('status', 'cancelled')->count() }}
        </div>
    </div>
    @endif

    <!-- Footer -->
    <div class="footer">
        <p>Generated on {{ now()->format('d/m/Y H:i') }}</p>
    </div>

    <script>
        // Auto-print when page loads
        window.addEventListener('load', function() {
            setTimeout(() => {
                if (window.opener) {
                    window.print();
                }
            }, 500);
        });

        // Close window after printing
        window.addEventListener('afterprint', function() {
            if (window.opener) {
                setTimeout(() => {
                    window.close();
                }, 500);
            }
        });
    </script>
</body>
</html>