<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
// Career-related imports removed

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


// Redirect root to admin login
Route::get('/', function () {
    return redirect()->route('admin.login');
})->name('home');

// Frontend routes commented out - admin only access
/*
// About routes
Route::get('/about', [App\Http\Controllers\PageController::class, 'show'])
    ->defaults('routeName', 'about')
    ->name('about')
    ->middleware('check.page.status');
*/

/*
// Product routes
Route::get('/products', [\App\Http\Controllers\ProductController::class, 'index'])->name('products');

Route::prefix('products')->group(function () {
    Route::get('/float-glass', [\App\Http\Controllers\ProductController::class, 'floatGlass'])->name('products.float-glass');
    Route::get('/mirror-glass', [\App\Http\Controllers\ProductController::class, 'mirrorGlass'])->name('products.mirror-glass');
    Route::get('/pattern-glass', [\App\Http\Controllers\ProductController::class, 'patternGlass'])->name('products.pattern-glass');
    Route::get('/decorative-mirror', [\App\Http\Controllers\ProductController::class, 'decorativeMirror'])->name('products.decorative-mirror');
    
    // Product detail routes with category grouping
    Route::get('/{category}/{product}', [\App\Http\Controllers\ProductController::class, 'show'])->name('products.show');
});
*/

/*
// Quality & Certifications
Route::get('/quality', [App\Http\Controllers\PageController::class, 'show'])
    ->defaults('routeName', 'quality')
    ->name('quality')
    ->middleware('check.page.status');
*/

/*
// Investors routes removed
*/

/*
// Reports
Route::get('/reports', function () {
    $financialReports = \App\Models\Report::active()->byCategory('financial')->ordered()->get();
    $boardReports = \App\Models\Report::active()->byCategory('board')->ordered()->get();
    $annualReports = \App\Models\Report::active()->byCategory('annual')->ordered()->get();
    
    return view('pages.reports', compact('financialReports', 'boardReports', 'annualReports'));
})->name('reports');
*/

/*
// News
Route::get('/news', [App\Http\Controllers\NewsController::class, 'index'])->name('news');
Route::get('/news/{slug}', [App\Http\Controllers\NewsController::class, 'show'])->name('news.show');
*/

/*
// Videos/Gallery
Route::get('/videos', function () {
    $featuredVideo = \App\Models\Video::active()->published()->featured()->first();
    $videos = \App\Models\Video::active()->published()->ordered()->get();
    return view('pages.videos', compact('featuredVideo', 'videos'));
})->name('videos');
*/

/*
// API route for video view tracking
Route::post('/api/videos/{video}/view', function (\App\Models\Video $video) {
    $video->incrementViews();
    return response()->json(['success' => true, 'views' => $video->views_count]);
});
*/

/*
// Public report download
Route::get('/reports/{report}/download', [App\Http\Controllers\Admin\ReportController::class, 'download'])->name('reports.download');
*/

/*
// Careers
Route::get('/careers', function () {
    $jobPositions = JobPosition::active()->recent()->get();
    return view('pages.careers', compact('jobPositions'));
})->name('careers');
*/

/*
// Job Applications
Route::post('/job-applications', [JobApplicationController::class, 'store'])->name('job-applications.store');

// Career Enquiries
Route::post('/career-enquiries', [CareerEnquiryController::class, 'store'])->name('career-enquiries.store');
*/

/*
// Contact routes removed
*/

/*
// API route for video configurations
Route::get('/api/video-configs', [App\Http\Controllers\Admin\VideoSettingController::class, 'getVideoConfigs'])->name('api.video-configs');
*/

/*
// Investor Inquiries routes removed
*/

/*
// Newsletter subscription
Route::post('/newsletter/subscribe', function () {
    // Handle newsletter subscription
    return response()->json(['success' => true, 'message' => 'Thank you for subscribing!']);
})->name('newsletter.subscribe');
*/

/*
// Legal pages
Route::get('/privacy', [App\Http\Controllers\PageController::class, 'show'])
    ->defaults('routeName', 'privacy')
    ->name('privacy')
    ->middleware('check.page.status');

Route::get('/terms', [App\Http\Controllers\PageController::class, 'show'])
    ->defaults('routeName', 'terms')
    ->name('terms')
    ->middleware('check.page.status');
*/

// Include warehouse routes
require __DIR__.'/warehouse.php';

// Admin routes
Route::prefix('admin')->group(function () {
    Route::get('/login', [AdminController::class, 'showLogin'])->name('admin.login');
    Route::post('/login', [AdminController::class, 'login'])->name('admin.login.post');
    
    Route::middleware(['auth'])->group(function () {
        Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
        Route::post('/logout', [AdminController::class, 'logout'])->name('admin.logout');
        
        // Profile Settings
        Route::get('/profile', [App\Http\Controllers\Admin\ProfileController::class, 'index'])->name('admin.profile');
        Route::post('/profile/update', [App\Http\Controllers\Admin\ProfileController::class, 'updateProfile'])->name('admin.profile.update');
        Route::post('/profile/password', [App\Http\Controllers\Admin\ProfileController::class, 'updatePassword'])->name('admin.profile.password');
        Route::post('/profile/avatar', [App\Http\Controllers\Admin\ProfileController::class, 'updateAvatar'])->name('admin.profile.avatar');
        Route::delete('/profile/avatar', [App\Http\Controllers\Admin\ProfileController::class, 'removeAvatar'])->name('admin.profile.avatar.remove');
        
        // Career management routes removed
        
        // Team Member Management Removed
        
        // Contact Inquiry Management Removed
        
        // User Management
        Route::get('/users', [App\Http\Controllers\Admin\UserManagementController::class, 'index'])->name('admin.users');
        Route::post('/users', [App\Http\Controllers\Admin\UserManagementController::class, 'store'])->name('admin.users.store');
        Route::put('/users/{user}', [App\Http\Controllers\Admin\UserManagementController::class, 'update'])->name('admin.users.update');
        Route::delete('/users/{user}', [App\Http\Controllers\Admin\UserManagementController::class, 'destroy'])->name('admin.users.delete');
        Route::post('/users/{user}/reset-password', [App\Http\Controllers\Admin\UserManagementController::class, 'resetPassword'])->name('admin.users.reset-password');
        
        // Role & Permission Management
        Route::get('/roles', [App\Http\Controllers\Admin\RoleManagementController::class, 'index'])->name('admin.roles');
        Route::get('/roles/create', [App\Http\Controllers\Admin\RoleManagementController::class, 'create'])->name('admin.roles.create');
        Route::post('/roles', [App\Http\Controllers\Admin\RoleManagementController::class, 'store'])->name('admin.roles.store');
        Route::get('/roles/{role}/edit', [App\Http\Controllers\Admin\RoleManagementController::class, 'edit'])->name('admin.roles.edit');
        Route::post('/roles/{role}/duplicate', [App\Http\Controllers\Admin\RoleManagementController::class, 'duplicate'])->name('admin.roles.duplicate');
        Route::patch('/roles/{role}/toggle-status', [App\Http\Controllers\Admin\RoleManagementController::class, 'toggleStatus'])->name('admin.roles.toggle-status');
        Route::get('/roles/{role}', [App\Http\Controllers\Admin\RoleManagementController::class, 'show'])->name('admin.roles.show');
        Route::put('/roles/{role}', [App\Http\Controllers\Admin\RoleManagementController::class, 'update'])->name('admin.roles.update');
        Route::delete('/roles/{role}', [App\Http\Controllers\Admin\RoleManagementController::class, 'destroy'])->name('admin.roles.delete');
        Route::get('/permissions', [App\Http\Controllers\Admin\RoleManagementController::class, 'permissions'])->name('admin.permissions');
        
        // Department Management
        Route::get('/departments', [App\Http\Controllers\Admin\DepartmentController::class, 'index'])->name('admin.departments');
        Route::post('/departments', [App\Http\Controllers\Admin\DepartmentController::class, 'store'])->name('admin.departments.store');
        Route::put('/departments/{department}', [App\Http\Controllers\Admin\DepartmentController::class, 'update'])->name('admin.departments.update');
        Route::delete('/departments/{department}', [App\Http\Controllers\Admin\DepartmentController::class, 'destroy'])->name('admin.departments.delete');
        
        // Activity Logs
        Route::get('/activity-logs', [App\Http\Controllers\Admin\ActivityLogController::class, 'index'])->name('admin.activity-logs');
        Route::post('/activity-logs/clear', [App\Http\Controllers\Admin\ActivityLogController::class, 'clear'])->name('admin.activity-logs.clear');
        
        // News management routes removed
        
        // Category management routes removed
        
        // Video management routes removed
        
        // Video settings management routes removed
        
        // Simple video management routes removed
        
        // Page management routes removed
        
        // Report management routes removed
        
        // Investor Inquiries Management Removed
        
        // Product management routes removed
        
        // Product specifications routes removed
        
        // Technical Specifications (commented out - controller missing)
        // Route::post('technical-specifications', [App\Http\Controllers\Admin\TechnicalSpecificationController::class, 'store'])->name('admin.technical-specifications.store');
        // Route::delete('technical-specifications/{specification}', [App\Http\Controllers\Admin\TechnicalSpecificationController::class, 'destroy'])->name('admin.technical-specifications.destroy');
        
        // Product API routes removed
        
        // Site Settings Management (read-only with bulk update)
        Route::get('site-settings', [App\Http\Controllers\Admin\SiteSettingController::class, 'index'])->name('admin.site-settings.index');
        Route::post('site-settings/bulk-update', [App\Http\Controllers\Admin\SiteSettingController::class, 'bulkUpdate'])->name('admin.site-settings.bulk-update');
    });
});
