<?php $__env->startSection('title', 'Material Issue Decision Center'); ?>


<!-- Last updated: <?php echo e(now()); ?> -->

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Material Issue</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Material Issue Decision Center</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Process material requests and decide issue method</p>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Flash Messages are handled by the layout -->

    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Decisions','value' => $stats['pending_decisions'],'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Awaiting issue decision']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Decisions','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['pending_decisions']),'icon' => 'pending_actions','color' => 'warning','subtitle' => 'Awaiting issue decision']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Inventory Issues','value' => $stats['inventory_issues'],'icon' => 'inventory','color' => 'success','subtitle' => 'Dispatched from warehouse']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Inventory Issues','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['inventory_issues']),'icon' => 'inventory','color' => 'success','subtitle' => 'Dispatched from warehouse']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Direct Deliveries','value' => $stats['direct_deliveries'],'icon' => 'local_shipping','color' => 'info','subtitle' => 'Supplier deliveries']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Direct Deliveries','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['direct_deliveries']),'icon' => 'local_shipping','color' => 'info','subtitle' => 'Supplier deliveries']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Project Transfers','value' => $stats['project_transfers'],'icon' => 'swap_horiz','color' => 'primary','subtitle' => 'Inter-project transfers']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Project Transfers','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($stats['project_transfers']),'icon' => 'swap_horiz','color' => 'primary','subtitle' => 'Inter-project transfers']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('warehouse.material-issue.index')); ?>" id="filterForm">
                <div class="row">
                    <div class="col-md-4">
                        <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'project_id','id' => 'project_filter','label' => 'Project','placeholder' => 'All Projects','options' => collect([['value' => '', 'text' => 'All Projects']])->merge($projects->map(function($project) {
                                return ['value' => $project->id, 'text' => $project->project_name];
                            })),'selected' => request('project_id'),'allowClear' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'project_id','id' => 'project_filter','label' => 'Project','placeholder' => 'All Projects','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(collect([['value' => '', 'text' => 'All Projects']])->merge($projects->map(function($project) {
                                return ['value' => $project->id, 'text' => $project->project_name];
                            }))),'selected' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(request('project_id')),'allowClear' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_from">From Date</label>
                            <input type="date" name="date_from" id="date_from" class="form-control"
                                   value="<?php echo e(request('date_from')); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="date_to">To Date</label>
                            <input type="date" name="date_to" id="date_to" class="form-control"
                                   value="<?php echo e(request('date_to')); ?>">
                        </div>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <div class="form-group w-100">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                                Filter
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Pending Material Requests -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">assignment</i>
                Material Requests
            </h5>
        </div>
        <div class="card-body p-0">
            <?php if($pendingRequests->count() > 0): ?>
                <div class="warehouse-table-container">
                    <!-- Loading Overlay -->
                    <div class="warehouse-loading-overlay" id="tableLoadingOverlay" style="display: none;">
                        <div class="warehouse-loading-content">
                            <div class="text-center">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="sr-only">Loading...</span>
                                </div>
                                <div class="mt-2">Loading material requests...</div>
                            </div>
                        </div>
                    </div>

                    <!-- Table -->
                    <div class="warehouse-table-wrapper">
                        <table class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 140px;">Request #</th>
                                <th style="min-width: 120px;">Request Date</th>
                                <th style="min-width: 200px;">Project</th>
                                <th style="min-width: 150px;">Requested By</th>
                                <th style="min-width: 100px;">Items Count</th>
                                <th style="min-width: 100px;">Priority</th>
                                <th style="min-width: 130px;">Dispatch Status</th>
                                <th style="min-width: 180px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $pendingRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="white-space: nowrap;">
                                        <strong class="text-primary">
                                            <?php echo e($request->material_request_number ?: 'MR-' . str_pad($request->id, 6, '0', STR_PAD_LEFT)); ?>

                                        </strong>
                                    </td>
                                    <td><?php echo e($request->transaction_date->format('d-M-Y')); ?></td>
                                    <td>
                                        <div>
                                            <strong><?php echo e($request->project->project_name ?? 'N/A'); ?></strong>
                                            <?php if($request->division): ?>
                                                <br><small class="text-muted"><?php echo e($request->division->division_name); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td><?php echo e($request->requester->name ?? 'N/A'); ?></td>
                                    <td>
                                        <span class="badge badge-light"><?php echo e($request->items->count()); ?> items</span>
                                    </td>
                                    <td>
                                        <?php
                                            $daysSince = round($request->transaction_date->diffInDays(now()));
                                            if ($daysSince > 7) {
                                                $priority = 'High';
                                                $priorityClass = 'danger';
                                            } elseif ($daysSince > 3) {
                                                $priority = 'Medium';
                                                $priorityClass = 'warning';
                                            } else {
                                                $priority = 'Normal';
                                                $priorityClass = 'success';
                                            }
                                        ?>
                                        <span class="badge badge-<?php echo e($priorityClass); ?>">
                                            <?php echo e($priority); ?>

                                        </span>
                                        <br><small class="text-muted"><?php echo e($daysSince); ?> day<?php echo e($daysSince != 1 ? 's' : ''); ?></small>
                                    </td>
                                    <td>
                                        <?php
                                            // Calculate dispatch status based on actual quantities from fulfillments
                                            $totalRequested = $request->items->sum('quantity_requested');
                                            $totalFulfilled = \App\Models\Warehouse\OutgoingFulfillment::where('outgoing_transaction_id', $request->id)
                                                                ->sum('quantity_fulfilled');
                                            
                                            // Debug - remove after testing
                                            \Log::info('Material Issue Dispatch Debug', [
                                                'request_id' => $request->id,
                                                'request_number' => $request->material_request_number,
                                                'status' => $request->status,
                                                'items_count' => $request->items->count(),
                                                'total_requested' => $totalRequested,
                                                'total_fulfilled' => $totalFulfilled,
                                                'total_released_old' => $request->items->sum('quantity_released'),
                                            ]);

                                            if (in_array($request->status, ['canceled', 'cancelled']) || $totalFulfilled == 0) {
                                                $dispatchStatus = 'pending';
                                                $dispatchClass = 'badge-light';
                                                $dispatchIcon = 'hourglass_empty';
                                                $dispatchLabel = 'Pending';
                                            } elseif ($totalFulfilled >= $totalRequested) {
                                                $dispatchStatus = 'fully_dispatched';
                                                $dispatchClass = 'badge-success';
                                                $dispatchIcon = 'check_circle';
                                                $dispatchLabel = 'Fully Dispatched';
                                            } else {
                                                $dispatchStatus = 'partially_dispatched';
                                                $dispatchClass = 'badge-warning';
                                                $dispatchIcon = 'schedule';
                                                $dispatchLabel = 'Partially Dispatched';
                                            }
                                        ?>
                                        <span class="badge <?php echo e($dispatchClass); ?>">
                                            <i class="material-icons" style="font-size: 12px;"><?php echo e($dispatchIcon); ?></i>
                                            <?php echo e($dispatchLabel); ?>

                                        </span>
                                    </td>
                                    <td style="white-space: nowrap;">
                                        <div class="d-flex align-items-center">
                                            <?php if($dispatchStatus !== 'fully_dispatched'): ?>
                                                <!-- Process Button - only show if not fully dispatched -->
                                                <a href="<?php echo e(route('warehouse.material-issue.show', $request->id)); ?>"
                                                   class="btn btn-sm btn-success mr-1"
                                                   title="Process Request">
                                                    <i class="material-icons mr-1" style="font-size: 14px;">assignment</i>
                                                    Process
                                                </a>
                                            <?php endif; ?>

                                            <!-- View Details Button -->
                                            <a href="<?php echo e(route('warehouse.inventory.material-requests.view', $request->id)); ?>"
                                               class="btn btn-sm btn-outline-primary mr-1"
                                               title="View Details">
                                                <i class="material-icons" style="font-size: 14px;">visibility</i>
                                                <?php if($dispatchStatus === 'fully_dispatched'): ?>
                                                    View Details
                                                <?php else: ?>
                                                    View
                                                <?php endif; ?>
                                            </a>

                                            <!-- Print Button -->
                                            <button type="button"
                                                    class="btn btn-sm btn-outline-info"
                                                    onclick="printMaterialRequest(<?php echo e($request->id); ?>)"
                                                    title="Print Request">
                                                <i class="material-icons" style="font-size: 14px;">print</i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    </div>
                </div>

                <!-- Pagination -->
                <?php if($pendingRequests->hasPages()): ?>
                    <div class="mt-3">
                        <?php echo e($pendingRequests->links('pagination::bootstrap-4')); ?>

                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 64px;">assignment_turned_in</i>
                    <h5 class="text-muted">No Pending Requests</h5>
                    <p class="text-muted">All material requests have been processed</p>
                </div>
            <?php endif; ?>
        </div>
    </div>


    <!-- Process Info Card -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-left-info">
                <div class="card-body">
                    <h6 class="text-info mb-2">
                        <i class="material-icons align-middle mr-1">info</i>
                        Material Issue Process
                    </h6>
                    <div class="row">
                        <div class="col-md-4">
                            <h6 class="font-weight-bold text-success">
                                <i class="material-icons align-middle mr-1">inventory</i>
                                Inventory Dispatch
                            </h6>
                            <ul class="text-sm mb-0">
                                <li>Issue materials from warehouse stock</li>
                                <li>Direct inventory deduction</li>
                                <li>Immediate project allocation</li>
                            </ul>
                        </div>
                        <div class="col-md-4">
                            <h6 class="font-weight-bold text-info">
                                <i class="material-icons align-middle mr-1">local_shipping</i>
                                Direct Delivery
                            </h6>
                            <ul class="text-sm mb-0">
                                <li>Order directly from supplier</li>
                                <li>Direct site delivery</li>
                                <li>Purchase order management</li>
                            </ul>
                        </div>
                        <div class="col-md-4">
                            <h6 class="font-weight-bold text-primary">
                                <i class="material-icons align-middle mr-1">swap_horiz</i>
                                Project Transfer
                            </h6>
                            <ul class="text-sm mb-0">
                                <li>Transfer from another project</li>
                                <li>Inter-project material sharing</li>
                                <li>Requires source project approval</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- View Details Modal -->
<div class="modal fade" id="viewDetailsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="material-icons align-middle mr-1">assignment</i>
                    Material Request Details
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body" id="modalContent">
                <!-- Content will be loaded dynamically -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
<script>
function printMaterialRequest(id) {
    console.log('printMaterialRequest called with id:', id);

    // Open print view in new window - using Laravel route helper
    const printUrl = '<?php echo e(route("warehouse.inventory.material-issued.print", ":id")); ?>'.replace(':id', id);
    console.log('Opening print URL:', printUrl);
    const printWindow = window.open(printUrl, '_blank', 'width=800,height=600,scrollbars=yes,resizable=yes');

    if (printWindow) {
        printWindow.focus();

        // Wait for content to load then print
        printWindow.addEventListener('load', function() {
            setTimeout(() => {
                printWindow.print();
            }, 1000);
        });
    } else {
        // Fallback: navigate to print page if popup blocked
        window.open(printUrl, '_blank');
    }
}

function viewRequestDetails(id) {
    $('#viewDetailsModal').modal('show');
    $('#modalContent').html('<div class="text-center py-3"><i class="material-icons fa-spin">refresh</i> Loading...</div>');

    // Fetch request details (you'll need to implement this route)
    fetch(`/warehouse/outgoing/${id}`)
        .then(response => response.json())
        .then(data => {
            let itemsHtml = data.items.map(item => `
                <tr>
                    <td>${item.item.item_code}</td>
                    <td>${item.item.item_description}</td>
                    <td>${item.quantity_requested} ${item.item.unit_of_measure}</td>
                </tr>
            `).join('');

            $('#modalContent').html(`
                <div class="row">
                    <div class="col-md-6">
                        <strong>Request Number:</strong><br>
                        <span class="text-primary">${data.material_request_number || 'MR-' + data.id.toString().padStart(6, '0')}</span>
                    </div>
                    <div class="col-md-6">
                        <strong>Date:</strong><br>
                        ${new Date(data.transaction_date).toLocaleDateString()}
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-md-6">
                        <strong>Project:</strong><br>
                        ${data.project ? data.project.project_name : 'N/A'}
                    </div>
                    <div class="col-md-6">
                        <strong>Requested By:</strong><br>
                        ${data.requester ? data.requester.name : 'N/A'}
                    </div>
                </div>
                <div class="mt-3">
                    <strong>Requested Items:</strong>
                    <table class="table table-sm mt-2">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Description</th>
                                <th>Quantity</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${itemsHtml}
                        </tbody>
                    </table>
                </div>
            `);
        })
        .catch(error => {
            $('#modalContent').html('<div class="alert alert-danger">Error loading request details</div>');
        });
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/material-issue/index.blade.php ENDPATH**/ ?>