<?php $__env->startSection('title', 'Stock Adjustments'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item">Inventory</li>
    <li class="breadcrumb-item active">Stock Adjustments</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Stock Adjustments</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Track and manage all inventory adjustments</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.adjust')): ?>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="showImportModal()" class="btn btn-sm btn-success mr-2" title="Import stock adjustments from Excel file">
                <i class="material-icons mr-1" style="font-size: 16px;">upload_file</i>
                Import
            </button>

            <button type="button" onclick="exportAdjustments()" class="btn btn-sm btn-info mr-2" title="Export adjustments to Excel file">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>

            <button type="button" onclick="showNewAdjustmentModal()" class="btn btn-sm btn-primary" title="Create new stock adjustment">
                <i class="material-icons mr-1" style="font-size: 16px;">add</i>
                New Adjustment
            </button>
        </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Flash Messages -->
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <!-- Import Validation Errors -->
    <?php if(session('import_results') && !empty(session('import_results')['errors'])): ?>
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <h5 class="alert-heading"><i class="material-icons mr-2">warning</i>Import Validation Errors</h5>
            <p>The following rows have errors and were not imported:</p>
            <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                <table class="table table-sm table-bordered mb-0">
                    <thead>
                        <tr>
                            <th>Line</th>
                            <th>Item Code</th>
                            <th>Errors</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = session('import_results')['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($error['line']); ?></td>
                                <td><?php echo e($error['item_code'] ?? '-'); ?></td>
                                <td>
                                    <ul class="mb-0 pl-3">
                                        <?php $__currentLoopData = $error['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($err); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <hr>
            <p class="mb-0">
                <strong>Summary:</strong>
                Total rows: <?php echo e(session('import_results')['total_rows'] ?? 0); ?>,
                Valid: <?php echo e(session('import_results')['processed'] ?? 0); ?>,
                Errors: <?php echo e(count(session('import_results')['errors'])); ?>,
                Skipped (empty): <?php echo e(session('import_results')['skipped'] ?? 0); ?>

            </p>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Today\'s Adjustments','value' => $statistics['todays_adjustments'] ?? 0,'icon' => 'trending_up','color' => 'success','subtitle' => 'Adjustments made today']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Today\'s Adjustments','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['todays_adjustments'] ?? 0),'icon' => 'trending_up','color' => 'success','subtitle' => 'Adjustments made today']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'This Month','value' => $statistics['monthly_adjustments'] ?? 0,'icon' => 'history','color' => 'info','subtitle' => 'Total monthly adjustments']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'This Month','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['monthly_adjustments'] ?? 0),'icon' => 'history','color' => 'info','subtitle' => 'Total monthly adjustments']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Negative Adjustments','value' => $statistics['negative_adjustments'] ?? 0,'icon' => 'trending_down','color' => 'warning','subtitle' => 'Stock reductions this month']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Negative Adjustments','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['negative_adjustments'] ?? 0),'icon' => 'trending_down','color' => 'warning','subtitle' => 'Stock reductions this month']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Value Impact','value' => $statistics['value_impact'] ?? 0,'icon' => 'monetization_on','color' => 'primary','subtitle' => 'Total value affected','currency' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Value Impact','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['value_impact'] ?? 0),'icon' => 'monetization_on','color' => 'primary','subtitle' => 'Total value affected','currency' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0 d-flex align-items-center">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-xl-3 col-md-6 mb-3">
                    <label class="form-label">Date Range</label>
                    <div class="input-group">
                        <input type="date" class="form-control" id="filter-start-date" value="<?php echo e(date('Y-m-d', strtotime('-7 days'))); ?>">
                        <div class="input-group-append input-group-prepend">
                            <span class="input-group-text">to</span>
                        </div>
                        <input type="date" class="form-control" id="filter-end-date" value="<?php echo e(date('Y-m-d')); ?>">
                    </div>
                </div>

                <div class="col-xl-2 col-md-6 mb-3">
                    <label class="form-label">Adjustment Type</label>
                    <select id="filter-type" class="form-control">
                        <option value="">All Types</option>
                        <option value="increase">Increase</option>
                        <option value="decrease">Decrease</option>
                        <option value="set">Set Value</option>
                    </select>
                </div>

                <div class="col-xl-2 col-md-6 mb-3">
                    <label class="form-label">Division</label>
                    <select id="filter-division" class="form-control">
                        <option value="">All Divisions</option>
                        <?php $__currentLoopData = \App\Models\Warehouse\ProjectDivision::where('status', 'active')->orderBy('division_name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($division->id); ?>"><?php echo e($division->division_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-xl-2 col-md-6 mb-3">
                    <label class="form-label">Location</label>
                    <select id="filter-location" class="form-control">
                        <option value="">All Locations</option>
                        <option value="Warehouse-A">Warehouse-A</option>
                        <option value="Warehouse-B">Warehouse-B</option>
                        <option value="Warehouse-C">Warehouse-C</option>
                    </select>
                </div>

                <div class="col-xl-2 col-md-6 mb-3">
                    <label class="form-label">User</label>
                    <select id="filter-user" class="form-control">
                        <option value="">All Users</option>
                        <option value="Demo User">Demo User</option>
                        <option value="System">System</option>
                    </select>
                </div>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-3 pt-3 border-top">
                <button type="button" onclick="applyFilters()" class="btn btn-primary">
                    <i class="material-icons mr-1" style="font-size: 18px; vertical-align: middle;">filter_list</i>
                    Apply Filters
                </button>

                <button type="button" onclick="clearFilters()" class="btn btn-outline-secondary">
                    <i class="material-icons mr-1" style="font-size: 18px; vertical-align: middle;">clear</i>
                    Clear Filters
                </button>
            </div>
        </div>
    </div>

    <!-- Adjustments Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">list</i>
                Stock Adjustment History
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay" style="display: none;">
                    <div class="warehouse-loading-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading adjustments...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table id="adjustments-table" class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 130px;">Date & Time</th>
                                <th style="min-width: 200px;">Item</th>
                                <th style="min-width: 120px;">Division</th>
                                <th style="min-width: 90px;">Type</th>
                                <th style="min-width: 80px;">Old Qty</th>
                                <th style="min-width: 90px;">Adjustment</th>
                                <th style="min-width: 80px;">New Qty</th>
                                <th style="min-width: 150px;">Reason</th>
                                <th style="min-width: 100px;">User</th>
                                <th style="min-width: 100px;">Location</th>
                                <th style="min-width: 100px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be populated by DataTables -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- New Adjustment Modal -->
    <div class="modal fade" id="newAdjustmentModal" tabindex="-1" role="dialog" aria-labelledby="newAdjustmentModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newAdjustmentModalLabel">
                        <i class="material-icons mr-2">add_box</i>
                        Create Stock Adjustment
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="adjustmentForm">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <?php
                                    $divisionOptions = [['value' => '', 'text' => 'Select Division']];
                                    foreach(\App\Models\Warehouse\ProjectDivision::orderBy('division_name')->get() as $division) {
                                        $divisionOptions[] = ['value' => $division->id, 'text' => $division->division_name . ' (' . $division->division_code . ')'];
                                    }
                                ?>
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'division_id','id' => 'division_id','label' => 'Division','placeholder' => 'Select Division','options' => $divisionOptions,'required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'division_id','id' => 'division_id','label' => 'Division','placeholder' => 'Select Division','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($divisionOptions),'required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                            </div>
                            <div class="col-md-6">
                                <?php
                                    $modalItemOptions = [['value' => '', 'text' => 'Select Item']];
                                    foreach(\App\Models\Warehouse\Item::orderBy('item_description')->limit(10)->get() as $item) {
                                        $modalItemOptions[] = ['value' => $item->id, 'text' => $item->item_description . ' (' . $item->item_code . ')'];
                                    }
                                ?>
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'item_id','id' => 'item_id','label' => 'Item','placeholder' => 'Select Item','options' => $modalItemOptions,'required' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'item_id','id' => 'item_id','label' => 'Item','placeholder' => 'Select Item','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($modalItemOptions),'required' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                            </div>
                        </div>

                        <!-- Hidden field for location since there's only one warehouse -->
                        <input type="hidden" name="location" value="Main Warehouse">

                        <div class="row">
                            <div class="col-md-6">
                                <?php if (isset($component)) { $__componentOriginal6c49fce73979297b67c6317948ab8eae = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6c49fce73979297b67c6317948ab8eae = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.select2-dropdown','data' => ['name' => 'type','id' => 'type','label' => 'Adjustment Type','placeholder' => 'Select Type','options' => [
                                        ['value' => '', 'text' => 'Select Type'],
                                        ['value' => 'increase', 'text' => 'Increase Stock'],
                                        ['value' => 'decrease', 'text' => 'Decrease Stock'],
                                        ['value' => 'set', 'text' => 'Set Stock Level']
                                    ],'required' => 'true','onchange' => 'updateQuantityLabel(this.value)']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.select2-dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'type','id' => 'type','label' => 'Adjustment Type','placeholder' => 'Select Type','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
                                        ['value' => '', 'text' => 'Select Type'],
                                        ['value' => 'increase', 'text' => 'Increase Stock'],
                                        ['value' => 'decrease', 'text' => 'Decrease Stock'],
                                        ['value' => 'set', 'text' => 'Set Stock Level']
                                    ]),'required' => 'true','onchange' => 'updateQuantityLabel(this.value)']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $attributes = $__attributesOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__attributesOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6c49fce73979297b67c6317948ab8eae)): ?>
<?php $component = $__componentOriginal6c49fce73979297b67c6317948ab8eae; ?>
<?php unset($__componentOriginal6c49fce73979297b67c6317948ab8eae); ?>
<?php endif; ?>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="quantity">
                                        <span id="quantityLabel">Quantity</span>
                                        <span class="text-danger">*</span>
                                    </label>
                                    <input type="number" class="form-control" name="quantity" id="quantity" min="0" required>
                                    <small class="form-text text-muted" id="quantityHelp">Enter the adjustment amount</small>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="reason">Reason <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="reason" id="reason" rows="3" placeholder="Explain the reason for this adjustment..." required></textarea>
                            <div class="invalid-feedback"></div>
                        </div>

                        <div class="alert alert-info">
                            <i class="material-icons mr-2">info</i>
                            <strong>Note:</strong> Stock adjustments will create a movement record and update the inventory levels immediately.
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" onclick="saveAdjustment()" class="btn btn-primary">
                        <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                        Create Adjustment
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- View Details Modal -->
    <div class="modal fade" id="viewDetailsModal" tabindex="-1" role="dialog" aria-labelledby="viewDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewDetailsModalLabel">
                        <i class="material-icons mr-2">visibility</i>
                        Adjustment Details
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="adjustmentDetails">
                    <!-- Details will be loaded here -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modals'); ?>
<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1" role="dialog" aria-labelledby="importModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="importModalLabel">
                    <i class="material-icons mr-2">upload_file</i>
                    Import Stock / Opening Stock
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="importForm" method="POST" action="<?php echo e(route('warehouse.inventory.adjustments.import')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label class="form-label">Division <span class="text-danger">*</span></label>
                        <select name="division_id" id="import_division_id" class="form-control" required>
                            <option value="">Select Division</option>
                            <?php $__currentLoopData = \App\Models\Warehouse\ProjectDivision::orderBy('division_name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($division->id); ?>"><?php echo e($division->division_name); ?> (<?php echo e($division->division_code); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <small class="form-text text-muted">All entries in the file will be assigned to this division</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Select Excel File <span class="text-danger">*</span></label>
                        <input type="file" name="file" class="form-control" accept=".xlsx,.xls,.csv" required>
                        <small class="form-text text-muted">Supported formats: Excel (.xlsx, .xls) and CSV (.csv)</small>
                    </div>
                    <div class="mb-3">
                        <a href="<?php echo e(route('warehouse.inventory.adjustments.template', 'excel')); ?>" class="btn btn-sm btn-outline-info">
                            <i class="material-icons mr-1" style="font-size: 16px;">download</i>
                            Download Template
                        </a>
                    </div>

                    <div class="alert alert-success mb-3">
                        <i class="material-icons mr-2">lightbulb</i>
                        <strong>Opening Stock:</strong> For opening stock import, only <strong>Item Code</strong> and <strong>Quantity</strong> columns are required. Leave "Adjustment Type" and "Reason" columns empty - they will default to "increase" and "Opening Stock".
                    </div>

                    <div class="alert alert-info">
                        <i class="material-icons mr-2">info</i>
                        <strong>Note:</strong> All entries in the file will be assigned to the selected division.
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="material-icons mr-1" style="font-size: 16px;">cancel</i>
                    Cancel
                </button>
                <button type="submit" form="importForm" class="btn btn-success">
                    <i class="material-icons mr-1" style="font-size: 16px;">upload</i>
                    Import
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap4.min.css">
    <style>
        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
            border-radius: 4px;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
        }

        .table-responsive {
            border-radius: 0.375rem;
        }

        .adjustment-type-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.25rem 0.75rem;
            font-size: 0.75rem;
            font-weight: 500;
            line-height: 1;
            border-radius: 0.375rem;
        }

        .adjustment-increase {
            color: #155724;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }

        .adjustment-decrease {
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }

        .adjustment-set {
            color: #004085;
            background-color: #cce7ff;
            border: 1px solid #b3d7ff;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        /* Responsive modal sizing */
        @media (min-width: 576px) {
            .modal-dialog {
                max-width: 500px !important;
            }
        }

        @media (min-width: 992px) {
            .modal-lg .modal-dialog,
            .modal-dialog.modal-lg {
                max-width: 800px !important;
            }
        }

        /* Ensure body doesn't scroll when modal is open */
        body.modal-open {
            overflow: hidden !important;
        }

        /* Select2 dropdown z-index in modals */
        .select2-dropdown {
            z-index: 1060 !important;
        }

        .select2-container--open .select2-dropdown {
            z-index: 1060 !important;
        }

        /* Ensure modal content doesn't interfere */
        .modal-content {
            overflow: visible !important;
        }

        .modal-body {
            overflow: visible !important;
        }

        /* UAE Dirham Symbol */
        .dirham-symbol-inline {
            position: relative;
        }

        .dirham-symbol-inline::before {
            content: '';
            display: inline-block;
            width: 16px;
            height: 16px;
            margin-right: 4px;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 1000 870' width='16' height='16' style='fill: currentColor;'%3E%3Cpath d='m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.7 0.6 19.7 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-size: contain;
            background-position: center;
            vertical-align: middle;
        }

        /* Modal overlay fixes - CONSOLIDATED */
        .modal-backdrop,
        .modal-backdrop.fade,
        .modal-backdrop.show {
            z-index: 1040 !important;
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            right: 0 !important;
            bottom: 0 !important;
            width: 100vw !important;
            height: 100vh !important;
            background-color: rgba(0, 0, 0, 0.5) !important;
        }

        .modal,
        .modal.fade,
        .modal.show,
        #newAdjustmentModal,
        #viewDetailsModal,
        #importModal {
            z-index: 1050 !important;
        }

        /* Ensure modal content is clickable */
        .modal-dialog {
            z-index: 1051 !important;
            position: relative !important;
        }

        .modal-content {
            position: relative;
            z-index: 1052 !important;
            pointer-events: auto;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap4.min.js"></script>

    <script>
        let adjustmentsTable;

        $(document).ready(function() {
            console.log('📄 Adjustments page: Document ready');
            console.log('✅ jQuery version:', $.fn.jquery);
            console.log('✅ Import modal exists:', $('#importModal').length > 0);
            console.log('✅ New Adjustment modal exists:', $('#newAdjustmentModal').length > 0);
            console.log('✅ View Details modal exists:', $('#viewDetailsModal').length > 0);

            // Override the warehouse-reports.js pagination handler for DataTables
            $(document).off('click', '.warehouse-pagination a, .pagination a');

            // Hide any leftover loading overlays
            $('#tableLoadingOverlay').hide();

            // Global fix: Monitor for any backdrop with empty z-index and fix it
            const backdropObserver = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.addedNodes.length) {
                        mutation.addedNodes.forEach(function(node) {
                            if (node.classList && node.classList.contains('modal-backdrop')) {
                                // Check if z-index is empty or missing
                                const style = node.getAttribute('style') || '';
                                if (style.includes('z-index:;') || style.includes('z-index: ;') || !style.includes('z-index')) {
                                    console.log('🔧 Fixing backdrop with empty z-index');
                                    node.style.cssText = 'position: fixed; top: 0; left: 0; z-index: 1040; width: 100vw; height: 100vh; background-color: rgba(0,0,0,0.5);';
                                }
                            }
                        });
                    }
                });
            });

            backdropObserver.observe(document.body, {
                childList: true,
                subtree: false
            });

            initializeDataTable();

            // Entries per page change handler
            $('#entries-per-page').change(function() {
                adjustmentsTable.page.len($(this).val()).draw();
            });

            // Prevent dropdown events from interfering with modals
            $(document).on('click', function(e) {
                // If a modal is open, prevent dropdown events from interfering
                if ($('.modal.show').length > 0) {
                    // Allow clicks inside modals
                    if ($(e.target).closest('.modal').length > 0) {
                        return;
                    }
                    // Prevent other dropdown/navigation events
                    e.stopPropagation();
                }
            });

            // Stop dropdown events when modal is shown
            $('.modal').on('shown.bs.modal', function() {
                try {
                    $(document).off('click.bs.dropdown.data-api');
                } catch(e) {
                    console.warn('Error disabling dropdown events:', e);
                }
            });

            // Restore dropdown events when modal is hidden
            $('.modal').on('hidden.bs.modal', function() {
                try {
                    // Use proper jQuery selector without causing guid errors
                    if (typeof $().dropdown === 'function') {
                        $('[data-toggle="dropdown"]').dropdown();
                    }
                } catch(e) {
                    console.warn('Error restoring dropdown events:', e);
                }
            });

            // Check for success message in URL parameters
            const urlParams = new URLSearchParams(window.location.search);
            const successMessage = urlParams.get('success');
            if (successMessage) {
                // Create and show success alert
                const alertHtml = `
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        ${decodeURIComponent(successMessage)}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                `;
                $('.container-fluid.page__container').prepend(alertHtml);

                // Clean up URL by removing the success parameter
                urlParams.delete('success');
                const newUrl = window.location.pathname + (urlParams.toString() ? '?' + urlParams.toString() : '');
                window.history.replaceState({}, document.title, newUrl);
            }
        });

        function initializeDataTable() {
            // Hide any existing loading overlay before initializing
            $('#tableLoadingOverlay').hide();

            adjustmentsTable = $('#adjustments-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("warehouse.inventory.adjustments")); ?>',
                    type: 'GET',
                    data: function(d) {
                        d.start_date = $('#filter-start-date').val();
                        d.end_date = $('#filter-end-date').val();
                        d.type = $('#filter-type').val();
                        d.division = $('#filter-division').val();
                        d.location = $('#filter-location').val();
                        d.user = $('#filter-user').val();
                        return d;
                    },
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    complete: function() {
                        // Hide loading overlay when data is loaded
                        $('#tableLoadingOverlay').hide();
                    },
                    error: function(xhr, error, code) {
                        console.error('DataTable Ajax Error:', error, code);
                        console.error('Response Status:', xhr.status);
                        console.error('Response Text:', xhr.responseText);
                        $('#tableLoadingOverlay').hide();
                        showAlert('Error loading adjustment data. Please refresh the page.', 'error');
                    }
                },
                columns: [
                    {
                        data: 'date',
                        name: 'date',
                        render: function(data) {
                            const date = new Date(data);
                            return `
                                <div>
                                    <div class="font-weight-medium">${date.toLocaleDateString()}</div>
                                    <small class="text-muted">${date.toLocaleTimeString()}</small>
                                </div>
                            `;
                        }
                    },
                    {
                        data: null,
                        name: 'item',
                        render: function(data) {
                            return `
                                <div class="d-flex align-items-center">
                                    <div class="mr-3">
                                        <div class="bg-info text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 40px; height: 40px;">
                                            <i class="material-icons" style="font-size: 20px;">inventory_2</i>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="font-weight-medium">${data.item_name}</div>
                                        <small class="text-muted">${data.item_code}</small>
                                    </div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'division',
                        name: 'division',
                        render: function(data) {
                            if (!data) {
                                return '<span class="text-muted">No Division</span>';
                            }
                            return `
                                <div>
                                    <i class="material-icons text-muted mr-1" style="font-size: 14px; vertical-align: middle;">business</i>
                                    <span>${data}</span>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'type',
                        name: 'type',
                        render: function(data) {
                            const typeClasses = {
                                'Increase': 'adjustment-increase',
                                'Decrease': 'adjustment-decrease',
                                'Set': 'adjustment-set'
                            };
                            return `<span class="adjustment-type-badge ${typeClasses[data] || 'adjustment-set'}">${data}</span>`;
                        }
                    },
                    {
                        data: 'old_quantity',
                        name: 'old_quantity',
                        className: 'text-right font-weight-medium'
                    },
                    {
                        data: 'adjustment',
                        name: 'adjustment',
                        className: 'text-right font-weight-bold',
                        render: function(data) {
                            // Ensure data is a string
                            const adjustmentStr = String(data || '0');

                            if (adjustmentStr.startsWith('+')) {
                                return `<span class="text-success">${adjustmentStr}</span>`;
                            } else if (adjustmentStr.startsWith('-')) {
                                return `<span class="text-danger">${adjustmentStr}</span>`;
                            } else {
                                return `<span class="text-primary">→ ${adjustmentStr}</span>`;
                            }
                        }
                    },
                    {
                        data: 'new_quantity',
                        name: 'new_quantity',
                        className: 'text-right font-weight-medium'
                    },
                    {
                        data: 'reason',
                        name: 'reason',
                        render: function(data) {
                            // Ensure data is a string
                            const reasonStr = String(data || '');
                            return reasonStr.length > 30 ?
                                `<span title="${reasonStr}">${reasonStr.substring(0, 30)}...</span>` :
                                reasonStr;
                        }
                    },
                    {
                        data: 'user',
                        name: 'user',
                        render: function(data) {
                            return `
                                <div>
                                    <i class="material-icons text-muted mr-1" style="font-size: 14px; vertical-align: middle;">person</i>
                                    <span>${data}</span>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'location',
                        name: 'location',
                        render: function(data) {
                            return `
                                <div>
                                    <i class="material-icons text-muted mr-1" style="font-size: 14px; vertical-align: middle;">location_on</i>
                                    <span>${data}</span>
                                </div>
                            `;
                        }
                    },
                    {
                        data: null,
                        name: 'actions',
                        orderable: false,
                        searchable: false,
                        render: function(data) {
                            let actions = `
                                <div class="d-flex align-items-center" style="white-space: nowrap;">
                                    <button onclick="viewDetails(${data.id})" class="btn btn-sm btn-info mr-1" title="View Details">
                                        <i class="material-icons mr-1" style="font-size: 14px;">visibility</i>
                                        View
                                    </button>`;

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.adjust')): ?>
                            actions += `
                                    <button onclick="deleteAdjustment(${data.id})" class="btn btn-sm btn-danger" title="Delete">
                                        <i class="material-icons" style="font-size: 14px;">delete</i>
                                    </button>`;
                            <?php endif; ?>

                            actions += `</div>`;
                            return actions;
                        }
                    }
                ],
                order: [[0, 'desc']],
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
                language: {
                    processing: '<div class="text-center"><div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div></div>',
                    emptyTable: 'No stock adjustments found',
                    zeroRecords: 'No matching adjustments found'
                },
                drawCallback: function(settings) {
                    $('#entries-per-page').val(settings._iDisplayLength);
                }
            });
        }

        function applyFilters() {
            adjustmentsTable.draw();
        }

        function clearFilters() {
            $('#filter-start-date, #filter-end-date, #filter-type, #filter-division, #filter-location, #filter-user').val('');
            adjustmentsTable.draw();
        }

        function showNewAdjustmentModal() {
            // Stop any propagating events that might interfere
            if (event) {
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
            }

            // Clear form and validation errors
            $('#adjustmentForm')[0].reset();
            clearValidationErrors();

            // Force very high z-index before showing
            $('#newAdjustmentModal').css({
                'z-index': 999999,
                'position': 'fixed',
                'display': 'block'
            });

            // Show modal
            $('#newAdjustmentModal').modal({
                backdrop: true,
                keyboard: true,
                show: true
            });

            // Fix accessibility and aggressively force z-index after modal is shown
            $('#newAdjustmentModal').on('shown.bs.modal', function() {
                // Fix aria-hidden accessibility issue aggressively
                const $modal = $(this);
                $modal.removeAttr('aria-hidden');
                $modal.attr('aria-modal', 'true');

                // Monitor and prevent aria-hidden from being set again
                const observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === 'attributes' && mutation.attributeName === 'aria-hidden') {
                            if ($modal.attr('aria-hidden') === 'true') {
                                $modal.removeAttr('aria-hidden');
                                $modal.attr('aria-modal', 'true');
                                console.log('🔧 Fixed aria-hidden violation on adjustment modal');
                            }
                        }
                    });
                });

                observer.observe($modal[0], {
                    attributes: true,
                    attributeFilter: ['aria-hidden']
                });

                // Store observer for cleanup
                $modal.data('aria-observer', observer);
                $(this).css({
                    'z-index': 999999,
                    'position': 'fixed'
                });
                $('.modal-backdrop').css({
                    'z-index': 999998,
                    'position': 'fixed'
                });
                $('.modal-dialog').css({
                    'z-index': 1000000,
                    'position': 'relative',
                    'width': '100%',
                    'max-width': '95%'
                });
                $('.modal-content').css({
                    'z-index': 1000001,
                    'position': 'relative',
                    'width': '100%'
                });

                // Load items dropdown dynamically
                loadItemsDropdown();

                // Initialize Select2 dropdowns with proper dropdownParent
                $('#division_id, #item_id, #type').each(function() {
                    const $select = $(this);
                    const currentValue = $select.val();

                    // Destroy any existing Select2
                    if ($select.data('select2')) {
                        $select.select2('destroy');
                    }

                    // Initialize with modal-specific settings
                    $select.select2({
                        placeholder: $select.find('option:first').text() || 'Please select...',
                        allowClear: true,
                        theme: 'default',
                        width: '100%',
                        dropdownParent: $('body'), // Attach to body for better positioning
                        dropdownCssClass: 'modal-select2-dropdown',
                        containerCssClass: 'modal-select2-container'
                    });

                    // Restore value
                    $select.val(currentValue).trigger('change');

                    // Keep dropdown visible in modal with enhanced positioning
                    $select.on('select2:open', function() {
                        setTimeout(function() {
                            // Force maximum z-index values for all Select2 elements
                            $('.select2-dropdown').css('z-index', 9999999999);
                            $('.select2-container--default .select2-dropdown').css('z-index', 9999999999);
                            $('.modal-select2-dropdown').css('z-index', 9999999999);
                            $('.select2-results').css('z-index', 9999999999);
                            $('.select2-results__options').css('z-index', 9999999999);

                            // Additional positioning for dropdown container
                            $('.select2-container--open .select2-dropdown').css({
                                'z-index': '9999999999',
                                'position': 'fixed',
                                'display': 'block !important'
                            });

                            console.log('✅ Enhanced z-index and positioning applied to Select2 dropdown elements');
                        }, 10);
                    });

                    // Add change event for type dropdown to update quantity label
                    if ($select.attr('id') === 'type') {
                        $select.on('change', function() {
                            updateQuantityLabel($(this).val());
                        });
                    }
                });

                // Move modal to body if it's not already there
                if (!$('#newAdjustmentModal').parent().is('body')) {
                    $('#newAdjustmentModal').appendTo('body');
                }
            });

            // Cleanup observer when modal is hidden
            $('#newAdjustmentModal').on('hidden.bs.modal', function() {
                const observer = $(this).data('aria-observer');
                if (observer) {
                    observer.disconnect();
                    $(this).removeData('aria-observer');
                }
            });
        }

        function loadItemsDropdown() {
            $.ajax({
                url: '<?php echo e(route("warehouse.items.dropdown")); ?>',
                type: 'GET',
                success: function(response) {
                    if (response.success && response.data) {
                        const dropdown = $('#item_id');

                        // Destroy Select2 if it exists
                        if (dropdown.hasClass('select2-hidden-accessible')) {
                            dropdown.select2('destroy');
                        }

                        dropdown.empty();
                        dropdown.append('<option value="">Select Item</option>');

                        response.data.forEach(function(item) {
                            dropdown.append(`<option value="${item.id}" data-code="${item.item_code}">${item.item_description} (${item.item_code})</option>`);
                        });

                        // Reinitialize Select2 with proper positioning
                        if ($('#newAdjustmentModal').hasClass('show')) {
                            dropdown.select2({
                                placeholder: 'Select Item',
                                allowClear: true,
                                theme: 'default',
                                width: '100%',
                                dropdownParent: $('body'), // Attach to body instead of modal
                                dropdownCssClass: 'modal-select2-dropdown',
                                containerCssClass: 'modal-select2-container',
                                dropdownAutoWidth: false
                            });

                            // Force high z-index for dropdown elements
                            setTimeout(function() {
                                $('.modal-select2-dropdown').css('z-index', 9999999999);
                                $('.select2-container--default .select2-dropdown').css('z-index', 9999999999);
                                $('.select2-dropdown').css('z-index', 9999999999);
                            }, 100);
                        }

                        console.log('✅ Items loaded successfully');
                    }
                },
                error: function(xhr) {
                    console.error('Failed to load items:', xhr);
                    // Fallback to existing static items if API fails
                    const dropdown = $('#item_id');
                    if (dropdown.find('option').length <= 1) {
                        // Add some sample items as fallback
                        <?php $__currentLoopData = \App\Models\Warehouse\Item::orderBy('item_description')->limit(10)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            dropdown.append(`<option value="<?php echo e($item->id); ?>"><?php echo e($item->item_description); ?> (<?php echo e($item->item_code); ?>)</option>`);
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    }
                }
            });
        }

        function saveAdjustment() {
            const form = $('#adjustmentForm')[0];
            const formData = new FormData(form);

            // Clear previous validation errors
            clearValidationErrors();

            // Disable save button and show loading
            const saveBtn = $('button[onclick="saveAdjustment()"]');
            const originalHtml = saveBtn.html();
            saveBtn.prop('disabled', true);
            saveBtn.html('<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Saving...');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: '<?php echo e(route("warehouse.inventory.store-adjustment")); ?>',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        $('#newAdjustmentModal').modal('hide');
                        adjustmentsTable.draw();
                        showAlert('Stock adjustment created successfully!', 'success');

                        // Reset form
                        $('#adjustmentForm')[0].reset();
                        clearValidationErrors();
                    } else {
                        showAlert(response.message || 'Error creating adjustment', 'error');
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Validation errors
                        const errors = xhr.responseJSON.errors;
                        displayValidationErrors(errors);
                    } else {
                        const message = xhr.responseJSON?.message || 'Error creating adjustment. Please try again.';
                        showAlert(message, 'error');
                    }
                },
                complete: function() {
                    // Re-enable save button
                    saveBtn.prop('disabled', false);
                    saveBtn.html(originalHtml);
                }
            });
        }

        function updateQuantityLabel(type) {
            const label = document.getElementById('quantityLabel');
            const help = document.getElementById('quantityHelp');

            switch(type) {
                case 'increase':
                    label.textContent = 'Increase Amount';
                    help.textContent = 'Enter the amount to add to current stock';
                    break;
                case 'decrease':
                    label.textContent = 'Decrease Amount';
                    help.textContent = 'Enter the amount to subtract from current stock';
                    break;
                case 'set':
                    label.textContent = 'New Stock Level';
                    help.textContent = 'Enter the new stock level to set';
                    break;
                default:
                    label.textContent = 'Quantity';
                    help.textContent = 'Enter the adjustment amount';
            }
        }

        function viewDetails(adjustmentId) {
            // Stop any propagating events that might interfere
            if (event) {
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
            }

            // Force very high z-index before showing
            $('#viewDetailsModal').css({
                'z-index': 999999,
                'position': 'fixed',
                'display': 'block'
            });

            // Load adjustment details via AJAX
            const detailsUrl = `<?php echo e(url('warehouse/inventory/adjustments')); ?>/${adjustmentId}/details`;
            console.log('🔍 Fetching adjustment details from:', detailsUrl);

            $.ajax({
                url: detailsUrl,
                type: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        const data = response.data;
                        const detailsHtml = `
                            <div class="row mb-3">
                                <div class="col-sm-4 font-weight-medium">Adjustment ID:</div>
                                <div class="col-sm-8">#ADJ-${adjustmentId.toString().padStart(5, '0')}</div>
                            </div>
                            <hr>
                            <div class="row mb-3">
                                <div class="col-sm-4 font-weight-medium">Item:</div>
                                <div class="col-sm-8">${data.item_name} (${data.item_code})</div>
                            </div>
                            <hr>
                            <div class="row mb-3">
                                <div class="col-sm-4 font-weight-medium">Previous Stock:</div>
                                <div class="col-sm-8">${data.quantity_before} units</div>
                            </div>
                            <hr>
                            <div class="row mb-3">
                                <div class="col-sm-4 font-weight-medium">Adjustment:</div>
                                <div class="col-sm-8 ${data.adjustment_amount >= 0 ? 'text-success' : 'text-danger'}">${data.adjustment_display}</div>
                            </div>
                            <hr>
                            <div class="row mb-3">
                                <div class="col-sm-4 font-weight-medium">New Stock:</div>
                                <div class="col-sm-8">${data.quantity_after} units</div>
                            </div>
                            <hr>
                            <div class="row mb-3">
                                <div class="col-sm-4 font-weight-medium">Date & Time:</div>
                                <div class="col-sm-8">${data.created_at}</div>
                            </div>
                            <hr>
                            <div class="row mb-3">
                                <div class="col-sm-4 font-weight-medium">User:</div>
                                <div class="col-sm-8">${data.user_name}</div>
                            </div>
                            <hr>
                            <div class="row mb-3">
                                <div class="col-sm-4 font-weight-medium">Reason:</div>
                                <div class="col-sm-8">${data.reason}</div>
                            </div>
                        `;

                        document.getElementById('adjustmentDetails').innerHTML = detailsHtml;
                    } else {
                        document.getElementById('adjustmentDetails').innerHTML = '<div class="alert alert-danger">Failed to load adjustment details.</div>';
                    }
                },
                error: function(xhr) {
                    console.error('❌ Failed to load adjustment details:', {
                        status: xhr.status,
                        statusText: xhr.statusText,
                        response: xhr.responseText,
                        url: detailsUrl
                    });

                    let errorMessage = 'Error loading adjustment details. Please try again.';
                    if (xhr.status === 404) {
                        errorMessage = 'Adjustment record not found.';
                    } else if (xhr.status === 403) {
                        errorMessage = 'You do not have permission to view this adjustment.';
                    } else if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }

                    document.getElementById('adjustmentDetails').innerHTML = `<div class="alert alert-danger">${errorMessage}</div>`;
                }
            });

            // Show modal
            $('#viewDetailsModal').modal({
                backdrop: true,
                keyboard: true,
                show: true
            });

            // Fix accessibility and aggressively force z-index after modal is shown
            $('#viewDetailsModal').on('shown.bs.modal', function() {
                // Fix aria-hidden accessibility issue aggressively
                const $modal = $(this);
                $modal.removeAttr('aria-hidden');
                $modal.attr('aria-modal', 'true');

                // Monitor and prevent aria-hidden from being set again
                const observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === 'attributes' && mutation.attributeName === 'aria-hidden') {
                            if ($modal.attr('aria-hidden') === 'true') {
                                $modal.removeAttr('aria-hidden');
                                $modal.attr('aria-modal', 'true');
                                console.log('🔧 Fixed aria-hidden violation on view details modal');
                            }
                        }
                    });
                });

                observer.observe($modal[0], {
                    attributes: true,
                    attributeFilter: ['aria-hidden']
                });

                // Store observer for cleanup
                $modal.data('aria-observer', observer);
                $(this).css({
                    'z-index': 999999,
                    'position': 'fixed'
                });
                $('.modal-backdrop').css({
                    'z-index': 999998,
                    'position': 'fixed'
                });
                $('.modal-dialog').css({
                    'z-index': 1000000,
                    'position': 'relative',
                    'width': '100%',
                    'max-width': '95%'
                });
                $('.modal-content').css({
                    'z-index': 1000001,
                    'position': 'relative',
                    'width': '100%'
                });

                // Move modal to body if it's not already there
                if (!$('#viewDetailsModal').parent().is('body')) {
                    $('#viewDetailsModal').appendTo('body');
                }
            });

            // Cleanup observer when modal is hidden
            $('#viewDetailsModal').on('hidden.bs.modal', function() {
                const observer = $(this).data('aria-observer');
                if (observer) {
                    observer.disconnect();
                    $(this).removeData('aria-observer');
                }
            });
        }

        function deleteAdjustment(adjustmentId) {
            if (confirm('Are you sure you want to delete this adjustment record? This action cannot be undone.')) {
                // Simulate deletion
                showAlert('Adjustment deleted successfully!', 'success');
                adjustmentsTable.draw();
            }
        }

        function exportAdjustments() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Exporting...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                showAlert('Export functionality is not yet implemented', 'info');
            }, 800);
        }

        function showImportModal() {
            // Stop any propagating events that might interfere
            if (event) {
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
            }

            console.log('🔧 Attempting to show Import modal...');

            // Check if jQuery is available
            if (typeof $ === 'undefined') {
                console.error('❌ jQuery is not loaded!');
                alert('Error: jQuery is not available. Please refresh the page.');
                return;
            }

            // Check if modal exists
            const $modal = $('#importModal');
            if ($modal.length === 0) {
                console.error('❌ Modal #importModal not found in DOM!');
                alert('Error: Import modal not found. Please refresh the page.');
                return;
            }

            // Reset the form
            $('#importForm')[0].reset();

            // CRITICAL: Remove ALL existing backdrops first
            $('.modal-backdrop').remove();
            $('body').removeClass('modal-open').css('padding-right', '');

            // Hide any other open modals first
            $('.modal.show').modal('hide');

            // Use a slight delay to ensure cleanup is complete
            setTimeout(function() {
                // Show modal using Bootstrap's native method
                $modal.modal('show');
            }, 50);
        }

        // Handle import modal shown event - set up once on document ready
        $(document).on('shown.bs.modal', '#importModal', function() {
            console.log('✅ Import modal shown');

            // Fix aria-hidden accessibility issue
            const $modal = $(this);
            $modal.removeAttr('aria-hidden');
            $modal.attr('aria-modal', 'true');

            // CRITICAL: Force proper z-index on backdrop
            // Find any backdrop that was created and ensure it has proper z-index
            setTimeout(function() {
                const $backdrop = $('.modal-backdrop');
                if ($backdrop.length) {
                    // Remove any empty inline styles and set proper z-index
                    $backdrop.attr('style', 'position: fixed; top: 0; left: 0; z-index: 1040; width: 100vw; height: 100vh; background-color: rgba(0,0,0,0.5);');
                    console.log('✅ Backdrop z-index fixed');
                }

                // Ensure modal is above backdrop
                $modal.css('z-index', '1050');
                $modal.find('.modal-dialog').css('z-index', '1051');
                $modal.find('.modal-content').css('z-index', '1052');
            }, 10);

            // Initialize Select2 for import modal division dropdown
            if ($('#import_division_id').length && !$('#import_division_id').hasClass('select2-hidden-accessible')) {
                $('#import_division_id').select2({
                    placeholder: 'Select Division',
                    allowClear: true,
                    theme: 'default',
                    width: '100%',
                    dropdownParent: $modal.find('.modal-content')
                });
            }
        });

        // Handle import modal hidden event
        $(document).on('hidden.bs.modal', '#importModal', function() {
            console.log('✅ Import modal hidden');
            // Clean up backdrop completely
            $('.modal-backdrop').remove();
            $('body').removeClass('modal-open').css('padding-right', '');
        });

        function clearValidationErrors() {
            $('.form-control').removeClass('is-invalid');
            $('.invalid-feedback').text('');
        }

        function displayValidationErrors(errors) {
            $.each(errors, function(field, messages) {
                const input = $(`[name="${field}"]`);
                input.addClass('is-invalid');
                input.siblings('.invalid-feedback').text(messages[0]);
            });
        }

        function showAlert(message, type) {
            // Remove any existing alerts first
            $('.warehouse-alert').remove();

            const alertClass = type === 'success' ? 'alert-success' : (type === 'info' ? 'alert-info' : 'alert-danger');
            const icon = type === 'success' ? 'check_circle' : (type === 'info' ? 'info' : 'error');
            const iconColor = type === 'success' ? '#28a745' : (type === 'info' ? '#17a2b8' : '#dc3545');

            const alert = `
                <div class="alert ${alertClass} alert-dismissible fade show warehouse-alert"
                     style="position: fixed; top: 20px; right: 20px; z-index: 999999;
                            min-width: 300px; max-width: 500px; border-radius: 8px;
                            box-shadow: 0 4px 12px rgba(0,0,0,0.15); border: none;">
                    <div class="d-flex align-items-center">
                        <i class="material-icons mr-2" style="color: ${iconColor}; font-size: 24px;">${icon}</i>
                        <div class="flex-grow-1">
                            <strong style="font-size: 14px;">${message}</strong>
                        </div>
                        <button type="button" class="close ml-2" data-dismiss="alert" aria-label="Close"
                                style="font-size: 18px; opacity: 0.7;">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
            `;

            $('body').append(alert);

            // Auto-hide after 4 seconds with smooth animation
            setTimeout(() => {
                $('.warehouse-alert').fadeOut(300, function() {
                    $(this).remove();
                });
            }, 4000);
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/warehouse/inventory/adjustments.blade.php ENDPATH**/ ?>