<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'name',
    'id' => $name,
    'label' => '',
    'required' => false,
    'placeholder' => 'Please select...',
    'options' => [],
    'selected' => null,
    'allowClear' => true,
    'multiple' => false,
    'disabled' => false,
    'help' => '',
    'errorField' => $name,
    'class' => '',
    'data' => [],
    'ajax' => null,
    'theme' => 'default'
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'name',
    'id' => $name,
    'label' => '',
    'required' => false,
    'placeholder' => 'Please select...',
    'options' => [],
    'selected' => null,
    'allowClear' => true,
    'multiple' => false,
    'disabled' => false,
    'help' => '',
    'errorField' => $name,
    'class' => '',
    'data' => [],
    'ajax' => null,
    'theme' => 'default'
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="form-group">
    <?php if($label): ?>
        <label for="<?php echo e($id); ?>" class="form-label">
            <?php echo e($label); ?>

            <?php if($required): ?>
                <span class="text-danger">*</span>
            <?php endif; ?>
        </label>
    <?php endif; ?>

    <select
        name="<?php echo e($name); ?>"
        id="<?php echo e($id); ?>"
        class="form-control select2-dropdown <?php echo e($class); ?> <?php $__errorArgs = [$errorField];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
        <?php if($required): ?> required <?php endif; ?>
        <?php if($disabled): ?> disabled <?php endif; ?>
        <?php if($multiple): ?> multiple <?php endif; ?>
        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($key === 'onchange'): ?>
                onchange="<?php echo e($value); ?>"
            <?php else: ?>
                data-<?php echo e($key); ?>="<?php echo e($value); ?>"
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    >
        <?php if(!$multiple && !$ajax): ?>
            <option value=""><?php echo e($placeholder); ?></option>
        <?php endif; ?>

        <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(is_array($option)): ?>
                <option
                    value="<?php echo e($option['value']); ?>"
                    <?php echo e((string) $selected === (string) $option['value'] ? 'selected' : ''); ?>

                    <?php if(isset($option['data'])): ?>
                        <?php $__currentLoopData = $option['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dataKey => $dataValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            data-<?php echo e($dataKey); ?>="<?php echo e($dataValue); ?>"
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                >
                    <?php echo e($option['text']); ?>

                </option>
            <?php else: ?>
                <option
                    value="<?php echo e($option->id); ?>"
                    <?php echo e((string) $selected === (string) $option->id ? 'selected' : ''); ?>

                >
                    <?php echo e($option->name ?? $option->text ?? $option); ?>

                </option>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

    <?php $__errorArgs = [$errorField];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <div class="invalid-feedback"><?php echo e($message); ?></div>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

    <?php if($help): ?>
        <small class="form-text text-muted"><?php echo e($help); ?></small>
    <?php endif; ?>
</div>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css">
    <style>
        .select2-container {
            width: 100% !important;
        }

        .select2-container .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container .select2-selection--multiple {
            min-height: 38px;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
            padding-left: 12px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 36px;
        }

        .select2-dropdown {
            border-radius: 0.375rem;
            border: 1px solid #ced4da;
        }

        .select2-search__field {
            border: 1px solid #ced4da !important;
            border-radius: 0.375rem;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: #007bff;
        }

        .select2-container--default .select2-results__option[aria-selected=true] {
            background-color: #e7f3ff;
            color: #495057;
        }

        /* Error state */
        .select2-container--default .select2-selection--single.is-invalid,
        .select2-container--default .select2-selection--multiple.is-invalid,
        .select2-container .select2-selection.is-invalid {
            border-color: #dc3545 !important;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important;
        }

        /* Disabled state */
        .select2-container--default .select2-selection--single[disabled],
        .select2-container--default .select2-selection--multiple[disabled] {
            background-color: #e9ecef;
            border-color: #ced4da;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for this specific dropdown
            $('#<?php echo e($id); ?>').select2({
                placeholder: '<?php echo e($placeholder); ?>',
                allowClear: <?php echo e($allowClear ? 'true' : 'false'); ?>,
                theme: '<?php echo e($theme); ?>',
                width: '100%',
                dropdownAutoWidth: true,
                <?php if($ajax): ?>
                ajax: <?php echo json_encode($ajax); ?>,
                <?php endif; ?>
                language: {
                    noResults: function() {
                        return 'No results found';
                    },
                    searching: function() {
                        return 'Searching...';
                    }
                }
            });

            <?php if($multiple): ?>
            // Handle multiple selection changes
            $('#<?php echo e($id); ?>').on('select2:select select2:unselect', function (e) {
                $(this).trigger('change');
            });
            <?php endif; ?>

            // Prevent Select2 events from interfering with Bootstrap dropdowns
            $('#<?php echo e($id); ?>').on('select2:open select2:close', function(e) {
                e.stopPropagation();
            });

            // Handle dropdown clicks to prevent Bootstrap dropdown interference
            $('#<?php echo e($id); ?>').next('.select2-container').on('click', function(e) {
                e.stopPropagation();
            });
        });
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /Applications/MAMP/htdocs/kcg-inventory/resources/views/components/warehouse/select2-dropdown.blade.php ENDPATH**/ ?>