<?php $__env->startSection('title', 'Warehouse Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2 text-gray-800">
                        <i class="material-icons align-middle mr-2">settings</i>
                        Warehouse Settings
                    </h1>
                    <p class="text-muted mb-0">Configure warehouse operations and preferences</p>
                </div>
                <div>
                    <a href="<?php echo e(route('warehouse.dashboard')); ?>" class="btn btn-secondary">
                        <i class="material-icons mr-1">dashboard</i>
                        Back to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Settings Tabs -->
    <div class="row">
        <div class="col-12">
            <!-- Tab Navigation -->
            <ul class="nav nav-tabs" id="settingsTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" id="general-tab" data-toggle="tab" href="#general" role="tab">
                        <i class="material-icons mr-1">tune</i>
                        General
                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="notifications-tab" data-toggle="tab" href="#notifications" role="tab">
                        <i class="material-icons mr-1">notifications</i>
                        Notifications
                    </a>
                </li>
                <li class="nav-item" role="presentation">
                    <a class="nav-link" id="workflows-tab" data-toggle="tab" href="#workflows" role="tab">
                        <i class="material-icons mr-1">account_tree</i>
                        Workflows
                    </a>
                </li>
            </ul>

            <!-- Tab Content -->
            <div class="tab-content" id="settingsTabContent">

                <!-- General Settings Tab -->
                <div class="tab-pane fade show active" id="general" role="tabpanel">
                    <div class="card border-0">
                        <div class="card-header bg-primary text-white">
                            <h6 class="m-0 font-weight-bold">
                                <i class="material-icons align-middle mr-1">tune</i>
                                General Settings
                            </h6>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('warehouse.settings.update-general')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="warehouse_name" class="form-label">Warehouse Name</label>
                                        <input type="text"
                                               class="form-control <?php $__errorArgs = ['warehouse_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               id="warehouse_name"
                                               name="warehouse_name"
                                               value="<?php echo e(old('warehouse_name', $settings['general']['warehouse_name'])); ?>"
                                               required>
                                        <?php $__errorArgs = ['warehouse_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="default_currency" class="form-label">Default Currency</label>
                                        <select class="form-control <?php $__errorArgs = ['default_currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="default_currency"
                                                name="default_currency"
                                                required>
                                            <option value="AED" <?php echo e($settings['general']['default_currency'] === 'AED' ? 'selected' : ''); ?>>د.إ - UAE Dirham</option>
                                            <option value="USD" <?php echo e($settings['general']['default_currency'] === 'USD' ? 'selected' : ''); ?>>USD - US Dollar</option>
                                            <option value="EUR" <?php echo e($settings['general']['default_currency'] === 'EUR' ? 'selected' : ''); ?>>EUR - Euro</option>
                                        </select>
                                        <?php $__errorArgs = ['default_currency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="timezone" class="form-label">Timezone</label>
                                        <select class="form-control <?php $__errorArgs = ['timezone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="timezone"
                                                name="timezone"
                                                required>
                                            <option value="Asia/Dubai" <?php echo e($settings['general']['timezone'] === 'Asia/Dubai' ? 'selected' : ''); ?>>Asia/Dubai (UTC+4)</option>
                                            <option value="UTC" <?php echo e($settings['general']['timezone'] === 'UTC' ? 'selected' : ''); ?>>UTC (UTC+0)</option>
                                            <option value="America/New_York" <?php echo e($settings['general']['timezone'] === 'America/New_York' ? 'selected' : ''); ?>>America/New_York (UTC-5)</option>
                                        </select>
                                        <?php $__errorArgs = ['timezone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label for="require_approval_threshold" class="form-label">Approval Threshold (د.إ)</label>
                                        <input type="number"
                                               class="form-control <?php $__errorArgs = ['require_approval_threshold'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               id="require_approval_threshold"
                                               name="require_approval_threshold"
                                               value="<?php echo e(old('require_approval_threshold', $settings['general']['require_approval_threshold'])); ?>"
                                               min="0"
                                               step="0.01"
                                               required>
                                        <?php $__errorArgs = ['require_approval_threshold'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="text-muted">Transactions above this amount require supervisor approval</small>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12 mb-3">
                                        <div class="form-check">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="auto_approve_returns"
                                                   name="auto_approve_returns"
                                                   value="1"
                                                   <?php echo e($settings['general']['auto_approve_returns'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="auto_approve_returns">
                                                Auto-approve return transactions under approval threshold
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="material-icons mr-1">save</i>
                                        Save General Settings
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Notifications Settings Tab -->
                <div class="tab-pane fade" id="notifications" role="tabpanel">
                    <div class="card border-0">
                        <div class="card-header bg-warning text-white">
                            <h6 class="m-0 font-weight-bold">
                                <i class="material-icons align-middle mr-1">notifications</i>
                                Notification Settings
                            </h6>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('warehouse.settings.update-notifications')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="text-primary mb-3">Alert Preferences</h6>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="low_stock_alert"
                                                   name="low_stock_alert"
                                                   value="1"
                                                   <?php echo e($settings['notifications']['low_stock_alert'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="low_stock_alert">
                                                <strong>Low Stock Alerts</strong><br>
                                                <small class="text-muted">Notify when inventory falls below minimum levels</small>
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="approval_required"
                                                   name="approval_required"
                                                   value="1"
                                                   <?php echo e($settings['notifications']['approval_required'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="approval_required">
                                                <strong>Approval Required</strong><br>
                                                <small class="text-muted">Notify managers when approval is needed</small>
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="daily_reports"
                                                   name="daily_reports"
                                                   value="1"
                                                   <?php echo e($settings['notifications']['daily_reports'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="daily_reports">
                                                <strong>Daily Reports</strong><br>
                                                <small class="text-muted">Send daily inventory summary reports</small>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h6 class="text-primary mb-3">Delivery Methods</h6>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="email_notifications"
                                                   name="email_notifications"
                                                   value="1"
                                                   <?php echo e($settings['notifications']['email_notifications'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="email_notifications">
                                                <strong>Email Notifications</strong><br>
                                                <small class="text-muted">Send notifications via email</small>
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="sms_notifications"
                                                   name="sms_notifications"
                                                   value="1"
                                                   <?php echo e($settings['notifications']['sms_notifications'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="sms_notifications">
                                                <strong>SMS Notifications</strong><br>
                                                <small class="text-muted">Send urgent notifications via SMS</small>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-warning">
                                        <i class="material-icons mr-1">save</i>
                                        Save Notification Settings
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Workflows Settings Tab -->
                <div class="tab-pane fade" id="workflows" role="tabpanel">
                    <div class="card border-0">
                        <div class="card-header bg-success text-white">
                            <h6 class="m-0 font-weight-bold">
                                <i class="material-icons align-middle mr-1">account_tree</i>
                                Workflow Settings
                            </h6>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('warehouse.settings.update-workflows')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="text-success mb-3">Automation</h6>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="auto_create_delivery_notes"
                                                   name="auto_create_delivery_notes"
                                                   value="1"
                                                   <?php echo e($settings['workflows']['auto_create_delivery_notes'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="auto_create_delivery_notes">
                                                <strong>Auto-create Delivery Notes</strong><br>
                                                <small class="text-muted">Automatically generate delivery notes for outgoing transactions</small>
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="auto_update_inventory"
                                                   name="auto_update_inventory"
                                                   value="1"
                                                   <?php echo e($settings['workflows']['auto_update_inventory'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="auto_update_inventory">
                                                <strong>Auto-update Inventory</strong><br>
                                                <small class="text-muted">Automatically update inventory levels on transaction completion</small>
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="enable_barcode_scanning"
                                                   name="enable_barcode_scanning"
                                                   value="1"
                                                   <?php echo e($settings['workflows']['enable_barcode_scanning'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="enable_barcode_scanning">
                                                <strong>Enable Barcode Scanning</strong><br>
                                                <small class="text-muted">Allow barcode scanning for faster item identification</small>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h6 class="text-success mb-3">Quality Control</h6>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="require_quality_inspection"
                                                   name="require_quality_inspection"
                                                   value="1"
                                                   <?php echo e($settings['workflows']['require_quality_inspection'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="require_quality_inspection">
                                                <strong>Require Quality Inspection</strong><br>
                                                <small class="text-muted">Mandate quality inspection for incoming materials</small>
                                            </label>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input"
                                                   type="checkbox"
                                                   id="require_supervisor_approval"
                                                   name="require_supervisor_approval"
                                                   value="1"
                                                   <?php echo e($settings['workflows']['require_supervisor_approval'] ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="require_supervisor_approval">
                                                <strong>Require Supervisor Approval</strong><br>
                                                <small class="text-muted">Require supervisor approval for high-value transactions</small>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-success">
                                        <i class="material-icons mr-1">save</i>
                                        Save Workflow Settings
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Information Card -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card border-left-info">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                <i class="material-icons align-middle mr-1">info</i>
                                Settings Information
                            </div>
                            <div class="text-gray-800">
                                <ul class="mb-0 pl-3">
                                    <li><strong>General Settings:</strong> Configure basic warehouse information and operational parameters</li>
                                    <li><strong>Notifications:</strong> Control how and when the system sends alerts and reports</li>
                                    <li><strong>Workflows:</strong> Customize automation and approval processes for your operations</li>
                                    <li><strong>Auto-save:</strong> Changes are saved immediately when you submit each form</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="material-icons fa-2x text-gray-300">settings_applications</i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Handle tab switching
        const tabs = document.querySelectorAll('#settingsTabs .nav-link');
        tabs.forEach(tab => {
            tab.addEventListener('shown.bs.tab', function() {
                // You can add any tab-specific logic here
            });
        });

        // Show success messages
        <?php if(session('success')): ?>
            alert('<?php echo e(session('success')); ?>');
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/settings/index.blade.php ENDPATH**/ ?>