<?php $__env->startSection('title', 'Warehouse Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>
<?php $__env->startSection('page-subtitle', 'Welcome to the Warehouse Management System'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">Dashboard</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-actions'); ?>
    <div class="btn-group">
        <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="material-icons mr-2">add</i>
            Quick Actions
        </button>
        <div class="dropdown-menu dropdown-menu-right">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.items.create')): ?>
            <a class="dropdown-item" href="<?php echo e(route('warehouse.items.create')); ?>">
                <i class="material-icons mr-2">inventory_2</i>
                Add New Item
            </a>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.incoming.create')): ?>
            <a class="dropdown-item" href="<?php echo e(route('warehouse.incoming-operations.create')); ?>">
                <i class="material-icons mr-2">input</i>
                New Incoming Operation
            </a>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.outgoing.create')): ?>
            <a class="dropdown-item" href="<?php echo e(route('warehouse.outgoing.create')); ?>">
                <i class="material-icons mr-2">output</i>
                New Outgoing Transaction
            </a>
            <?php endif; ?>
            <div class="dropdown-divider"></div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.inventory.adjust')): ?>
            <a class="dropdown-item" href="<?php echo e(route('warehouse.inventory.adjustments')); ?>">
                <i class="material-icons mr-2">tune</i>
                Adjust Inventory
            </a>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="warehouse-stat-card">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 mr-3">
                        <div class="rounded-circle d-flex align-items-center justify-content-center"
                             style="width: 48px; height: 48px; background-color: var(--warehouse-primary); color: white;">
                            <i class="material-icons">inventory_2</i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h3 class="mb-0"><?php echo e($stats['total_items'] ?? 0); ?></h3>
                        <p class="text-muted mb-0">Total Items</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="warehouse-stat-card">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 mr-3">
                        <div class="rounded-circle d-flex align-items-center justify-content-center"
                             style="width: 48px; height: 48px; background-color: var(--warehouse-warning); color: white;">
                            <i class="material-icons">warning</i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h3 class="mb-0 text-warning"><?php echo e($stats['low_stock_items'] ?? 0); ?></h3>
                        <p class="text-muted mb-0">Low Stock Items</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="warehouse-stat-card">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 mr-3">
                        <div class="rounded-circle d-flex align-items-center justify-content-center"
                             style="width: 48px; height: 48px; background-color: var(--warehouse-success); color: white;">
                            <i class="material-icons">place</i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h3 class="mb-0"><?php echo e($stats['total_locations'] ?? 0); ?></h3>
                        <p class="text-muted mb-0">Locations</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="warehouse-stat-card">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 mr-3">
                        <div class="rounded-circle d-flex align-items-center justify-content-center"
                             style="width: 48px; height: 48px; background-color: var(--warehouse-info); color: white;">
                            <i class="material-icons">pending</i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h3 class="mb-0 text-info"><?php echo e($stats['pending_transactions'] ?? 0); ?></h3>
                        <p class="text-muted mb-0">Pending Transactions</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Inventory Chart -->
    <div class="row mb-4">
        <div class="col-lg-8 mb-4">
            <div class="card warehouse-card">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">bar_chart</i>
                        Inventory Levels by Category
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="inventoryChart" height="300"></canvas>
                </div>
            </div>
        </div>
        <div class="col-lg-4 mb-4">
            <!-- Low Stock Alert -->
            <?php if($lowStockItems->count() > 0): ?>
                <div class="card warehouse-card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h6 class="mb-0 text-warning">
                            <i class="material-icons mr-2" style="vertical-align: middle;">warning</i>
                            Low Stock Alert
                        </h6>
                        <a href="<?php echo e(route('warehouse.inventory.low-stock')); ?>" class="btn btn-sm btn-outline-warning">
                            View All
                        </a>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $lowStockItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex align-items-center justify-content-between py-2 <?php echo e(!$loop->last ? 'border-bottom' : ''); ?>">
                                <div>
                                    <p class="mb-0 font-weight-semibold"><?php echo e($item['item_name']); ?></p>
                                    <small class="text-muted"><?php echo e($item['item_code']); ?></small>
                                </div>
                                <div class="text-right">
                                    <div class="small">
                                        <span class="text-danger"><?php echo e($item['current_stock']); ?></span> /
                                        <span class="text-muted"><?php echo e($item['reorder_point']); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="card warehouse-card">
                    <div class="card-body text-center">
                        <i class="material-icons text-success mb-2" style="font-size: 48px;">check_circle</i>
                        <h6 class="text-success">All Items Well Stocked</h6>
                        <p class="text-muted mb-0">No items are currently below reorder point</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="row">
        <!-- Recent Activities -->
        <div class="col-lg-8 mb-4">
            <div class="card warehouse-card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="mb-0">
                        <i class="material-icons mr-2" style="vertical-align: middle;">timeline</i>
                        Recent Activities
                    </h5>
                    <a href="<?php echo e(route('warehouse.activity-log.index')); ?>" class="btn btn-sm btn-outline-primary">
                        View All
                    </a>
                </div>
                <div class="card-body">
                    <?php if($recentActivities->count() > 0): ?>
                        <div class="list-group list-group-flush">
                            <?php $__currentLoopData = $recentActivities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item d-flex align-items-center px-0">
                                    <div class="flex-shrink-0 mr-3">
                                        <div class="rounded-circle d-flex align-items-center justify-content-center text-white"
                                             style="width: 32px; height: 32px; background-color: var(--warehouse-<?php echo e($activity['color'] ?? 'secondary'); ?>);">
                                            <i class="material-icons" style="font-size: 16px;"><?php echo e($activity['icon'] ?? 'info'); ?></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="mb-1"><?php echo e($activity['description']); ?></p>
                                        <small class="text-muted">
                                            by <?php echo e($activity['user']); ?> • <?php echo e($activity['created_at']->diffForHumans()); ?>

                                        </small>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="material-icons text-muted" style="font-size: 48px;">timeline</i>
                            <p class="text-muted mb-0">No recent activities</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Quick Links & Low Stock -->
        <div class="col-lg-4">
            <!-- Low Stock Alert -->
            <?php if($lowStockItems->count() > 0): ?>
                <div class="card warehouse-card mb-4">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h6 class="mb-0 text-warning">
                            <i class="material-icons mr-2" style="vertical-align: middle;">warning</i>
                            Low Stock Alert
                        </h6>
                        <a href="<?php echo e(route('warehouse.inventory.low-stock')); ?>" class="btn btn-sm btn-outline-warning">
                            View All
                        </a>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $lowStockItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex align-items-center justify-content-between py-2 <?php echo e(!$loop->last ? 'border-bottom' : ''); ?>">
                                <div>
                                    <p class="mb-0 font-weight-semibold"><?php echo e($item->item->name ?? 'Unknown Item'); ?></p>
                                    <small class="text-muted"><?php echo e($item->item->item_code ?? 'N/A'); ?></small>
                                </div>
                                <div class="text-right">
                                    <span class="badge badge-warning"><?php echo e($item->quantity_available ?? 0); ?></span>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Location Summary -->
            <?php if($locationSummary->count() > 0): ?>
                <div class="card warehouse-card">
                    <div class="card-header">
                        <h6 class="mb-0">
                            <i class="material-icons mr-2" style="vertical-align: middle;">place</i>
                            Inventory by Location
                        </h6>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $locationSummary->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex align-items-center justify-content-between py-2 <?php echo e(!$loop->last ? 'border-bottom' : ''); ?>">
                                <div>
                                    <p class="mb-0 font-weight-semibold"><?php echo e($location['name']); ?></p>
                                    <small class="text-muted"><?php echo e($location['total_items']); ?> items</small>
                                </div>
                                <div class="text-right">
                                    <div class="small">
                                        <span class="text-success"><?php echo e($location['available_quantity']); ?></span> /
                                        <span class="text-muted"><?php echo e($location['total_quantity']); ?></span>
                                    </div>
                                    <?php if($location['total_reserved'] > 0): ?>
                                        <div class="small">
                                            <span class="text-info"><?php echo e($location['total_reserved']); ?> reserved</span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if($recentMovements->count() > 0): ?>
    <!-- Recent Stock Movements -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card warehouse-card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h5 class="mb-0">
                        <i class="material-icons mr-2" style="vertical-align: middle;">swap_horiz</i>
                        Recent Stock Movements
                    </h5>
                    <a href="<?php echo e(route('warehouse.reports.stock-movements')); ?>" class="btn btn-sm btn-outline-primary">
                        View Report
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Item</th>
                                    <th>Type</th>
                                    <th>Quantity</th>
                                    <th>Reason</th>
                                    <th>User</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $recentMovements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div>
                                                <span class="font-weight-semibold"><?php echo e($movement->item->name ?? 'Unknown'); ?></span>
                                                <br>
                                                <small class="text-muted"><?php echo e($movement->item->item_code ?? 'N/A'); ?></small>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge badge-<?php echo e($movement->type === 'increase' ? 'success' : ($movement->type === 'decrease' ? 'danger' : 'info')); ?>">
                                                <?php echo e(ucfirst(str_replace('_', ' ', $movement->type))); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($movement->quantity); ?></td>
                                        <td><?php echo e($movement->reason ?: 'N/A'); ?></td>
                                        <td><?php echo e($movement->user->name ?? 'System'); ?></td>
                                        <td>
                                            <small><?php echo e($movement->created_at->format('M d, H:i')); ?></small>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <script>
        // Initialize Inventory Chart
        document.addEventListener('DOMContentLoaded', function() {
            const ctx = document.getElementById('inventoryChart').getContext('2d');
            
            const chartData = <?php echo json_encode($categoryChartData, 15, 512) ?>;
            
            new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: chartData.labels,
                    datasets: [{
                        data: chartData.data,
                        backgroundColor: [
                            '#007bff',
                            '#28a745', 
                            '#ffc107',
                            '#dc3545',
                            '#6f42c1',
                            '#fd7e14',
                            '#20c997',
                            '#6c757d',
                            '#17a2b8',
                            '#e83e8c'
                        ],
                        borderWidth: 2,
                        borderColor: '#fff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'right',
                            labels: {
                                usePointStyle: true,
                                padding: 15,
                                generateLabels: function(chart) {
                                    const data = chart.data;
                                    if (data.labels.length && data.datasets.length) {
                                        return data.labels.map((label, i) => {
                                            const value = data.datasets[0].data[i];
                                            const itemsCount = chartData.items_count[i];
                                            return {
                                                text: `${label} (${value} units, ${itemsCount} items)`,
                                                fillStyle: data.datasets[0].backgroundColor[i],
                                                strokeStyle: data.datasets[0].borderColor || '#fff',
                                                lineWidth: data.datasets[0].borderWidth || 0,
                                                pointStyle: 'circle',
                                                hidden: false
                                            };
                                        });
                                    }
                                    return [];
                                }
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const label = context.label || '';
                                    const value = context.parsed;
                                    const itemsCount = chartData.items_count[context.dataIndex];
                                    return `${label}: ${value} units (${itemsCount} items)`;
                                }
                            }
                        }
                    }
                }
            });
        });

        // Auto-refresh quick stats every 30 seconds
        setInterval(function() {
            fetch('<?php echo e(route('warehouse.api.quick-stats')); ?>')
                .then(response => response.json())
                .then(data => {
                    // Update stats in the page if needed
                    console.log('Stats updated:', data);
                })
                .catch(error => {
                    console.error('Error fetching quick stats:', error);
                });
        }, 30000);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.warehouse', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/dashboard/index.blade.php ENDPATH**/ ?>