<?php $__env->startSection('title', 'Inventory Report'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.index')); ?>">Reports</a></li>
    <li class="breadcrumb-item active">Inventory Report</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title-left">
        <h3 class="mb-1">Inventory Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Comprehensive inventory analysis with pricing insights</p>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Items','value' => $items->total(),'icon' => 'inventory','color' => 'primary','subtitle' => 'All inventory items']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Items','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($items->total()),'icon' => 'inventory','color' => 'primary','subtitle' => 'All inventory items']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Value','value' => 'AED ' . number_format($items->getCollection()->sum('total_value'), 2),'icon' => 'account_balance_wallet','color' => 'success','subtitle' => 'Total inventory value','showDirham' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Value','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('AED ' . number_format($items->getCollection()->sum('total_value'), 2)),'icon' => 'account_balance_wallet','color' => 'success','subtitle' => 'Total inventory value','showDirham' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Low Stock Items','value' => $items->getCollection()->where('overall_status', 'low_stock')->count(),'icon' => 'warning','color' => 'warning','subtitle' => 'Items below reorder point']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Low Stock Items','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($items->getCollection()->where('overall_status', 'low_stock')->count()),'icon' => 'warning','color' => 'warning','subtitle' => 'Items below reorder point']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Out of Stock','value' => $items->getCollection()->where('overall_status', 'out_of_stock')->count(),'icon' => 'error','color' => 'danger','subtitle' => 'Items completely out of stock']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Out of Stock','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($items->getCollection()->where('overall_status', 'out_of_stock')->count()),'icon' => 'error','color' => 'danger','subtitle' => 'Items completely out of stock']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4 warehouse-filters-panel">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form id="filterForm" class="warehouse-filter-form" method="GET" action="<?php echo e(route('warehouse.reports.inventory')); ?>">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="<?php echo e(request('search')); ?>" class="form-control" placeholder="Item code or description">
                    </div>

                    <div class="col-md-3 mb-3">
                        <label class="form-label">Category</label>
                        <select name="category_id" id="filter-category" class="form-control" data-placeholder="All Categories">
                            <option value="">All Categories</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->category_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Division</label>
                        <select name="division_id" id="filter-division" class="form-control" data-placeholder="All Divisions">
                            <option value="">All Divisions</option>
                            <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($division->id); ?>" <?php echo e(request('division_id') == $division->id ? 'selected' : ''); ?>>
                                    <?php echo e($division->division_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Stock Status</label>
                        <select name="status" id="filter-status" class="form-control" data-placeholder="All Statuses">
                            <option value="">All Statuses</option>
                            <?php $__currentLoopData = $stockStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($status); ?>" <?php echo e(request('status') == $status ? 'selected' : ''); ?>>
                                    <?php echo e(ucfirst(str_replace('_', ' ', $status))); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="material-icons" style="font-size: 18px; vertical-align: middle;">search</i>
                            Apply
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Inventory Report Table -->
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="material-icons align-middle mr-2">assessment</i>
                    Inventory Report (<?php echo e($items->total()); ?> total items)
                </h5>
                <button type="button" onclick="exportToExcel()" class="btn btn-success btn-sm">
                    <i class="material-icons mr-1" style="font-size: 16px; vertical-align: middle;">file_download</i>
                    Export to Excel
                </button>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay for Table -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay">
                    <div class="d-flex align-items-center justify-content-center" style="height: 400px;">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading data...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 150px;">Item Code</th>
                                <th style="min-width: 200px;">Description</th>
                                <th style="min-width: 120px;">Category</th>
                                <th style="min-width: 80px;">Unit</th>
                                <th style="min-width: 100px;" class="text-right">Quantity</th>
                                <th style="min-width: 140px; white-space: nowrap;" class="text-right">Avg Unit Price</th>
                                <th style="min-width: 150px;" class="text-right">Price Range</th>
                                <th style="min-width: 120px;" class="text-right">Total Value</th>
                                <th style="min-width: 100px;" class="text-center">Production</th>
                                <th style="min-width: 100px;" class="text-center">Expiry</th>
                                <th style="min-width: 150px;">Divisions</th>
                                <th style="min-width: 100px;" class="text-center">Status</th>
                                <th style="min-width: 80px;" class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody id="tableBody">
                            <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td style="white-space: nowrap;"><?php echo e($item->item_code); ?></td>
                                    <td><?php echo e(Str::limit($item->item_description, 50)); ?></td>
                                    <td>
                                        <span class="badge badge-secondary"><?php echo e($item->category); ?></span>
                                    </td>
                                    <td><?php echo e($item->unit_of_measure); ?></td>
                                    <td class="text-right">
                                        <strong><?php echo e(number_format($item->total_quantity, 2)); ?></strong>
                                    </td>
                                    <td class="text-right">
                                        AED <?php echo e(number_format($item->average_unit_price, 2)); ?>

                                    </td>
                                    <td class="text-right">
                                        <?php if($item->min_price > 0 && $item->max_price > 0): ?>
                                            <small>
                                                Min: AED <?php echo e(number_format($item->min_price, 2)); ?><br>
                                                Max: AED <?php echo e(number_format($item->max_price, 2)); ?>

                                            </small>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-right">
                                        <strong>AED <?php echo e(number_format($item->total_value, 2)); ?></strong>
                                    </td>
                                    <td class="text-center">
                                        <?php echo e($item->latest_production_date ? $item->latest_production_date->format('d M Y') : '-'); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php if($item->latest_expiry_date): ?>
                                            <?php
                                                $daysUntilExpiry = now()->diffInDays($item->latest_expiry_date, false);
                                            ?>
                                            <span class="<?php echo e($daysUntilExpiry < 0 ? 'text-danger' : ($daysUntilExpiry <= 30 ? 'text-warning' : '')); ?>">
                                                <?php echo e($item->latest_expiry_date->format('d M Y')); ?>

                                                <?php if($daysUntilExpiry < 0): ?>
                                                    <br><small class="text-danger">Expired</small>
                                                <?php elseif($daysUntilExpiry <= 30): ?>
                                                    <br><small class="text-warning"><?php echo e($daysUntilExpiry); ?> days</small>
                                                <?php endif; ?>
                                            </span>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(count($item->divisions) > 0): ?>
                                            <small><?php echo e(implode(', ', array_column($item->divisions->toArray(), 'name'))); ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge badge-<?php echo e($item->overall_status === 'in_stock' ? 'success' :
                                            ($item->overall_status === 'low_stock' ? 'warning' : 'danger')); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $item->overall_status))); ?>

                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <a href="<?php echo e(route('warehouse.reports.inventory.item-details', $item->id)); ?>" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="material-icons" style="font-size: 16px;">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="13" class="text-center py-4">
                                        <i class="material-icons text-muted" style="font-size: 48px;">inventory</i>
                                        <h5 class="text-muted mt-3">No Inventory Items Found</h5>
                                        <p class="text-muted">No items match your current filters.</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <?php if($items->hasPages()): ?>
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        Showing <?php echo e($items->firstItem()); ?> to <?php echo e($items->lastItem()); ?> of <?php echo e($items->total()); ?> items
                    </div>
                    <div>
                        <nav class="warehouse-pagination">
                            <?php echo e($items->links('pagination::bootstrap-4')); ?>

                        </nav>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
    <style>
        .select2-container--bootstrap-5 .select2-selection {
            min-height: 38px;
            border: 1px solid #ced4da;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
            line-height: 36px;
        }
        .select2-container--bootstrap-5 .select2-selection--single .select2-selection__arrow {
            height: 36px;
        }
        .select2-container {
            width: 100% !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            // Initialize Select2 for filter dropdowns
            $('#filter-category, #filter-division, #filter-status').select2({
                theme: 'bootstrap-5',
                allowClear: true,
                placeholder: function() {
                    return $(this).data('placeholder') || 'Select...';
                }
            });
        });

        function exportToExcel() {
            // Get current filter values
            const formData = new FormData(document.getElementById('filterForm'));
            const params = new URLSearchParams(formData);

            // Build export URL with current filters
            const exportUrl = '<?php echo e(route("warehouse.reports.inventory.export")); ?>?' + params.toString();

            // Create a temporary link and trigger download
            const link = document.createElement('a');
            link.href = exportUrl;
            link.download = 'inventory-report.xlsx';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);

            // Show feedback to user
            showNotification('Excel export started! Download will begin shortly.', 'success');
        }

        function showNotification(message, type = 'info') {
            // Create notification element
            const notification = document.createElement('div');
            notification.className = `alert alert-${type === 'success' ? 'success' : 'info'} alert-dismissible fade show position-fixed`;
            notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
            notification.innerHTML = `
                ${message}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            `;

            // Add to page
            document.body.appendChild(notification);

            // Auto-remove after 5 seconds
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.parentNode.removeChild(notification);
                }
            }, 5000);
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/reports/inventory.blade.php ENDPATH**/ ?>