<?php $__env->startSection('title', 'Supplier Delivery Operations'); ?>


<!-- Last updated: <?php echo e(now()); ?> -->

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Supplier Delivery</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Supplier Delivery Operations</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Manage incoming deliveries from suppliers</p>
        </div>
        <div class="page-actions-right d-flex align-items-center">
            <button type="button" onclick="exportDeliveries()" class="btn btn-sm btn-info mr-2" title="Export deliveries to Excel">
                <i class="material-icons mr-1" style="font-size: 16px;">file_download</i>
                Export
            </button>

            <a href="<?php echo e(route('warehouse.supplier-delivery.create')); ?>" class="btn btn-sm btn-primary" title="Add new supplier delivery">
                <i class="material-icons mr-1" style="font-size: 16px;">add</i>
                New Delivery
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Deliveries','value' => $statistics['total_deliveries'] ?? 0,'icon' => 'local_shipping','color' => 'primary','subtitle' => 'All supplier deliveries']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Deliveries','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['total_deliveries'] ?? 0),'icon' => 'local_shipping','color' => 'primary','subtitle' => 'All supplier deliveries']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Pending Delivery','value' => $statistics['pending_delivery'] ?? 0,'icon' => 'schedule','color' => 'warning','subtitle' => 'Awaiting delivery']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Pending Delivery','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['pending_delivery'] ?? 0),'icon' => 'schedule','color' => 'warning','subtitle' => 'Awaiting delivery']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Completed Today','value' => $statistics['completed_today'] ?? 0,'icon' => 'check_circle','color' => 'success','subtitle' => 'Delivered today']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Completed Today','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['completed_today'] ?? 0),'icon' => 'check_circle','color' => 'success','subtitle' => 'Delivered today']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Value','value' => $statistics['total_value_aed'] ?? 0,'icon' => 'account_balance','color' => 'info','subtitle' => 'Total delivery value','currency' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Value','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($statistics['total_value_aed'] ?? 0),'icon' => 'account_balance','color' => 'info','subtitle' => 'Total delivery value','currency' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4">
        <div class="card-header">
            <h6 class="card-title mb-0">
                <i class="material-icons mr-2">filter_list</i>
                Filters
            </h6>
        </div>
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-2">
                    <div style="font-size: 12px; margin-bottom: 8px;">
                        <label for="filter-status" class="form-label">Status</label>
                        <select name="filter-status" id="filter-status" class="form-control form-control-sm">
                            <option value="">All Statuses</option>
                            <option value="draft">Draft</option>
                            <option value="pending_delivery">Pending Delivery</option>
                            <option value="delivered">Delivered</option>
                            <option value="completed">Completed</option>
                            <option value="cancelled">Cancelled</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div style="font-size: 12px; margin-bottom: 8px;">
                        <label for="filter-supplier" class="form-label">Supplier</label>
                        <select name="filter-supplier" id="filter-supplier" class="form-control form-control-sm">
                            <option value="">All Suppliers</option>
                            <?php $__currentLoopData = $suppliers ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div style="font-size: 12px; margin-bottom: 8px;">
                        <label for="filter-division" class="form-label">Division</label>
                        <select name="filter-division" id="filter-division" class="form-control form-control-sm">
                            <option value="">All Divisions</option>
                            <?php $__currentLoopData = $divisions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($division->id); ?>"><?php echo e($division->division_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div style="font-size: 12px; margin-bottom: 8px;">
                        <label for="filter-lpo-status" class="form-label">LPO Status</label>
                        <select name="filter-lpo-status" id="filter-lpo-status" class="form-control form-control-sm">
                            <option value="">All LPO Status</option>
                            <option value="approved">Approved</option>
                            <option value="pending">Pending</option>
                            <option value="cancelled">Cancelled</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div style="font-size: 12px; margin-bottom: 8px;">
                        <label class="form-label">Date Range</label>
                        <div class="d-flex">
                            <input type="date" id="filter-date-from" class="form-control form-control-sm mr-1" style="font-size: 11px;">
                            <input type="date" id="filter-date-to" class="form-control form-control-sm" style="font-size: 11px;">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-3">
                <div class="col-md-12">
                    <button onclick="applyFilters()" class="btn btn-primary btn-sm mr-2">
                        <i class="material-icons mr-1" style="font-size: 16px;">search</i>
                        Apply
                    </button>
                    <button onclick="clearFilters()" class="btn btn-outline-secondary btn-sm">
                        <i class="material-icons mr-1" style="font-size: 16px;">clear</i>
                        Clear
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Supplier Deliveries Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">local_shipping</i>
                Supplier Deliveries
            </h5>
        </div>
        <div class="card-body p-0">
            <?php if(isset($deliveries) && $deliveries->count() > 0): ?>
                <div class="warehouse-table-container">
                    <!-- Loading Overlay -->
                    <div class="warehouse-loading-overlay" id="tableLoadingOverlay" style="display: none;">
                        <div class="warehouse-loading-content">
                            <div class="text-center">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="sr-only">Loading...</span>
                                </div>
                                <div class="mt-2">Loading deliveries...</div>
                            </div>
                        </div>
                    </div>

                    <!-- Table -->
                    <div class="warehouse-table-wrapper">
                        <table class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 200px;">Operation Details</th>
                                <th style="min-width: 150px;">Supplier</th>
                                <th style="min-width: 140px;">LPO Information</th>
                                <th style="min-width: 120px;">Division</th>
                                <th style="min-width: 120px;">Delivery Date</th>
                                <th style="min-width: 100px;">Status</th>
                                <th style="min-width: 100px;">Items Count</th>
                                <th style="min-width: 130px;">Total Amount</th>
                                <th style="min-width: 120px;">Received By</th>
                                <th style="min-width: 180px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="white-space: nowrap;">
                                        <div class="d-flex align-items-center">
                                            <div class="mr-3">
                                                <div class="bg-primary text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 40px; height: 40px;">
                                                    <i class="material-icons" style="font-size: 18px;">local_shipping</i>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="font-weight-medium"><?php echo e($delivery->operation_number); ?></div>
                                                <small class="text-muted"><?php echo e($delivery->delivery_note_number ?? 'N/A'); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            <div class="font-weight-medium"><?php echo e($delivery->supplier->name ?? 'N/A'); ?></div>
                                            <small class="text-muted"><?php echo e($delivery->supplier->supplier_code ?? 'N/A'); ?></small>
                                        </div>
                                    </td>
                                    <td>
                                        <div>
                                            <div class="font-weight-medium"><?php echo e($delivery->lpo_number ?? 'N/A'); ?></div>
                                            <small class="text-muted"><?php echo e(ucfirst($delivery->lpo_status ?? 'pending')); ?></small>
                                        </div>
                                    </td>
                                    <td><?php echo e($delivery->division ?? 'N/A'); ?></td>
                                    <td><?php echo e($delivery->operation_date ? $delivery->operation_date->format('d-M-Y') : 'N/A'); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo e($delivery->status === 'completed' ? 'success' :
                                            ($delivery->status === 'delivered' ? 'info' :
                                            ($delivery->status === 'pending_delivery' ? 'warning' : 'secondary'))); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $delivery->status))); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-light"><?php echo e($delivery->items_count); ?> items</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span class="dirham-symbol text-dark mr-1" style="width: 16px; height: 16px; display: inline-flex; align-items: center;">
                                                <svg viewBox="0 0 1000 870" width="16" height="16" style="fill: currentColor;">
                                                    <path d="m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.7 0.6 19.7 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z"/>
                                                </svg>
                                            </span>
                                            <div>
                                                <div class="font-weight-medium text-dark"><?php echo e(number_format($delivery->total_amount ?? 0, 2)); ?></div>
                                                <?php if(isset($delivery->currency) && $delivery->currency !== 'AED'): ?>
                                                    <small class="text-muted"><?php echo e($delivery->currency); ?> <?php echo e(number_format($delivery->original_amount ?? 0, 2)); ?></small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e($delivery->received_by_name ?? 'N/A'); ?></td>
                                    <td style="white-space: nowrap;">
                                        <div class="d-flex align-items-center">
                                            <?php if($delivery->type === 'standard'): ?>
                                                <!-- Standard Delivery Actions -->
                                                <!-- View Button -->
                                                <a href="<?php echo e(route('warehouse.incoming-operations.show', $delivery->id)); ?>" class="btn btn-sm btn-info mr-1" title="View">
                                                    <i class="material-icons mr-1" style="font-size: 14px;">visibility</i>
                                                    View
                                                </a>
                                                <!-- Print Button -->
                                                <button onclick="printDeliveryNote(<?php echo e($delivery->id); ?>)" class="btn btn-sm btn-outline-info" title="Print">
                                                    <i class="material-icons" style="font-size: 14px;">print</i>
                                                </button>
                                            <?php else: ?>
                                                <!-- Direct Delivery Actions -->
                                                <?php
                                                    $actualId = str_replace('DD_', '', $delivery->id);
                                                ?>
                                                <!-- View Button -->
                                                <a href="<?php echo e(route('warehouse.direct-deliveries.show', $actualId)); ?>" class="btn btn-sm btn-info mr-1" title="View Direct Delivery">
                                                    <i class="material-icons mr-1" style="font-size: 14px;">visibility</i>
                                                    View
                                                </a>
                                                <!-- Print Button -->
                                                <a href="<?php echo e(route('warehouse.direct-deliveries.print', $actualId)); ?>" class="btn btn-sm btn-outline-info" title="Print Direct Delivery">
                                                    <i class="material-icons" style="font-size: 14px;">print</i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    </div>
                </div>

                <!-- Pagination -->
                <?php if(isset($deliveries) && $deliveries->hasPages()): ?>
                    <div class="mt-3">
                        <?php echo e($deliveries->links('pagination::bootstrap-4')); ?>

                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="material-icons text-muted mb-3" style="font-size: 64px;">local_shipping</i>
                    <h5 class="text-muted">No Supplier Deliveries Found</h5>
                    <p class="text-muted">No supplier deliveries match your current filters</p>
                    <a href="<?php echo e(route('warehouse.supplier-delivery.create')); ?>" class="btn btn-primary">
                        <i class="material-icons mr-1" style="font-size: 18px;">add</i>
                        Create First Delivery
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Quick Statistics -->
    <div class="row mt-4">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">trending_up</i>
                        Recent Activity
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex align-items-center px-0">
                            <div class="mr-3">
                                <div class="bg-success text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 32px; height: 32px;">
                                    <i class="material-icons" style="font-size: 16px;">check</i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">Today's Completions</h6>
                                <small class="text-muted"><?php echo e($statistics['completed_today'] ?? 0); ?> deliveries completed</small>
                            </div>
                        </div>
                        <div class="list-group-item d-flex align-items-center px-0">
                            <div class="mr-3">
                                <div class="bg-warning text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 32px; height: 32px;">
                                    <i class="material-icons" style="font-size: 16px;">schedule</i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">Pending Deliveries</h6>
                                <small class="text-muted"><?php echo e($statistics['pending_delivery'] ?? 0); ?> awaiting delivery</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2">business</i>
                        Top Suppliers
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <?php if(isset($topSuppliers)): ?>
                            <?php $__currentLoopData = $topSuppliers->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item d-flex align-items-center px-0">
                                    <div class="mr-3">
                                        <div class="bg-info text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 32px; height: 32px;">
                                            <span style="font-size: 12px; font-weight: bold;"><?php echo e(substr($supplier->name, 0, 1)); ?></span>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h6 class="mb-0"><?php echo e($supplier->name); ?></h6>
                                        <small class="text-muted"><?php echo e($supplier->deliveries_count); ?> deliveries</small>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="text-center py-3">
                                <small class="text-muted">No supplier data available</small>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
<script>
        function applyFilters() {
            // Build URL with query parameters
            const baseUrl = '<?php echo e(route("warehouse.supplier-delivery.index")); ?>';
            const params = new URLSearchParams();

            // Get filter values
            const status = $('#filter-status').val();
            const supplierId = $('#filter-supplier').val();
            const division = $('#filter-division').val();
            const lpoStatus = $('#filter-lpo-status').val();
            const dateFrom = $('#filter-date-from').val();
            const dateTo = $('#filter-date-to').val();

            // Add non-empty filters to params
            if (status) params.append('status', status);
            if (supplierId) params.append('supplier_id', supplierId);
            if (division) params.append('division', division);
            if (lpoStatus) params.append('lpo_status', lpoStatus);
            if (dateFrom) params.append('date_from', dateFrom);
            if (dateTo) params.append('date_to', dateTo);

            // Redirect with filters
            const queryString = params.toString();
            window.location.href = queryString ? `${baseUrl}?${queryString}` : baseUrl;
        }

        function clearFilters() {
            // Clear all filter inputs
            $('#filter-status').val('');
            $('#filter-supplier').val('');
            $('#filter-division').val('');
            $('#filter-lpo-status').val('');
            $('#filter-date-from').val('');
            $('#filter-date-to').val('');

            // Redirect to base URL without filters
            window.location.href = '<?php echo e(route("warehouse.supplier-delivery.index")); ?>';
        }

        // Set filter values from URL on page load
        $(document).ready(function() {
            const urlParams = new URLSearchParams(window.location.search);

            if (urlParams.has('status')) $('#filter-status').val(urlParams.get('status'));
            if (urlParams.has('supplier_id')) $('#filter-supplier').val(urlParams.get('supplier_id'));
            if (urlParams.has('division')) $('#filter-division').val(urlParams.get('division'));
            if (urlParams.has('lpo_status')) $('#filter-lpo-status').val(urlParams.get('lpo_status'));
            if (urlParams.has('date_from')) $('#filter-date-from').val(urlParams.get('date_from'));
            if (urlParams.has('date_to')) $('#filter-date-to').val(urlParams.get('date_to'));
        });

        function exportDeliveries() {
            const btn = event.target.closest('button');
            const originalHtml = btn.innerHTML;
            btn.innerHTML = '<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Exporting...';
            btn.disabled = true;

            setTimeout(() => {
                btn.innerHTML = originalHtml;
                btn.disabled = false;
                alert('Export functionality will be implemented');
            }, 1000);
        }

        function printDeliveryNote(deliveryId) {
            const printUrl = `<?php echo e(url('warehouse/incoming-operations')); ?>/${deliveryId}/print`;
            const printWindow = window.open(printUrl, '_blank');

            // Wait for the print window to load, then trigger print
            printWindow.onload = function() {
                setTimeout(function() {
                    printWindow.print();
                    // Optional: Close the print window after printing
                    printWindow.onafterprint = function() {
                        printWindow.close();
                    };
                }, 1000);
            };
        }

        // Auto-refresh every 5 minutes
        setInterval(() => {
            window.location.reload();
        }, 300000);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/supplier-delivery/index.blade.php ENDPATH**/ ?>