<?php $__env->startSection('title', 'FOC Summary Report'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouse.reports.index')); ?>">Reports</a></li>
    <li class="breadcrumb-item active">FOC Summary</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title-left">
        <h3 class="mb-1">FOC Summary Report</h3>
        <p class="text-muted mb-0" style="font-size: 13px;">Item-wise overview of damaged inventory</p>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
    <div class="row mb-4 warehouse-stats-row">
        <div class="col-xl-2 col-md-4 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Items','value' => $itemSummaries->total(),'icon' => 'inventory_2','color' => 'primary','subtitle' => 'Unique items affected']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Items','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($itemSummaries->total()),'icon' => 'inventory_2','color' => 'primary','subtitle' => 'Unique items affected']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-2 col-md-4 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Records','value' => $totalRecords,'icon' => 'warning','color' => 'danger','subtitle' => 'Damage records']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Records','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($totalRecords),'icon' => 'warning','color' => 'danger','subtitle' => 'Damage records']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-2 col-md-4 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Quantity','value' => number_format($totalQuantity, 2),'icon' => 'inventory','color' => 'warning','subtitle' => 'Units damaged']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Quantity','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($totalQuantity, 2)),'icon' => 'inventory','color' => 'warning','subtitle' => 'Units damaged']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-2 col-md-4 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Total Cost','value' => number_format($totalCost, 2),'icon' => 'attach_money','color' => 'info','subtitle' => 'Total damage value','currency' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Total Cost','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($totalCost, 2)),'icon' => 'attach_money','color' => 'info','subtitle' => 'Total damage value','currency' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-2 col-md-4 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'FOC Available','value' => number_format($totalFocAvailable, 2),'icon' => 'recycling','color' => 'success','subtitle' => 'Recoverable stock']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'FOC Available','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($totalFocAvailable, 2)),'icon' => 'recycling','color' => 'success','subtitle' => 'Recoverable stock']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>

        <div class="col-xl-2 col-md-4 mb-3">
            <?php if (isset($component)) { $__componentOriginal53d5433fafb0333176bb03156a86e49f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal53d5433fafb0333176bb03156a86e49f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.stats-card','data' => ['title' => 'Net Loss','value' => number_format($totalLoss, 2),'icon' => 'trending_down','color' => 'danger','subtitle' => 'Unrecoverable value','currency' => true]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.stats-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Net Loss','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(number_format($totalLoss, 2)),'icon' => 'trending_down','color' => 'danger','subtitle' => 'Unrecoverable value','currency' => true]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $attributes = $__attributesOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__attributesOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal53d5433fafb0333176bb03156a86e49f)): ?>
<?php $component = $__componentOriginal53d5433fafb0333176bb03156a86e49f; ?>
<?php unset($__componentOriginal53d5433fafb0333176bb03156a86e49f); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Filters Panel -->
    <div class="card mb-4 warehouse-filters-panel">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="material-icons align-middle mr-2">filter_list</i>
                Filters
            </h5>
        </div>
        <div class="card-body">
            <form id="filterForm" class="warehouse-filter-form" method="GET" action="<?php echo e(route('warehouse.reports.damaged-items')); ?>">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" value="<?php echo e(request('search')); ?>"
                               placeholder="Item code, description..." class="form-control">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Category</label>
                        <select name="category_id" class="form-control warehouse-select2" data-placeholder="Search categories...">
                            <option value="">All Categories</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->category_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Project</label>
                        <select name="project_id" class="form-control warehouse-select2" data-placeholder="Search projects...">
                            <option value="">All Projects</option>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($project->id); ?>" <?php echo e(request('project_id') == $project->id ? 'selected' : ''); ?>>
                                    <?php echo e($project->project_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" class="form-control warehouse-datepicker">
                    </div>

                    <div class="col-md-2 mb-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>" class="form-control warehouse-datepicker">
                    </div>

                    <div class="col-md-1 mb-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">search</i>
                            </button>
                            <a href="<?php echo e(route('warehouse.reports.damaged-items')); ?>" class="btn btn-outline-secondary">
                                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">clear</i>
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Export Buttons -->
    <div class="row warehouse-export-buttons mb-3">
        <div class="col-12 text-right">
            <button class="btn btn-success warehouse-export-btn" onclick="exportData('excel')">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">download</i>
                Export Excel
            </button>
            <button class="btn btn-info warehouse-export-btn" onclick="exportData('pdf')">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">picture_as_pdf</i>
                Export PDF
            </button>
            <button class="btn btn-secondary warehouse-export-btn" onclick="window.print()">
                <i class="material-icons" style="font-size: 18px; vertical-align: middle;">print</i>
                Print
            </button>
        </div>
    </div>

    <!-- Damaged Items Summary Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">warning</i>
                FOC Summary (<?php echo e($itemSummaries->total()); ?> unique items)
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay" style="display: none;">
                    <div class="warehouse-loading-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading damaged items summary...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 250px;">Item</th>
                                <th style="min-width: 100px;">Category</th>
                                <th style="min-width: 80px;" class="text-right">Records</th>
                                <th style="min-width: 100px;" class="text-right">Total Qty</th>
                                <th style="min-width: 100px;" class="text-right">Total Cost</th>
                                <th style="min-width: 100px;" class="text-right">FOC Available</th>
                                <th style="min-width: 100px;" class="text-right">Loss Amount</th>
                                <th style="min-width: 100px;">Status Distribution</th>
                                <th style="min-width: 80px;" class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $itemSummaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $summary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="mr-3">
                                                <div class="bg-warning text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 35px; height: 35px;">
                                                    <i class="material-icons" style="font-size: 18px;">inventory_2</i>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="font-weight-medium">
                                                    <?php echo e(Str::limit($summary->item_description ?? 'Unknown Item', 45)); ?>

                                                </div>
                                                <small class="text-muted"><?php echo e($summary->item_code ?? 'No code'); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge warehouse-badge warehouse-status-secondary">
                                            <?php echo e($summary->category_name ?? 'No Category'); ?>

                                        </span>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <strong><?php echo e($summary->record_count); ?></strong>
                                        <br><small class="text-muted">records</small>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <strong><?php echo e(number_format($summary->total_quantity, 2)); ?></strong>
                                        <br><small class="text-muted"><?php echo e($summary->unit ?? 'units'); ?></small>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <div class="d-flex align-items-center justify-content-end">
                                            <span class="dirham-symbol text-dark mr-1" style="width: 16px; height: 16px; display: inline-flex; align-items: center;">
                                                <svg viewBox="0 0 1000 870" width="16" height="16" style="fill: currentColor;">
                                                    <path d="m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.3 0.7 19.2 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z"></path>
                                                </svg>
                                            </span>
                                            <div class="font-weight-medium text-dark"><?php echo e(number_format($summary->total_cost, 2)); ?></div>
                                        </div>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <strong class="text-success"><?php echo e(number_format($summary->foc_available, 2)); ?></strong>
                                        <br><small class="text-muted">available</small>
                                    </td>
                                    <td class="text-right warehouse-cell-number">
                                        <div class="d-flex align-items-center justify-content-end">
                                            <span class="dirham-symbol text-danger mr-1" style="width: 16px; height: 16px; display: inline-flex; align-items: center;">
                                                <svg viewBox="0 0 1000 870" width="16" height="16" style="fill: currentColor;">
                                                    <path d="m88.3 1c0.4 0.6 2.6 3.3 4.7 5.9 15.3 18.2 26.8 47.8 33 85.1 4.1 24.5 4.3 32.2 4.3 125.6v87h-41.8c-38.2 0-42.6-0.2-50.1-1.7-11.8-2.5-24-9.2-32.2-17.8-6.5-6.9-6.3-7.3-5.9 13.6 0.5 17.3 0.7 19.2 3.2 28.6 4 14.9 9.5 26 17.8 35.9 11.3 13.6 22.8 21.2 39.2 26.3 3.5 1 10.9 1.4 37.1 1.6l32.7 0.5v43.3 43.4l-46.1-0.3-46.3-0.3-8-3.2c-9.5-3.8-13.8-6.6-23.1-14.9l-6.8-6.1 0.4 19.1c0.5 17.3 0.7 19.2 3.1 28.7 8.7 31.8 29.7 54.5 57.4 61.9 6.9 1.9 9.6 2 38.5 2.4l30.9 0.4v89.6c0 54.1-0.3 94-0.8 100.8-0.5 6.2-2.1 17.8-3.5 25.9-6.5 37.3-18.2 65.4-35 83.6l-3.4 3.7h169.1c101.1 0 176.7-0.4 187.8-0.9 19.5-1 63-5.3 72.8-7.4 3.1-0.6 8.9-1.5 12.7-2.1 8.1-1.2 21.5-4 40.8-8.9 27.2-6.8 52-15.3 76.3-26.1 7.6-3.4 29.4-14.5 35.2-18 3.1-1.8 6.8-4 8.2-4.7 3.9-2.1 10.4-6.3 19.9-13.1 4.7-3.4 9.4-6.7 10.4-7.4 4.2-2.8 18.7-14.9 25.3-21 25.1-23.1 46.1-48.8 62.4-76.3 2.3-4 5.3-9 6.6-11.1 3.3-5.6 16.9-33.6 18.2-37.8 0.6-1.9 1.4-3.9 1.8-4.3 2.6-3.4 17.6-50.6 19.4-60.9 0.6-3.3 0.9-3.8 3.4-4.3 1.6-0.3 24.9-0.3 51.8-0.1 53.8 0.4 53.8 0.4 65.7 5.9 6.7 3.1 8.7 4.5 16.1 11.2 9.7 8.7 8.8 10.1 8.2-11.7-0.4-12.8-0.9-20.7-1.8-23.9-3.4-12.3-4.2-14.9-7.2-21.1-9.8-21.4-26.2-36.7-47.2-44l-8.2-3-33.4-0.4-33.3-0.5 0.4-11.7c0.4-15.4 0.4-45.9-0.1-61.6l-0.4-12.6 44.6-0.2c38.2-0.2 45.3 0 49.5 1.1 12.6 3.5 21.1 8.3 31.5 17.8l5.8 5.4v-14.8c0-17.6-0.9-25.4-4.5-37-7.1-23.5-21.1-41-41.1-51.8-13-7-13.8-7.2-58.5-7.5-26.2-0.2-39.9-0.6-40.6-1.2-0.6-0.6-1.1-1.6-1.1-2.4 0-0.8-1.5-7.1-3.5-13.9-23.4-82.7-67.1-148.4-131-197.1-8.7-6.7-30-20.8-38.6-25.6-3.3-1.9-6.9-3.9-7.8-4.5-4.2-2.3-28.3-14.1-34.3-16.6-3.6-1.6-8.3-3.6-10.4-4.4-35.3-15.3-94.5-29.8-139.7-34.3-7.4-0.7-17.2-1.8-21.7-2.2-20.4-2.3-48.7-2.6-209.4-2.6-135.8 0-169.9 0.3-169.4 1zm330.7 43.3c33.8 2 54.6 4.6 78.9 10.5 74.2 17.6 126.4 54.8 164.3 117 3.5 5.8 18.3 36 20.5 42.1 10.5 28.3 15.6 45.1 20.1 67.3 1.1 5.4 2.6 12.6 3.3 16 0.7 3.3 1 6.4 0.7 6.7-0.5 0.4-100.9 0.6-223.3 0.5l-222.5-0.2-0.3-128.5c-0.1-70.6 0-129.3 0.3-130.4l0.4-1.9h71.1c39 0 78 0.4 86.5 0.9zm297.5 350.3c0.7 4.3 0.7 77.3 0 80.9l-0.6 2.7-227.5-0.2-227.4-0.3-0.2-42.4c-0.2-23.3 0-42.7 0.2-43.1 0.3-0.5 97.2-0.8 227.7-0.8h227.2zm-10.2 171.7c0.5 1.5-1.9 13.8-6.8 33.8-5.6 22.5-13.2 45.2-20.9 62-3.8 8.6-13.3 27.2-15.6 30.7-1.1 1.6-4.3 6.7-7.1 11.2-18 28.2-43.7 53.9-73 72.9-10.7 6.8-32.7 18.4-38.6 20.2-1.2 0.3-2.5 0.9-3 1.3-0.7 0.6-9.8 4-20.4 7.8-19.5 6.9-56.6 14.4-86.4 17.5-19.3 1.9-22.4 2-96.7 2h-76.9v-129.7-129.8l220.9-0.4c121.5-0.2 221.6-0.5 222.4-0.7 0.9-0.1 1.8 0.5 2.1 1.2z"></path>
                                                </svg>
                                            </span>
                                            <div class="font-weight-medium text-danger"><?php echo e(number_format($summary->loss_amount, 2)); ?></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-wrap gap-1">
                                            <?php if($summary->pending_count > 0): ?>
                                                <span class="badge badge-warning" style="font-size: 10px;">
                                                    <?php echo e($summary->pending_count); ?> Pending
                                                </span>
                                            <?php endif; ?>
                                            <?php if($summary->approved_count > 0): ?>
                                                <span class="badge badge-success" style="font-size: 10px;">
                                                    <?php echo e($summary->approved_count); ?> Approved
                                                </span>
                                            <?php endif; ?>
                                            <?php if($summary->settled_count > 0): ?>
                                                <span class="badge badge-primary" style="font-size: 10px;">
                                                    <?php echo e($summary->settled_count); ?> Settled
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <a href="<?php echo e(route('warehouse.reports.damaged-items-details', $summary->item_id)); ?><?php echo e(request()->getQueryString() ? '?' . request()->getQueryString() : ''); ?>"
                                           class="btn btn-sm btn-outline-primary warehouse-action-btn"
                                           title="View Details">
                                            <i class="material-icons" style="font-size: 18px;">visibility</i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <div class="warehouse-empty-state">
                                            <i class="material-icons" style="font-size: 48px; color: #ddd;">inventory_2</i>
                                            <p class="text-muted mt-2 mb-0">No damaged items found</p>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <?php if($itemSummaries->hasPages()): ?>
            <div class="card-footer">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        Showing <?php echo e($itemSummaries->firstItem()); ?> to <?php echo e($itemSummaries->lastItem()); ?>

                        of <?php echo e($itemSummaries->total()); ?> items
                    </div>
                    <div>
                        <nav class="warehouse-pagination">
                            <?php echo e($itemSummaries->links('pagination::bootstrap-4')); ?>

                        </nav>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        /* Select2 Custom Styling for Warehouse Theme */
        .select2-container--default .select2-selection--single {
            height: calc(1.5em + 0.75rem + 2px);
            padding: 0.375rem 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: calc(1.5em + 0.75rem);
            padding-left: 0;
            color: #495057;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: calc(1.5em + 0.75rem);
            right: 10px;
        }

        .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }

        .select2-container--default .select2-search--dropdown .select2-search__field {
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            padding: 0.375rem 0.75rem;
        }

        .select2-container--default .select2-results__option--highlighted {
            background-color: #007bff;
            color: white;
        }

        .select2-container--default .select2-results__option[aria-selected=true] {
            background-color: #e9ecef;
            color: #495057;
        }

        .warehouse-select2 {
            width: 100% !important;
        }

        /* Alternating row colors */
        .warehouse-table tbody tr:nth-child(even) {
            background-color: #f8f5f0;
        }

        .warehouse-table tbody tr:hover {
            background-color: #e9ecef;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>

    <script>
        function exportData(format) {
            const currentUrl = new URL(window.location);
            currentUrl.searchParams.set('export', format);
            window.open(currentUrl.toString(), '_blank');
        }

        // FORCE Select2 immediately when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            console.log('🚀 DOM loaded, forcing Select2 initialization...');

            // Wait for jQuery to be available
            var checkJQuery = setInterval(function() {
                if (typeof $ !== 'undefined' && typeof $.fn.select2 !== 'undefined') {
                    clearInterval(checkJQuery);
                    initSearchableDropdowns();
                }
            }, 100);

            function initSearchableDropdowns() {
                console.log('🔧 Initializing searchable dropdowns...');

                $('.warehouse-select2').each(function() {
                    var $select = $(this);
                    var placeholder = $select.data('placeholder') || 'Select an option...';

                    // Force destroy any existing select2
                    if ($select.hasClass('select2-hidden-accessible')) {
                        $select.select2('destroy');
                    }

                    // Initialize with search enabled
                    $select.select2({
                        width: '100%',
                        placeholder: placeholder,
                        allowClear: true,
                        minimumResultsForSearch: 0, // Always show search
                        templateResult: function(item) {
                            return item.text;
                        },
                        templateSelection: function(item) {
                            return item.text;
                        }
                    });

                    console.log('✅ Searchable dropdown created for:', $select.attr('name'));
                });
            }

            // Also try after a delay to override other scripts
            setTimeout(initSearchableDropdowns, 500);
            setTimeout(initSearchableDropdowns, 1000);
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/reports/damaged-items-summary.blade.php ENDPATH**/ ?>