<?php $__env->startSection('title', 'Projects'); ?>


<!-- Last updated: <?php echo e(now()); ?> -->

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item">Warehouse</li>
    <li class="breadcrumb-item active">Projects</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Projects</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Manage project names and details</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.projects.create')): ?>
        <div class="page-actions-right d-flex align-items-center">
            <button onclick="syncExternalData()" class="btn btn-sm btn-warning" title="Sync projects from external database">
                <i class="material-icons mr-1" style="font-size: 16px;">sync</i>
                Sync Data
            </button>
        </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Projects Table -->
    <div class="card">
        <div class="card-header warehouse-report-header">
            <h5 class="mb-0 warehouse-report-title">
                <i class="material-icons align-middle mr-2">work</i>
                Projects List
            </h5>
        </div>
        <div class="card-body p-0">
            <div class="warehouse-table-container">
                <!-- Loading Overlay -->
                <div class="warehouse-loading-overlay" id="tableLoadingOverlay" style="display: none;">
                    <div class="warehouse-loading-content">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                            <div class="mt-2">Loading projects...</div>
                        </div>
                    </div>
                </div>

                <!-- Table -->
                <div class="warehouse-table-wrapper">
                    <table id="projects-table" class="table table-hover mb-0 warehouse-table">
                        <thead class="thead-light">
                            <tr>
                                <th style="min-width: 140px;">Project Number</th>
                                <th style="min-width: 120px;">Project ID</th>
                                <th style="min-width: 250px;">Project Name</th>
                                <th style="min-width: 120px;">Division</th>
                                <th style="min-width: 120px;">Created Date</th>
                                <th style="min-width: 180px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Data will be populated by DataTables -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Project Modal -->
    <div class="modal fade" id="addProjectModal" tabindex="-1" role="dialog" aria-labelledby="addProjectModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addProjectModalLabel">
                        <i class="material-icons mr-2">work</i>
                        Add New Project
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="addProjectForm">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="project_number">Project Number</label>
                            <input type="text" name="project_number" id="project_number" class="form-control" placeholder="Auto-generated if left blank">
                            <div class="invalid-feedback"></div>
                            <small class="form-text text-muted">Leave blank to auto-generate project number</small>
                        </div>
                        <div class="form-group">
                            <label for="project_name">Project Name <span class="text-danger">*</span></label>
                            <input type="text" name="project_name" id="project_name" class="form-control" required>
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="form-group">
                            <label for="project_division_id">Project Division <span class="text-danger">*</span></label>
                            <select name="project_division_id" id="project_division_id" class="form-control" required>
                                <option value="">Select a division</option>
                                <?php $__currentLoopData = \App\Models\Warehouse\ProjectDivision::where('status', 'active')->orderBy('division_name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($division->id); ?>"><?php echo e($division->division_name); ?> (<?php echo e($division->division_code); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" onclick="saveProject()" class="btn btn-primary">
                        <i class="material-icons mr-1" style="font-size: 16px;">save</i>
                        Save Project
                    </button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin-assets/css/warehouse-reports.css')); ?>">
    <style>
        .btn-sm {
            padding: 6px 12px;
            font-size: 12px;
            line-height: 1.5;
            border-radius: 4px;
        }

        .btn-sm .material-icons {
            font-size: 16px !important;
        }

        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
            background-color: #f8f9fa;
        }

        .table-responsive {
            border-radius: 0.375rem;
        }

        /* Modal z-index fix */
        .modal,
        #addProjectModal {
            z-index: 999999 !important;
            position: fixed !important;
        }

        .modal-backdrop,
        .modal-backdrop.fade,
        .modal-backdrop.show {
            z-index: 999998 !important;
            position: fixed !important;
        }

        .modal-dialog {
            z-index: 1000000 !important;
            position: relative !important;
        }

        .modal-content {
            z-index: 1000001 !important;
            position: relative !important;
        }

        /* Force modal to appear above everything */
        .modal.show,
        .modal.fade.show {
            display: block !important;
            z-index: 999999 !important;
            opacity: 1 !important;
        }

        /* Override any potential conflicts */
        .modal * {
            position: relative;
        }

        /* Ensure body doesn't scroll when modal is open */
        body.modal-open {
            overflow: hidden !important;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('admin-assets/js/warehouse-reports.js')); ?>"></script>
    <script>
        let projectsTable;

        let projectsInitialized = false;

        function initializeProjectsPage() {
            if (projectsInitialized) {
                console.log('⚠️ Projects page already initialized, skipping...');
                return;
            }

            console.log('🔧 Initializing projects page...');
            initializeDataTable();

            // Entries per page change handler
            $('#entries-per-page').change(function() {
                if (projectsTable) {
                    projectsTable.page.len($(this).val()).draw();
                }
            });

            projectsInitialized = true;
        }

        // Listen for the custom dataTablesReady event
        window.addEventListener('dataTablesReady', function() {
            console.log('🎉 Projects: DataTables ready event received!');
            initializeProjectsPage();
        });

        $(document).ready(function() {
            console.log('📄 Projects page ready, checking if DataTables is available...');

            // Override the warehouse-reports.js pagination handler for DataTables
            $(document).off('click', '.warehouse-pagination a, .pagination a');

            // Hide any leftover loading overlays
            $('#tableLoadingOverlay').hide();

            // Wait a bit then check if DataTables is available
            setTimeout(function() {
                if (typeof $ !== 'undefined' && typeof $.fn.DataTable !== 'undefined' && !projectsInitialized) {
                    console.log('✅ Projects: DataTables found on document ready, initializing...');
                    initializeProjectsPage();
                } else if (!projectsInitialized) {
                    console.log('⏳ Projects: DataTables not ready yet, waiting for dataTablesReady event...');
                }
            }, 1000); // Wait a bit longer for projects page
        });

        function initializeDataTable() {
            // Check if DataTables is loaded
            if (typeof $.fn.DataTable === 'undefined') {
                console.error('DataTables library not loaded');
                return;
            }

            // Hide any existing loading overlay before initializing
            $('#tableLoadingOverlay').hide();

            projectsTable = $('#projects-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("warehouse.projects.index")); ?>',
                    type: 'GET',
                    beforeSend: function() {
                        // Optional: Show loading overlay
                        // $('#tableLoadingOverlay').show();
                    },
                    complete: function() {
                        // Hide loading overlay when data is loaded
                        $('#tableLoadingOverlay').hide();
                    },
                    error: function(xhr, error, thrown) {
                        console.error('DataTable AJAX error:', error, thrown);
                        $('#tableLoadingOverlay').hide();
                        showAlert('Error loading data. Please refresh the page.', 'error');
                    }
                },
                columns: [
                    {
                        data: 'project_number',
                        name: 'project_number',
                        render: function(data, type, row) {
                            return `
                                <div>
                                    <div class="font-weight-medium">${data}</div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'project_id',
                        name: 'project_id',
                        render: function(data, type, row) {
                            return `
                                <div>
                                    <div class="font-weight-medium">${data}</div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'project_name',
                        name: 'project_name',
                        render: function(data, type, row) {
                            return `
                                <div class="d-flex align-items-center">
                                    <div class="mr-3">
                                        <div class="bg-success text-white d-flex align-items-center justify-content-center rounded-circle" style="width: 40px; height: 40px;">
                                            <i class="material-icons" style="font-size: 20px;">work</i>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="font-weight-medium">${data}</div>
                                    </div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'division',
                        name: 'division',
                        render: function(data, type, row) {
                            return `
                                <div>
                                    <span class="badge badge-secondary">${data}</span>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'created_at',
                        name: 'created_at',
                        render: function(data, type, row) {
                            return `
                                <div>
                                    <div class="small">${data}</div>
                                    <div class="small text-muted">Created</div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: null,
                        name: 'actions',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `
                                <div class="d-flex align-items-center" style="white-space: nowrap;">
                                    <a href="<?php echo e(url('warehouse/projects')); ?>/${row.id}" class="btn btn-sm btn-info mr-1" title="View Project">
                                        <i class="material-icons mr-1" style="font-size: 14px;">visibility</i>
                                        View
                                    </a>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.projects.edit')): ?>
                                    <a href="<?php echo e(url('warehouse/projects')); ?>/${row.id}/edit" class="btn btn-sm btn-warning mr-1" title="Edit Project">
                                        <i class="material-icons mr-1" style="font-size: 14px;">edit</i>
                                        Edit
                                    </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warehouse.projects.delete')): ?>
                                    <button onclick="deleteProject(${row.id})" class="btn btn-sm btn-danger" title="Delete Project">
                                        <i class="material-icons" style="font-size: 14px;">delete</i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            `;
                        }
                    }
                ],
                order: [[4, 'desc']],
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
                language: {
                    processing: '<div class="text-center"><div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div></div>',
                    emptyTable: 'No projects found',
                    zeroRecords: 'No matching projects found'
                },
                drawCallback: function(settings) {
                    $('#entries-per-page').val(settings._iDisplayLength);
                }
            });
        }

        function deleteProject(id) {
            if (confirm('Are you sure you want to delete this project?')) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: `<?php echo e(url('warehouse/projects')); ?>/${id}`,
                    type: 'DELETE',
                    success: function(response) {
                        if (response.success) {
                            projectsTable.draw();
                            showAlert('Project deleted successfully', 'success');
                        } else {
                            showAlert(response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        showAlert('Error deleting project', 'error');
                    }
                });
            }
        }

        function showAddProjectModal() {
            // Clear form and validation errors
            $('#addProjectForm')[0].reset();
            clearValidationErrors();

            // Force very high z-index before showing
            $('#addProjectModal').css({
                'z-index': 999999,
                'position': 'fixed',
                'display': 'block'
            });

            // Show modal
            $('#addProjectModal').modal({
                backdrop: true,
                keyboard: true,
                show: true
            });

            // Aggressively force z-index after modal is shown
            $('#addProjectModal').on('shown.bs.modal', function() {
                $(this).css({
                    'z-index': 999999,
                    'position': 'fixed'
                });
                $('.modal-backdrop').css({
                    'z-index': 999998,
                    'position': 'fixed'
                });
                $('.modal-dialog').css({
                    'z-index': 1000000,
                    'position': 'relative'
                });
                $('.modal-content').css({
                    'z-index': 1000001,
                    'position': 'relative'
                });

                // Move modal to body if it's not already there
                if (!$('#addProjectModal').parent().is('body')) {
                    $('#addProjectModal').appendTo('body');
                }
            });
        }

        function saveProject() {
            const form = $('#addProjectForm')[0];
            const formData = new FormData(form);

            // Clear previous validation errors
            clearValidationErrors();

            // Disable save button and show loading
            const saveBtn = $('button[onclick="saveProject()"]');
            const originalHtml = saveBtn.html();
            saveBtn.prop('disabled', true);
            saveBtn.html('<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Saving...');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: '<?php echo e(route("warehouse.projects.store")); ?>',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        $('#addProjectModal').modal('hide');
                        projectsTable.draw();
                        showAlert('Project added successfully!', 'success');
                    } else {
                        showAlert(response.message || 'Error adding project', 'error');
                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) {
                        // Validation errors
                        const errors = xhr.responseJSON.errors;
                        displayValidationErrors(errors);
                    } else {
                        showAlert('Error adding project. Please try again.', 'error');
                    }
                },
                complete: function() {
                    // Re-enable save button
                    saveBtn.prop('disabled', false);
                    saveBtn.html(originalHtml);
                }
            });
        }

        function clearValidationErrors() {
            $('.form-control').removeClass('is-invalid');
            $('.invalid-feedback').text('');
        }

        function displayValidationErrors(errors) {
            $.each(errors, function(field, messages) {
                const input = $(`[name="${field}"]`);
                input.addClass('is-invalid');
                input.siblings('.invalid-feedback').text(messages[0]);
            });
        }

        function showAlert(message, type) {
            const alertClass = type === 'success' ? 'alert-success' : (type === 'warning' ? 'alert-warning' : 'alert-danger');

            // Convert newlines to <br> and escape HTML
            const htmlMessage = message.replace(/\n/g, '<br>').replace(/</g, '&lt;').replace(/>/g, '&gt;');

            const alert = `
                <div class="alert ${alertClass} alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999; max-width: 600px; max-height: 80vh; overflow-y: auto;">
                    <div style="font-family: monospace; font-size: 12px; white-space: pre-line;">
                        ${htmlMessage}
                    </div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            `;
            $('body').append(alert);

            // Keep alert visible longer if it contains skip reasons
            const timeout = message.includes('Skip Reasons') ? 15000 : 5000;
            setTimeout(() => $('.alert').alert('close'), timeout);
        }

        function syncExternalData() {
            if (!confirm('This will sync projects from the external database. Continue?')) {
                return;
            }

            const syncBtn = $('button[onclick="syncExternalData()"]');
            const originalHtml = syncBtn.html();

            // Disable button and show loading state
            syncBtn.prop('disabled', true);
            syncBtn.html('<i class="material-icons mr-1" style="font-size: 16px; animation: spin 1s linear infinite;">sync</i>Syncing...');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: '<?php echo e(route("warehouse.projects.sync-external")); ?>',
                type: 'POST',
                timeout: 30000, // 30 second timeout
                success: function(response) {
                    if (response.success) {
                        const data = response.data;
                        let message = `Sync completed! `;
                        message += `Processed: ${data.total_processed}, `;
                        message += `Imported: ${data.imported}, `;
                        message += `Skipped: ${data.skipped}`;

                        if (data.errors > 0) {
                            message += `, Errors: ${data.errors}`;
                        }

                        // Show skip reasons if any projects were skipped
                        if (data.skipped > 0 && data.skip_reasons && data.skip_reasons.length > 0) {
                            message += '\n\nSkip Reasons (first 10):';
                            data.skip_reasons.forEach((reason, index) => {
                                message += '\n' + (index + 1) + '. ' + reason;
                            });
                        }

                        showAlert(message, data.skipped > 0 ? 'warning' : 'success');
                        projectsTable.draw(); // Refresh table
                    } else {
                        showAlert(response.message || 'Sync failed', 'error');
                    }
                },
                error: function(xhr) {
                    let errorMessage = 'Sync failed. ';
                    if (xhr.status === 0) {
                        errorMessage += 'Please check your network connection.';
                    } else if (xhr.status === 500) {
                        errorMessage += 'Server error. Please check your database configuration.';
                    } else {
                        errorMessage += xhr.responseJSON?.message || 'Unknown error occurred.';
                    }
                    showAlert(errorMessage, 'error');
                },
                complete: function() {
                    // Re-enable button
                    syncBtn.prop('disabled', false);
                    syncBtn.html(originalHtml);
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/warehouse/projects/index.blade.php ENDPATH**/ ?>