<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="d-flex justify-content-between align-items-center w-100">
        <div class="page-title-left">
            <h3 class="mb-1">Dashboard</h3>
            <p class="text-muted mb-0" style="font-size: 13px;">Overview of warehouse operations and key metrics</p>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Dashboard Stats -->
    <?php if (isset($component)) { $__componentOriginal8f754248c192eec31d3aada31b64ef4f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8f754248c192eec31d3aada31b64ef4f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.warehouse.dashboard-stats','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('warehouse.dashboard-stats'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8f754248c192eec31d3aada31b64ef4f)): ?>
<?php $attributes = $__attributesOriginal8f754248c192eec31d3aada31b64ef4f; ?>
<?php unset($__attributesOriginal8f754248c192eec31d3aada31b64ef4f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8f754248c192eec31d3aada31b64ef4f)): ?>
<?php $component = $__componentOriginal8f754248c192eec31d3aada31b64ef4f; ?>
<?php unset($__componentOriginal8f754248c192eec31d3aada31b64ef4f); ?>
<?php endif; ?>

    <!-- Quick Actions & Recent Activity -->
    <div class="row">
        <!-- Quick Actions -->
        <div class="col-lg-4 mb-4">
            <div class="card warehouse-card h-100">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">flash_on</i>
                        Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="warehouse-quick-actions">
                        <?php if(auth()->user()->hasPermission('warehouse.incoming.create')): ?>
                        <a href="<?php echo e(route('warehouse.incoming-operations.create')); ?>" class="warehouse-quick-action-btn">
                            <div class="d-flex align-items-center p-3 mb-2 bg-light rounded">
                                <i class="material-icons text-primary mr-3">input</i>
                                <div>
                                    <div class="font-weight-medium">Receive Goods</div>
                                    <small class="text-muted">Record incoming shipment</small>
                                </div>
                            </div>
                        </a>
                        <?php endif; ?>

                        <?php if(auth()->user()->hasPermission('warehouse.outgoing.create')): ?>
                        <a href="<?php echo e(route('warehouse.outgoing.create')); ?>" class="warehouse-quick-action-btn">
                            <div class="d-flex align-items-center p-3 mb-2 bg-light rounded">
                                <i class="material-icons text-success mr-3">output</i>
                                <div>
                                    <div class="font-weight-medium">Dispatch Goods</div>
                                    <small class="text-muted">Create outgoing shipment</small>
                                </div>
                            </div>
                        </a>
                        <?php endif; ?>

                        <?php if(auth()->user()->hasPermission('warehouse.inventory.adjust')): ?>
                        <a href="<?php echo e(route('warehouse.inventory.adjustments')); ?>" class="warehouse-quick-action-btn">
                            <div class="d-flex align-items-center p-3 mb-2 bg-light rounded">
                                <i class="material-icons text-warning mr-3">tune</i>
                                <div>
                                    <div class="font-weight-medium">Adjust Stock</div>
                                    <small class="text-muted">Update inventory levels</small>
                                </div>
                            </div>
                        </a>
                        <?php endif; ?>

                        <?php if(auth()->user()->hasPermission('warehouse.items.create')): ?>
                        <a href="<?php echo e(route('warehouse.items.create')); ?>" class="warehouse-quick-action-btn">
                            <div class="d-flex align-items-center p-3 mb-2 bg-light rounded">
                                <i class="material-icons text-info mr-3">add_box</i>
                                <div>
                                    <div class="font-weight-medium">Add New Item</div>
                                    <small class="text-muted">Register new inventory item</small>
                                </div>
                            </div>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="col-lg-8 mb-4">
            <div class="card warehouse-card h-100">
                <div class="card-header bg-white border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <h6 class="card-title mb-0">
                            <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">history</i>
                            Recent Transactions
                        </h6>
                        <a href="<?php echo e(route('warehouse.reports.transactions')); ?>" class="btn btn-outline-primary btn-sm">
                            View All
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <?php
                            $recentTransactions = \App\Models\Warehouse\IncomingTransaction::with(['supplier', 'items'])->latest()->take(5)->get();
                        ?>
                        <?php $__empty_1 = true; $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="list-group-item border-0">
                            <div class="d-flex align-items-center">
                                <div class="warehouse-activity-icon mr-3">
                                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center"
                                         style="width: 40px; height: 40px;">
                                        <i class="material-icons" style="font-size: 18px;">input</i>
                                    </div>
                                </div>
                                <div class="flex-fill">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <div class="font-weight-medium">
                                                Incoming: <?php echo e($transaction->reference_number); ?>

                                            </div>
                                            <small class="text-muted">
                                                From <?php echo e($transaction->supplier->name ?? 'Unknown Supplier'); ?> •
                                                <?php echo e($transaction->items_count ?? 0); ?> items •
                                                <?php echo e($transaction->created_at->diffForHumans()); ?>

                                            </small>
                                        </div>
                                        <span class="badge badge-<?php echo e($transaction->status === 'completed' ? 'success' : 'warning'); ?>">
                                            <?php echo e(ucfirst($transaction->status)); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="list-group-item border-0 text-center py-4">
                            <i class="material-icons text-muted mb-2" style="font-size: 32px;">inbox</i>
                            <p class="text-muted mb-0">No recent transactions</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts & Reports -->
    <div class="row">
        <!-- Inventory Chart -->
        <div class="col-lg-8 mb-4">
            <div class="card warehouse-card">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">bar_chart</i>
                        Inventory Levels by Category
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="inventoryChart" height="300"></canvas>
                </div>
            </div>
        </div>

        <!-- Top Items -->
        <div class="col-lg-4 mb-4">
            <div class="card warehouse-card">
                <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                        <i class="material-icons mr-2" style="font-size: 18px; vertical-align: middle;">trending_up</i>
                        Top Moving Items
                    </h6>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <?php
                            $topItems = \App\Models\Warehouse\Item::with('inventories')
                                ->get()
                                ->map(function($item) {
                                    $item->total_inventory_quantity = $item->inventories->sum('quantity_available');
                                    return $item;
                                })
                                ->sortByDesc('total_inventory_quantity')
                                ->take(5);
                        ?>
                        <?php $__empty_1 = true; $__currentLoopData = $topItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="list-group-item border-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="font-weight-medium"><?php echo e($item->item_description); ?></div>
                                    <small class="text-muted"><?php echo e($item->item_code); ?></small>
                                </div>
                                <div class="text-right">
                                    <div class="font-weight-bold text-primary"><?php echo e($item->total_inventory_quantity ?? 0); ?></div>
                                    <small class="text-muted"><?php echo e($item->unit_of_measure); ?></small>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="list-group-item border-0 text-center py-4">
                            <p class="text-muted mb-0">No item data available</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sample inventory chart
    var ctx = document.getElementById('inventoryChart').getContext('2d');
    var inventoryChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Electronics', 'Hardware', 'Tools', 'Materials', 'Equipment'],
            datasets: [{
                label: 'Stock Level',
                data: [120, 190, 30, 50, 80],
                backgroundColor: [
                    'rgba(54, 162, 235, 0.8)',
                    'rgba(255, 99, 132, 0.8)',
                    'rgba(255, 205, 86, 0.8)',
                    'rgba(75, 192, 192, 0.8)',
                    'rgba(153, 102, 255, 0.8)'
                ],
                borderColor: [
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 99, 132, 1)',
                    'rgba(255, 205, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin-simple', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kcg/public_html/wms.kcguae.com/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>